/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.game;

import java.awt.Color;
import java.awt.Dimension;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.Renderer2D;
import simplelibrary.opengl.gui.GUI;

public class GameHelper {
    public static final int MODE_2D = 1;
    public static final int MODE_2D_CENTERED = 2;
    public static final int MODE_3D = 3;
    public static final int MODE_HYBRID = 4;
    private int height = 500;
    private int width = 800;
    private Method tickMethod;
    private Method renderMethod;
    private Method renderInitMethod;
    private Method tickInitMethod;
    private String windowTitle;
    public boolean running = true;
    private long lastTime;
    private Color background;
    private float frameOfView = 45.0f;
    private int lastWidth;
    private int lastHeight;
    private boolean hasColorChanged;
    private Object tickInitObject;
    private Object renderInitObject;
    private Object tickObject;
    private Object renderObject;
    private int mode = 1;
    private int tickRate = 20;
    public float guiScale = 1.0f;
    private float lastGuiScale;
    private Thread renderThread;
    private long tickTime;
    private Method finalInitMethod;
    private Object finalInitObject;
    private boolean lightingEnabled;
    private boolean depthTestEnabled;
    private boolean is2D;
    private boolean rebuildRenderSetup;
    private float minRenderDistance = 0.1f;
    private float maxRenderDistance = 100.0f;
    private boolean usingFramebuffer;
    private int stackDepthAtFramebuffer = -1;
    private int boundDepthAtFramebuffer = -1;
    private boolean was2DBeforeFramebuffer;
    private boolean lightingEnabledBeforeFramebuffer;
    private boolean depthTestEnabledBeforeFramebuffer;
    private boolean wasLightingEnabledBeforeFramebuffer;
    private boolean wasDepthTestEnabledBeforeFramebuffer;
    private Object timer = new Object();
    private Object timer2 = new Object();
    private long tickTarget;
    private int multisampleCount;
    private GLFWErrorCallback errCall;
    private long window;
    int[] wHeight = new int[1];
    int[] wWidth = new int[1];

    public void setDisplaySize(Dimension size) {
        this.setDisplaySize(size.width, size.height);
    }

    public void setDisplaySize(int displayWidth, int displayHeight) {
        this.width = displayWidth;
        this.height = displayHeight;
    }

    public void setTickMethod(Method method) {
        if (method != null && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Boolean.TYPE)) {
            throw new IllegalArgumentException("Tick method must have a boolean type argument for if it is the final tick!");
        }
        this.tickMethod = method;
    }

    public void setRenderMethod(Method method) {
        if (method != null && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE)) {
            throw new IllegalArgumentException("Render method must have a int type argument for the time since the last tick!");
        }
        this.renderMethod = method;
    }

    @Deprecated
    public void setInitMethod(Method method) {
        this.setRenderInitMethod(method);
    }

    public void setTickInitMethod(Method method) {
        if (method != null && method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Tick init method can take no arguments!");
        }
        this.tickInitMethod = method;
    }

    public void setFinalInitMethod(Method method) {
        if (method != null && method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Final init method can take no arguments!");
        }
        this.finalInitMethod = method;
    }

    public void setRenderInitMethod(Method method) {
        if (method != null && method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Render init method can take no arguments!");
        }
        this.renderInitMethod = method;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.hasColorChanged = true;
    }

    public void setFrameOfView(float newFOV) {
        this.frameOfView = newFOV;
    }

    public void setWindowTitle(String title) {
        this.windowTitle = title;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.lastHeight = 0;
        this.lastWidth = 0;
    }

    public void setMinRenderDistance(float minDistance) {
        this.minRenderDistance = minDistance;
    }

    public void setRenderRange(float min, float max) {
        this.minRenderDistance = min;
        this.maxRenderDistance = max;
    }

    @Deprecated
    public void setInitObject(Object obj) {
        this.setRenderInitObject(obj);
    }

    public void setTickInitObject(Object obj) {
        this.tickInitObject = obj;
    }

    public void setFinalInitObject(Object obj) {
        this.finalInitObject = obj;
    }

    public void setRenderInitObject(Object obj) {
        this.renderInitObject = obj;
    }

    public void setTickObject(Object obj) {
        this.tickObject = obj;
    }

    public void setRenderObject(Object obj) {
        this.renderObject = obj;
    }

    @Deprecated
    public void setMillisPerTick(int millisPerTick) {
        this.setTickRate((int)(1000.0f / (float)millisPerTick));
    }

    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
    }

    public void setAntiAliasing(int multisampleCount) {
        this.multisampleCount = multisampleCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.tickInitMethod == null && this.renderInitMethod == null && this.finalInitMethod == null) {
            Sys.error(ErrorLevel.warning, "GameHelper Init is unused!  This is probably a bug.", null, ErrorCategory.bug, false);
        }
        if (this.tickMethod == null) {
            Sys.error(ErrorLevel.warning, "GameHelper Tick Loop is unused!  This is probably a bug.", null, ErrorCategory.bug, false);
        }
        if (this.renderMethod == null) {
            throw new IllegalStateException("ERROR:  Cannot create a GameHelper with no render loop!");
        }
        if (this.tickMethod != null && Modifier.isStatic(this.tickMethod.getModifiers()) != (this.tickObject == null)) {
            throw new IllegalStateException("ERROR:  Tick method is " + (Modifier.isStatic(this.tickMethod.getModifiers()) ? "" : "not ") + "static!");
        }
        if (this.renderMethod != null && Modifier.isStatic(this.renderMethod.getModifiers()) != (this.renderObject == null)) {
            throw new IllegalStateException("ERROR:  Render method is " + (Modifier.isStatic(this.renderMethod.getModifiers()) ? "" : "not ") + "static!");
        }
        if (this.tickInitMethod != null && Modifier.isStatic(this.tickInitMethod.getModifiers()) != (this.tickInitObject == null)) {
            throw new IllegalStateException("ERROR:  Tick init method is " + (Modifier.isStatic(this.tickInitMethod.getModifiers()) ? "" : "not ") + "static!");
        }
        if (this.renderInitMethod != null && Modifier.isStatic(this.renderInitMethod.getModifiers()) != (this.renderInitObject == null)) {
            throw new IllegalStateException("ERROR:  Render init method is " + (Modifier.isStatic(this.renderInitMethod.getModifiers()) ? "" : "not ") + "static!");
        }
        if (this.finalInitMethod != null && Modifier.isStatic(this.finalInitMethod.getModifiers()) != (this.finalInitObject == null)) {
            throw new IllegalStateException("ERROR:  Final init method is " + (Modifier.isStatic(this.finalInitMethod.getModifiers()) ? "" : "not ") + "static!");
        }
        this.callFunction("TickInit", this.tickInitMethod, this.tickInitObject, new Object[0]);
        Object object = this.timer;
        synchronized (object) {
            this.tickTime = this.getTime();
        }
        object = this;
        synchronized (object) {
            this.createDisplay();
            this.kickoffRenderThread();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.callFunction("FinalInit", this.finalInitMethod, this.finalInitObject, new Object[0]);
        while (this.running) {
            long curTime;
            long targTime = this.tickTime + (long)(1000000000 / this.tickRate);
            while ((curTime = targTime - this.getTime()) > 0L) {
                if (curTime <= 2000000L) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            GLFW.glfwPollEvents();
            this.callFunction("Tick", this.tickMethod, this.tickObject, false);
            this.tickTime = targTime;
        }
        try {
            this.renderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.destroyDisplay();
        this.callFunction("FinalTick", this.tickMethod, this.tickObject, true);
    }

    private void kickoffRenderThread() {
        this.renderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GLFW.glfwMakeContextCurrent((long)GameHelper.this.window);
                GLFW.glfwSwapInterval((int)1);
                GL.createCapabilities();
                GameHelper gameHelper = GameHelper.this;
                synchronized (gameHelper) {
                    GameHelper.this.callFunction("renderInit", GameHelper.this.renderInitMethod, GameHelper.this.renderInitObject, new Object[0]);
                    GameHelper.this.notifyAll();
                }
                while (GameHelper.this.running) {
                    GameHelper.this.render();
                    if (!GLFW.glfwWindowShouldClose((long)GameHelper.this.window)) continue;
                    GameHelper.this.running = false;
                }
            }
        };
        this.renderThread.setName("GameHelper Render Thread");
        this.renderThread.start();
    }

    private void createDisplay() {
        GLFW.glfwInit();
        this.errCall = GLFWErrorCallback.createPrint((PrintStream)System.err);
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.errCall);
        GLFW.glfwWindowHint((int)131075, (int)1);
        this.window = GLFW.glfwCreateWindow((int)this.width, (int)this.height, (CharSequence)this.windowTitle, (long)0L, (long)0L);
        GLFW.glfwShowWindow((long)this.window);
        this.hasColorChanged = true;
    }

    private void destroyDisplay() {
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
    }

    public long getTime() {
        return System.nanoTime();
    }

    public int displayWidth() {
        return this.wWidth[0];
    }

    public int displayHeight() {
        return this.wHeight[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render() {
        int tTime;
        GLFW.glfwGetFramebufferSize((long)this.window, (int[])this.wWidth, (int[])this.wHeight);
        if (this.displayWidth() != this.lastWidth || this.displayHeight() != this.lastHeight || this.guiScale != this.lastGuiScale || this.rebuildRenderSetup) {
            if (this.is2D && (this.mode == 3 || this.mode == 4)) {
                this.make3D();
            }
            this.rebuildRenderMode(this.mode, this.displayWidth(), this.displayHeight(), this.guiScale);
            this.lastWidth = this.displayWidth();
            this.lastHeight = this.displayHeight();
            this.lastGuiScale = this.guiScale;
        }
        if (this.hasColorChanged) {
            this.refreshBackgroundColor();
        }
        GL11.glClear((int)17664);
        GL11.glLoadIdentity();
        Object object = this.timer;
        synchronized (object) {
            tTime = (int)((this.getTime() - this.tickTime) / 1000000L);
        }
        Object value = this.callFunction("Render", this.renderMethod, this.renderObject, tTime);
        if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
            return;
        }
        GLFW.glfwSwapBuffers((long)this.window);
    }

    public void refreshBackgroundColor() {
        if (this.background == null) {
            this.background = Color.BLACK;
        }
        GL11.glClearColor((float)((float)this.background.getRed() / 255.0f), (float)((float)this.background.getGreen() / 255.0f), (float)((float)this.background.getBlue() / 255.0f), (float)((float)this.background.getAlpha() / 255.0f));
        this.hasColorChanged = false;
    }

    private void rebuildRenderMode(int mode, int width, int height, float guiScale) {
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        switch (mode) {
            case 3: 
            case 4: {
                float aspect = (float)width / (float)height;
                this.setupPerspective();
                break;
            }
            case 1: {
                GL11.glOrtho((double)0.0, (double)((float)width * guiScale), (double)((float)height * guiScale), (double)0.0, (double)0.0, (double)100.0);
                break;
            }
            case 2: {
                GL11.glOrtho((double)((float)(-width) * guiScale / 2.0f), (double)((float)width * guiScale / 2.0f), (double)((float)height * guiScale / 2.0f), (double)((float)(-height) * guiScale / 2.0f), (double)0.0, (double)100.0);
                break;
            }
        }
        GL11.glMatrixMode((int)5888);
    }

    private void setupPerspective() {
        float[] projectionMatrix = new float[16];
        float fieldOfView = this.frameOfView;
        float aspectRatio = (float)this.wWidth[0] / (float)this.wHeight[0];
        float near_plane = this.minRenderDistance;
        float far_plane = this.maxRenderDistance;
        float y_scale = (float)(1.0 / Math.tan(Math.toRadians(fieldOfView / 2.0f)));
        float x_scale = y_scale / aspectRatio;
        float frustum_length = far_plane - near_plane;
        projectionMatrix[0] = x_scale;
        projectionMatrix[5] = y_scale;
        projectionMatrix[10] = -((far_plane + near_plane) / frustum_length);
        projectionMatrix[11] = -1.0f;
        projectionMatrix[14] = -(2.0f * near_plane * far_plane / frustum_length);
        GL11.glLoadMatrixf((float[])projectionMatrix);
    }

    public boolean getMouseButtonState(int button) {
        return GLFW.glfwGetMouseButton((long)this.window, (int)button) == 1;
    }

    public void make2D() {
        if (this.mode != 3 && this.mode != 4) {
            throw new IllegalStateException("Can only be made 2D-3D or back in a 3D mode!");
        }
        if (this.is2D) {
            return;
        }
        this.is2D = true;
        this.lightingEnabled = GL11.glIsEnabled((int)2896);
        GL11.glDisable((int)2896);
        this.depthTestEnabled = GL11.glIsEnabled((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        if (this.mode == 3) {
            float width = (float)this.displayWidth() / (float)this.displayHeight() * this.guiScale;
            GL11.glOrtho((double)(-width), (double)width, (double)this.guiScale, (double)(-this.guiScale), (double)-1.0, (double)1.0);
        } else {
            GL11.glOrtho((double)0.0, (double)((float)this.displayWidth() * this.guiScale), (double)((float)this.displayHeight() * this.guiScale), (double)0.0, (double)0.0, (double)100.0);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2929);
    }

    public void make3D() {
        if (this.mode != 3 && this.mode != 4) {
            throw new IllegalStateException("Can only be made 2D-3D or back in a 3D mode!");
        }
        if (!this.is2D) {
            return;
        }
        this.is2D = false;
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        if (this.depthTestEnabled) {
            GL11.glEnable((int)2929);
        }
        if (this.lightingEnabled) {
            GL11.glEnable((int)2896);
        }
    }

    private Object callFunction(String name, Method method, Object obj, Object ... params) {
        try {
            if (method != null) {
                return method.invoke(obj, params);
            }
        }
        catch (IllegalAccessException ex) {
            Sys.error(ErrorLevel.severe, "Access denied!", ex, ErrorCategory.bug);
        }
        catch (IllegalArgumentException ex) {
            Sys.error(ErrorLevel.severe, "Bug in SimpleLibrary- Illegal method managed to get in!", ex, ErrorCategory.bug);
        }
        catch (InvocationTargetException ex) {
            Sys.error(ErrorLevel.severe, name + " Error!", ex.getCause(), ErrorCategory.uncaught);
        }
        catch (NullPointerException ex) {
            Sys.error(ErrorLevel.severe, name + " method is not static and render object is null!", ex, ErrorCategory.bug);
        }
        return null;
    }

    public void renderTargetFramebuffer(int name, int renderMode, int width, int height, float guiScale) {
        if (name == 0 && this.usingFramebuffer) {
            GL11.glViewport((int)0, (int)0, (int)this.lastWidth, (int)this.lastHeight);
            GL11.glMatrixMode((int)5889);
            if (GL11.glGetInteger((int)2980) > 1) {
                GL11.glPopMatrix();
            }
            GL11.glMatrixMode((int)5888);
            while (GL11.glGetInteger((int)2979) > this.stackDepthAtFramebuffer) {
                GL11.glPopMatrix();
            }
            while (Renderer2D.getBoundStackDepth() > this.boundDepthAtFramebuffer) {
                Renderer2D.popBoundStack();
            }
            if (this.depthTestEnabledBeforeFramebuffer) {
                GL11.glEnable((int)2929);
            } else {
                GL11.glDisable((int)2929);
            }
            if (this.lightingEnabledBeforeFramebuffer) {
                GL11.glEnable((int)2896);
            } else {
                GL11.glDisable((int)2896);
            }
            this.depthTestEnabled = this.wasDepthTestEnabledBeforeFramebuffer;
            this.lightingEnabled = this.wasLightingEnabledBeforeFramebuffer;
            this.is2D = this.was2DBeforeFramebuffer;
            this.stackDepthAtFramebuffer = -1;
            ImageStash.instance.bindBuffer(name);
            this.hasColorChanged = true;
            this.usingFramebuffer = false;
        } else if (name == 0) {
            ImageStash.instance.bindBuffer(name);
            this.hasColorChanged = true;
            this.rebuildRenderSetup = true;
        } else {
            if (!this.usingFramebuffer) {
                this.depthTestEnabledBeforeFramebuffer = GL11.glIsEnabled((int)2929);
                this.lightingEnabledBeforeFramebuffer = GL11.glIsEnabled((int)2896);
                this.wasDepthTestEnabledBeforeFramebuffer = this.depthTestEnabled;
                this.wasLightingEnabledBeforeFramebuffer = this.lightingEnabled;
                this.was2DBeforeFramebuffer = this.is2D;
            }
            this.is2D = false;
            this.stackDepthAtFramebuffer = GL11.glGetInteger((int)2979);
            this.boundDepthAtFramebuffer = Renderer2D.getBoundStackDepth();
            Renderer2D.pushAndClearBoundStack();
            this.usingFramebuffer = true;
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            if (renderMode > 0) {
                this.rebuildRenderMode(renderMode, width, height, guiScale);
            } else {
                GL11.glMatrixMode((int)5888);
            }
            ImageStash.instance.bindBuffer(name);
            GL11.glLoadIdentity();
            if (renderMode == 1) {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-height), (float)0.0f);
            }
        }
    }

    public void assignGUI(final GUI gui) {
        GLFW.glfwSetKeyCallback((long)this.window, (GLFWKeyCallbackI)new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int event, int modifiers) {
                gui.onKeyEvent(key, scancode, event, modifiers);
            }
        });
        GLFW.glfwSetCharCallback((long)this.window, (GLFWCharCallbackI)new GLFWCharCallback(){

            public void invoke(long window, int codepoint) {
                gui.onCharTyped((char)codepoint);
            }
        });
        GLFW.glfwSetCursorPosCallback((long)this.window, (GLFWCursorPosCallbackI)new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                gui.onMouseMoved(xpos, ypos);
            }
        });
        GLFW.glfwSetMouseButtonCallback((long)this.window, (GLFWMouseButtonCallbackI)new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                gui.onMouseButton(button, action, mods);
            }
        });
        GLFW.glfwSetScrollCallback((long)this.window, (GLFWScrollCallbackI)new GLFWScrollCallback(){

            public void invoke(long window, double xoffset, double yoffset) {
                gui.onMouseScrolled(xoffset, yoffset);
            }
        });
        GLFW.glfwSetWindowFocusCallback((long)this.window, (GLFWWindowFocusCallbackI)new GLFWWindowFocusCallback(){

            public void invoke(long window, boolean focused) {
                gui.onWindowFocused(focused);
            }
        });
        GLFW.glfwSetDropCallback((long)this.window, (GLFWDropCallbackI)new GLFWDropCallback(){

            public void invoke(long window, int count, long names) {
                String[] files = new String[count];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = GLFWDropCallback.getName((long)names, (int)i);
                }
                gui.onFileDropped(files);
            }
        });
    }

    public boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)this.window, (int)key) == 1;
    }

    @Deprecated
    public long getWindow() {
        return this.window;
    }
}

