/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import simplelibrary.Queue;
import simplelibrary.Sys;
import simplelibrary.config2.Config;
import simplelibrary.encryption.Encryption;
import simplelibrary.encryption.EncryptionNotFoundException;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.net.PacketSet;
import simplelibrary.net.authentication.Authentication;
import simplelibrary.net.authentication.Authenticator;
import simplelibrary.net.packet.Packet;
import simplelibrary.net.packet.PacketAuthenticated;
import simplelibrary.net.packet.PacketAuthentication;
import simplelibrary.net.packet.PacketAuthenticationConfirmed;
import simplelibrary.net.packet.PacketAuthenticationFailed;
import simplelibrary.net.packet.PacketAuthenticationRequired;
import simplelibrary.net.packet.PacketBoolean;
import simplelibrary.net.packet.PacketCheckEncryption;
import simplelibrary.net.packet.PacketConfig;
import simplelibrary.net.packet.PacketData;
import simplelibrary.net.packet.PacketEncryptionNotSupported;
import simplelibrary.net.packet.PacketEncryptionStart;
import simplelibrary.net.packet.PacketEncryptionSupported;
import simplelibrary.net.packet.PacketInteger;
import simplelibrary.net.packet.PacketLong;
import simplelibrary.net.packet.PacketPing;
import simplelibrary.net.packet.PacketPingTest;
import simplelibrary.net.packet.PacketPingTime;
import simplelibrary.net.packet.PacketRequestEncrypt;
import simplelibrary.net.packet.PacketRequireEncrypt;
import simplelibrary.net.packet.PacketString;
import simplelibrary.net.packet.PacketValidateDatastream;
import simplelibrary.net.packet.notransmit.PacketConnectionFailed;
import simplelibrary.net.packet.notransmit.PacketEncryptionRequested;
import simplelibrary.net.packet.notransmit.PacketEncryptionRequired;
import simplelibrary.net.packet.notransmit.PacketFileTransmission;
import simplelibrary.net.packet.notransmit.PacketInvalidDatastream;

public class ConnectionManager
implements AutoCloseable {
    public static final int TYPE_STREAM = 1;
    public static final int TYPE_PACKET = 2;
    private static final int LISTENER_SERVER = 4;
    private static final int CONNECTION_CLIENT = 8;
    private static final int CONNECTION_SERVER = 16;
    private static final int TYPE_FILE_IN = 32;
    private static final int TYPE_FILE_OUT = 64;
    private static PacketSet defaultPacketSet = new PacketSet();
    private static PacketSet basePacketSet;
    private int invalids;
    private boolean datastreamInvalid;
    private final PacketSet packetSet;
    public final ArrayList<ConnectionManager> connections = new ArrayList();
    public final ArrayList<ConnectionManager> connectionsAuthenticating = new ArrayList();
    public final Queue<Packet> inboundPackets = new Queue();
    private final ArrayList<Packet> encryptionPackets = new ArrayList();
    public final ArrayList<File> receivedFiles = new ArrayList();
    private final Queue<Packet> outboundPackets = new Queue();
    private final Queue<Packet> urgentOutboundPackets = new Queue();
    private final String flushWaitor = Sys.generateRandomString(100);
    private int port;
    private int broadcastPort;
    private int waitingConnectionCount;
    private boolean broadcasting = false;
    private ServerSocket listener;
    private int type;
    private Socket socket;
    private DatagramSocket broadcastSocket;
    private String host;
    private Thread monitor;
    private Thread broadcast;
    protected Thread inbound;
    protected Thread outbound;
    private InputStream in;
    private OutputStream out;
    private InputStream realIn;
    private OutputStream realOut;
    private boolean isClosed = false;
    private int timeout;
    private final ArrayList<Thread> fileOps = new ArrayList();
    private boolean flushable;
    private boolean multithreadedSendingEnabled = true;
    private boolean multithreadedReceivingEnabled = true;
    private final HashMap<String, Object[]> fileOutputStreamsForRecievedFiles = new HashMap();
    private final ArrayList<String> filenames = new ArrayList();
    private Authenticator authenticator;
    private Encryption.ReadyEncryption outboundEncryption;
    private Encryption.ReadyEncryption inboundEncryption;
    private Encryption.ReadyEncryption encryptionToForce;
    private Encryption.ReadyEncryption encryptionRequired;
    private Authentication authentication;
    private ConnectionManager myServer;
    private boolean isAuthenticating;
    private final Object encryptionCheckSync = new Object();

    public static ConnectionManager createServerSide(int port, int waitingConnectionCount, int timeout, int type, Authenticator authenticator, Encryption.ReadyEncryption encryption) throws IOException {
        return ConnectionManager.createServerSide(port, waitingConnectionCount, timeout, type, authenticator, encryption, defaultPacketSet);
    }

    public static ConnectionManager createServerSide(int port, int waitingConnectionCount, int timeout, int type, Authenticator authenticator, Encryption.ReadyEncryption encryption, PacketSet set) throws IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Port number must be a positive integer!");
        }
        if (waitingConnectionCount < 0) {
            throw new IllegalArgumentException("Waiting connection count must be a positive integer!");
        }
        if (type <= 0) {
            throw new IllegalArgumentException("Type must be a positive integer!");
        }
        if (encryption == null) {
            encryption = Encryption.UNENCRYPTED;
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(type | 4);
        connection.setPort(port);
        connection.setWaitingConnectionCount(waitingConnectionCount);
        connection.setTimeout(timeout);
        connection.setAuthenticator(authenticator, encryption);
        connection.start();
        return connection;
    }

    public static ConnectionManager createServerSide(int port, int waitingConnectionCount, int timeout, int type) throws IOException {
        return ConnectionManager.createServerSide(port, waitingConnectionCount, timeout, type, defaultPacketSet);
    }

    public static ConnectionManager createServerSide(int port, int waitingConnectionCount, int timeout, int type, PacketSet set) throws IOException {
        if (port <= 0) {
            throw new IllegalArgumentException("Port number must be a positive integer!");
        }
        if (waitingConnectionCount < 0) {
            throw new IllegalArgumentException("Waiting connection count must be a positive integer!");
        }
        if (type <= 0) {
            throw new IllegalArgumentException("Type must be a positive integer!");
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(type | 4);
        connection.setPort(port);
        connection.setWaitingConnectionCount(waitingConnectionCount);
        connection.setTimeout(timeout);
        connection.start();
        return connection;
    }

    public static ConnectionManager createClientSide(String host, int port, int timeout, int type) throws IOException {
        return ConnectionManager.createClientSide(host, port, timeout, type, defaultPacketSet);
    }

    public static ConnectionManager createClientSide(String host, int port, int timeout, int type, PacketSet set) throws IOException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("A host must be specified!");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Port number must be a positive integer!");
        }
        if (type <= 0) {
            throw new IllegalArgumentException("Type must be a positive integer!");
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(type | 8);
        connection.setHost(host);
        connection.setPort(port);
        connection.setTimeout(timeout);
        connection.start();
        return connection;
    }

    public static ConnectionManager createFileIn(File file) throws IOException {
        return ConnectionManager.createFileIn(file, defaultPacketSet);
    }

    public static ConnectionManager createFileIn(File file, PacketSet set) throws IOException {
        return ConnectionManager.createFileIn(file.getAbsolutePath(), set);
    }

    public static ConnectionManager createFileIn(String filepath) throws IOException {
        return ConnectionManager.createFileIn(filepath, defaultPacketSet);
    }

    public static ConnectionManager createFileIn(String filepath, PacketSet set) throws IOException {
        if (filepath == null || filepath.isEmpty()) {
            throw new IllegalArgumentException("Filepath cannot be empty!");
        }
        if (!new File(filepath).exists()) {
            ConnectionManager manager = new ConnectionManager(set);
            manager.isClosed = true;
            return manager;
        }
        if (new File(filepath).isDirectory()) {
            throw new IllegalArgumentException("Cannot read a directory!");
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(34);
        connection.setHost(filepath);
        connection.multithreadedReceivingEnabled = false;
        connection.start();
        return connection;
    }

    public static ConnectionManager createFileOut(File file) throws IOException {
        return ConnectionManager.createFileOut(file, defaultPacketSet);
    }

    public static ConnectionManager createFileOut(File file, PacketSet set) throws IOException {
        return ConnectionManager.createFileOut(file.getAbsolutePath(), set);
    }

    public static ConnectionManager createFileOut(String filepath) throws IOException {
        return ConnectionManager.createFileOut(filepath, defaultPacketSet);
    }

    public static ConnectionManager createFileOut(String filepath, PacketSet set) throws IOException {
        if (filepath == null || filepath.isEmpty()) {
            throw new IllegalArgumentException("Filepath cannot be empty!");
        }
        if (!new File(filepath).exists()) {
            new File(filepath).getParentFile().mkdirs();
        } else if (new File(filepath).isDirectory()) {
            throw new IllegalArgumentException("Cannot write to a directory!");
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(66);
        connection.setHost(filepath);
        connection.multithreadedSendingEnabled = false;
        connection.start();
        return connection;
    }

    public static ConnectionManager manageInput(InputStream in) throws IOException {
        return ConnectionManager.manageInput(in, defaultPacketSet);
    }

    public static ConnectionManager manageInput(InputStream in, PacketSet set) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Cannot manage nothing!");
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(34);
        connection.in = in;
        connection.start();
        return connection;
    }

    public static ConnectionManager manageOutput(OutputStream out) throws IOException {
        return ConnectionManager.manageOutput(out, defaultPacketSet);
    }

    public static ConnectionManager manageOutput(OutputStream out, PacketSet set) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Cannot manage nothing!");
        }
        ConnectionManager connection = new ConnectionManager(set);
        connection.setType(66);
        connection.out = out;
        connection.start();
        return connection;
    }

    public static void sendPacket(OutputStream out, Packet packet) throws IOException {
        ConnectionManager.sendPacket(out, packet, defaultPacketSet);
    }

    public static void sendPacket(OutputStream out, Packet packet, PacketSet packetSet) throws IOException {
        if (packetSet == null) {
            packetSet = defaultPacketSet;
        }
        try {
            int packetID = packetSet.getIndex(packet.baseInstance());
            if (packetID < 0) {
                for (Packet p : packetSet.packets) {
                    if (p.getClass() != packet.getClass()) continue;
                    Sys.error(ErrorLevel.critical, "Packet type " + packet.getClass().getSimpleName() + " uses inconsistent base instance!", null, ErrorCategory.bug);
                    return;
                }
                Sys.error(ErrorLevel.severe, "Could not transmit unregistered packet " + packet.getClass().getSimpleName() + "!", null, ErrorCategory.bug);
                return;
            }
            DataOutputStream data = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
            data.writeInt(packetID);
            packet.writePacketData(data);
        }
        catch (Throwable ex) {
            Sys.error(ErrorLevel.severe, "Could not send packet " + packet.toString(), ex, ErrorCategory.InternetIO);
            throw new RuntimeException(ex);
        }
    }

    public static Packet readPacket(InputStream in) throws IOException {
        return ConnectionManager.readPacket(in, defaultPacketSet);
    }

    public static Packet readPacket(InputStream in, PacketSet packetSet) throws IOException {
        DataInputStream datastream;
        int packetNumber;
        Packet packet;
        if (packetSet == null) {
            packetSet = defaultPacketSet;
        }
        if ((packet = packetSet.getPacket(packetNumber = (datastream = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in)).readInt()).newInstance()).getClass() != packetSet.getPacket(packetNumber).getClass()) {
            throw new IllegalArgumentException("BUG DETECTED:  " + packetSet.getPacket(packetNumber).getClass().getName() + ".newInstance() returned an instance of " + packet.getClass().getName() + "!");
        }
        packet.readPacketData(datastream);
        return packet;
    }

    public static synchronized void registerPacketClass(Packet instance) {
        defaultPacketSet.registerPacketClass(instance);
    }

    protected ConnectionManager() {
        this(defaultPacketSet);
    }

    protected ConnectionManager(PacketSet set) {
        this.packetSet = set.copy();
    }

    public static void setDefaultPacketSet(PacketSet set) {
        if (set == null) {
            throw new NullPointerException("Cannot set null as a packet set!");
        }
        defaultPacketSet = set;
    }

    public static PacketSet getDefaultPacketSet() {
        return defaultPacketSet.copy();
    }

    public static PacketSet getBasePacketSet() {
        return basePacketSet.copy();
    }

    public PacketSet getPacketSet() {
        return this.packetSet.copy();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet packet) {
        if (this.multithreadedSendingEnabled) {
            Queue<Packet> queue = this.outboundPackets;
            synchronized (queue) {
                this.outboundPackets.enqueue(packet);
            }
        }
        try {
            ConnectionManager.sendPacket(this.out, packet, this.packetSet);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendUrgent(Packet packet) {
        if (this.multithreadedSendingEnabled) {
            Queue<Packet> queue = this.outboundPackets;
            synchronized (queue) {
                this.urgentOutboundPackets.enqueue(packet);
            }
        } else {
            this.send(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet receive() {
        if (this.multithreadedReceivingEnabled) {
            Queue<Packet> queue = this.inboundPackets;
            synchronized (queue) {
                while (this.inboundPackets.isEmpty() && !this.isClosed) {
                    try {
                        this.inboundPackets.wait(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.inboundPackets.isEmpty()) {
                    return null;
                }
                return this.inboundPackets.dequeue();
            }
        }
        Object packet = null;
        while (packet == null || packet.getClass() == PacketPing.class) {
            while (this.in == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                packet = ConnectionManager.readPacket(this.in, this.packetSet);
                if (packet != null) continue;
                break;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return packet;
    }

    public void setMultithreadedSending(boolean multithreadedSendingEnabled) {
        try {
            this.flush();
        }
        catch (IOException ex) {
            Sys.error(ErrorLevel.severe, null, ex, ErrorCategory.other);
        }
        this.multithreadedSendingEnabled = multithreadedSendingEnabled || (this.type & 0x18) > 0;
    }

    public OutputStream getOutputStream() throws IOException {
        if ((1 & this.type) > 0) {
            return this.socket.getOutputStream();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if ((1 & this.type) > 0) {
            return this.socket.getInputStream();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        while (!this.fileOps.isEmpty() || !this.outboundPackets.isEmpty() && !this.isClosed && this.outbound != null && this.outbound.isAlive()) {
            if (!this.fileOps.isEmpty() && !this.fileOps.get(0).isAlive()) {
                this.fileOps.remove(0);
                continue;
            }
            if (!this.fileOps.isEmpty() && this.fileOps.get(0) == Thread.currentThread()) {
                this.fileOps.remove(0);
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while ((this.type & 0x40) > 0 && this.out == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isClosed && this.out != null) {
            this.flush();
        }
        this.isClosed = true;
        if ((this.type & 0x20) > 0) {
            this.in.close();
        } else if ((this.type & 0x40) > 0) {
            this.out.close();
        } else if ((this.type & 4) > 0) {
            this.listener.close();
        } else if ((this.type & 0x18) > 0) {
            this.socket.close();
        }
        if (this.broadcasting) {
            this.makeUndiscoverable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        while (!this.flushable) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.isClosed) {
            return;
        }
        if (this.out == null) {
            throw new IllegalStateException("Cannot flush a nonexistent connection!");
        }
        try {
            String string = this.flushWaitor;
            synchronized (string) {
                this.flushWaitor.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.out.flush();
    }

    public String sendFile(final File file) {
        final String name = this.getNameForFile(file);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileInputStream in = null;
                try {
                    int packetSize = 10240;
                    in = new FileInputStream(file);
                    long fileLength = file.length();
                    if (fileLength == 0L) {
                        ConnectionManager.this.outboundPackets.enqueue(new PacketData("INTERNAL_FILE|" + name, 1, 1, (InputStream)null));
                    }
                    int indexes = (int)((fileLength - fileLength % (long)packetSize) / (long)packetSize + (long)(fileLength % (long)packetSize > 0L ? 1 : 0));
                    for (int packetIndex = 1; in.available() > 0 && packetIndex <= indexes; ++packetIndex) {
                        while (ConnectionManager.this.outboundPackets.size() >= 100) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ConnectionManager.this.outboundPackets.enqueue(new PacketData("INTERNAL_FILE|" + name, packetIndex, indexes, in));
                    }
                    ConnectionManager.this.flush();
                }
                catch (IOException ex) {
                    Sys.error(ErrorLevel.severe, "Error reading file!", ex, ErrorCategory.fileIO);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        Sys.error(ErrorLevel.severe, "Error closing file!", ex, ErrorCategory.fileIO);
                    }
                    ConnectionManager.this.fileOps.remove(Thread.currentThread());
                }
            }
        };
        this.fileOps.add(thread);
        thread.start();
        return name;
    }

    private void setType(int type) {
        this.type = type;
    }

    private void start() throws IOException {
        if (this.listener != null && this.listener.isClosed()) {
            this.listener = null;
        }
        if (this.socket != null && this.socket.isClosed()) {
            this.socket = null;
        }
        if (this.socket == null) {
            this.inbound = null;
            this.outbound = null;
        }
        if (this.listener == null && (this.type & 4) == 4) {
            this.listener = new ServerSocket(this.port, this.waitingConnectionCount);
            this.listener.setSoTimeout(this.timeout);
            this.monitor = this.createMonitor(null);
        } else if (this.socket != null && this.inbound == null && this.outbound == null && (this.type & 0x10) == 16) {
            this.inbound = this.createMonitor("Inbound");
            this.outbound = this.createMonitor("Outbound");
        } else if (this.socket == null && (this.type & 8) == 8) {
            this.socket = new Socket();
            this.socket.setSoTimeout(this.timeout);
            this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
            this.inbound = this.createMonitor("Inbound");
            this.outbound = this.createMonitor("Outbound");
        } else if ((this.type & 0x20) > 0) {
            this.inbound = this.createMonitor("Inbound");
        } else if ((this.type & 0x40) > 0) {
            this.outbound = this.createMonitor("Outbound");
        }
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setWaitingConnectionCount(int waitingConnectionCount) {
        this.waitingConnectionCount = waitingConnectionCount;
    }

    private void setHost(String host) {
        this.host = host;
    }

    protected Thread createMonitor(String which) {
        Thread value = null;
        if ((this.type & 4) == 4) {
            value = new Thread(){

                @Override
                public void run() {
                    while (!ConnectionManager.this.listener.isClosed()) {
                        ConnectionManager manager = null;
                        try {
                            Socket socket = ConnectionManager.this.listener.accept();
                            manager = new ConnectionManager(ConnectionManager.this.packetSet);
                            manager.socket = socket;
                            manager.setType(ConnectionManager.this.type & 3 | 0x10);
                            manager.myServer = ConnectionManager.this;
                            manager.start();
                            if (ConnectionManager.this.authenticator != null) {
                                final ConnectionManager theManager = manager;
                                ConnectionManager.this.connectionsAuthenticating.add(manager);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        if (ConnectionManager.this.outboundEncryption != null && !((ConnectionManager)ConnectionManager.this).outboundEncryption.name.isEmpty()) {
                                            theManager.dualEncrypt(ConnectionManager.this.outboundEncryption);
                                        }
                                        theManager.send(new PacketAuthenticationRequired());
                                    }
                                }.start();
                                continue;
                            }
                            ConnectionManager.this.connections.add(manager);
                        }
                        catch (Exception ex) {
                            if (manager != null) {
                                try {
                                    manager.socket.close();
                                }
                                catch (IOException ex1) {
                                    Sys.error(ErrorLevel.severe, "Could not close a connection!", ex1, ErrorCategory.InternetIO);
                                }
                            }
                            if (ex.getClass() == SocketTimeoutException.class || "socket closed".equals(ex.getMessage()) || ConnectionManager.this.isClosed) continue;
                            Sys.error(ErrorLevel.log, "Could not accept a connection!", ex, ErrorCategory.InternetIO);
                        }
                    }
                }
            };
            value.setName("ConnectionManager Server Thread");
        } else if ((this.type & 0x18) > 0 && (this.type & 2) == 2 || (this.type & 0x60) > 0) {
            switch (which) {
                case "Inbound": {
                    value = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ConnectionManager.this.realIn = (ConnectionManager.this.in = (ConnectionManager.this.type & 0x20) > 0 ? (ConnectionManager.this.in == null ? new DataInputStream(new FileInputStream(new File(ConnectionManager.this.host))) : (ConnectionManager.this.in instanceof DataInputStream ? ConnectionManager.this.in : new DataInputStream(ConnectionManager.this.in))) : new DataInputStream(ConnectionManager.this.socket.getInputStream()));
                                while (ConnectionManager.this.socket != null && !ConnectionManager.this.socket.isClosed() || (ConnectionManager.this.type & 0x60) > 0 && !ConnectionManager.this.isClosed) {
                                    while (!(ConnectionManager.this.isClosed || (ConnectionManager.this.socket == null || ConnectionManager.this.socket.isClosed()) && (ConnectionManager.this.type & 0x60) <= 0 || ConnectionManager.this.multithreadedReceivingEnabled && ConnectionManager.this.inboundPackets.size() + ConnectionManager.this.outboundPackets.size() < 10000)) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException ex) {
                                            Logger.getLogger(ConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                    if (!(ConnectionManager.this.socket != null && !ConnectionManager.this.socket.isClosed() || (ConnectionManager.this.type & 0x60) > 0 && !ConnectionManager.this.isClosed)) continue;
                                    try {
                                        Object p;
                                        Encryption e;
                                        Packet packet = ConnectionManager.readPacket(ConnectionManager.this.in, ConnectionManager.this.packetSet);
                                        ConnectionManager.this.invalids = 0;
                                        if (packet.getClass() == PacketData.class && ((PacketData)packet).tag.startsWith("INTERNAL_FILE|")) {
                                            ConnectionManager.this.recieveFilePacket((PacketData)packet);
                                            continue;
                                        }
                                        if (packet instanceof PacketValidateDatastream) {
                                            ConnectionManager.this.datastreamInvalid = true;
                                            continue;
                                        }
                                        if (packet instanceof PacketAuthentication) {
                                            ConnectionManager.this.myServer.authenticate(ConnectionManager.this, (PacketAuthentication)packet);
                                            continue;
                                        }
                                        if (packet instanceof PacketAuthenticated) {
                                            ConnectionManager.this.onAuthenticated(((PacketAuthenticated)packet).getAuth());
                                            continue;
                                        }
                                        if (packet instanceof PacketAuthenticationFailed) {
                                            ConnectionManager.this.isAuthenticating = false;
                                            ConnectionManager.this.inboundPackets.enqueue(packet);
                                            continue;
                                        }
                                        if (packet instanceof PacketEncryptionStart) {
                                            PacketEncryptionStart pes = (PacketEncryptionStart)packet;
                                            if (pes.getTitle().equals("")) {
                                                ConnectionManager.this.inboundEncryption = null;
                                                if (ConnectionManager.this.encryptionToForce != null && ((ConnectionManager)ConnectionManager.this).encryptionToForce.name.equals("")) {
                                                    ConnectionManager.this.encryptionToForce = null;
                                                }
                                                ConnectionManager.this.in = ConnectionManager.this.realIn;
                                                continue;
                                            }
                                            try {
                                                e = Encryption.getEncryption(pes.getTitle());
                                                if (e instanceof Encryption.LayeredEncryption) {
                                                    ConnectionManager.this.inboundEncryption = ((Encryption.LayeredEncryption)e).readyLayers(pes.getKeys());
                                                } else {
                                                    ConnectionManager.this.inboundEncryption = e.ready(pes.getKeys()[0]);
                                                }
                                                if (ConnectionManager.this.inboundEncryption.equals(ConnectionManager.this.encryptionToForce)) {
                                                    ConnectionManager.this.encryptionToForce = null;
                                                }
                                                ConnectionManager.this.in = ConnectionManager.this.inboundEncryption.decrypt(ConnectionManager.this.realIn);
                                            }
                                            catch (EncryptionNotFoundException ex) {
                                                ConnectionManager.this.send(new PacketEncryptionNotSupported(ex.getMessage()));
                                                ConnectionManager.this.inboundPackets.enqueue(new PacketConnectionFailed("Unknown Encryption Required:  " + ex.getMessage()));
                                                ConnectionManager.this.close();
                                            }
                                            continue;
                                        }
                                        if (packet instanceof PacketCheckEncryption) {
                                            p = (PacketCheckEncryption)packet;
                                            if (Encryption.isSupported(((PacketCheckEncryption)p).value)) {
                                                ConnectionManager.this.send(new PacketEncryptionSupported(((PacketCheckEncryption)p).value));
                                                continue;
                                            }
                                            ConnectionManager.this.send(new PacketEncryptionNotSupported(((PacketCheckEncryption)p).value));
                                            continue;
                                        }
                                        if (packet instanceof PacketRequestEncrypt) {
                                            p = (PacketRequestEncrypt)packet;
                                            if (Encryption.isSupported(((PacketRequestEncrypt)p).getTitle())) {
                                                try {
                                                    e = Encryption.getEncryption(((PacketRequestEncrypt)p).getTitle());
                                                    Encryption.ReadyEncryption re = e instanceof Encryption.LayeredEncryption ? ((Encryption.LayeredEncryption)e).readyLayers(((PacketRequestEncrypt)p).getKeys()) : e.ready(((PacketRequestEncrypt)p).getKeys()[0]);
                                                    ConnectionManager.this.send(new PacketEncryptionSupported(((PacketRequestEncrypt)p).getTitle()));
                                                    ConnectionManager.this.inboundPackets.enqueue(new PacketEncryptionRequested(ConnectionManager.this, re));
                                                }
                                                catch (EncryptionNotFoundException e2) {}
                                                continue;
                                            }
                                            ConnectionManager.this.send(new PacketEncryptionNotSupported(((PacketRequestEncrypt)p).getTitle()));
                                            continue;
                                        }
                                        if (packet instanceof PacketRequireEncrypt) {
                                            p = (PacketRequireEncrypt)packet;
                                            if (Encryption.isSupported(((PacketRequireEncrypt)p).getTitle())) {
                                                try {
                                                    e = Encryption.getEncryption(((PacketRequireEncrypt)p).getTitle());
                                                    if (e instanceof Encryption.LayeredEncryption) {
                                                        ConnectionManager.this.encryptionRequired = ((Encryption.LayeredEncryption)e).readyLayers(((PacketRequireEncrypt)p).getKeys());
                                                    } else {
                                                        ConnectionManager.this.encryptionRequired = e.ready(((PacketRequireEncrypt)p).getKeys()[0]);
                                                    }
                                                    ConnectionManager.this.inboundPackets.enqueue(new PacketEncryptionRequired(ConnectionManager.this, ConnectionManager.this.encryptionRequired));
                                                }
                                                catch (EncryptionNotFoundException e3) {}
                                                continue;
                                            }
                                            ConnectionManager.this.inboundPackets.enqueue(new PacketConnectionFailed("Unknown encryption required by other side:  " + ((PacketRequireEncrypt)p).getTitle()));
                                            ConnectionManager.this.close();
                                            continue;
                                        }
                                        if (packet instanceof PacketEncryptionNotSupported || packet instanceof PacketEncryptionSupported) {
                                            ConnectionManager.this.encryptionPackets.add(packet);
                                            p = ConnectionManager.this.encryptionCheckSync;
                                            synchronized (p) {
                                                ConnectionManager.this.encryptionCheckSync.notifyAll();
                                                continue;
                                            }
                                        }
                                        if (packet.getClass() == PacketPingTest.class) {
                                            PacketPingTest t = (PacketPingTest)packet;
                                            if (t.isReflected()) {
                                                ConnectionManager.this.inboundPackets.enqueue(new PacketPingTime(t.getTime()));
                                                ConnectionManager.this.send(new PacketPingTime(t.getTime()));
                                                continue;
                                            }
                                            ConnectionManager.this.sendUrgent(t);
                                            continue;
                                        }
                                        if (packet.getClass() == PacketPing.class) continue;
                                        ConnectionManager.this.inboundPackets.enqueue(packet);
                                    }
                                    catch (NullPointerException ex) {
                                        ConnectionManager.this.invalids++;
                                        if (ConnectionManager.this.invalids <= 2) continue;
                                        ConnectionManager.this.revalidateDatastream();
                                    }
                                    catch (RuntimeException ex) {
                                        if (ex.getCause() == null || !(ex.getCause() instanceof SocketException)) continue;
                                        throw ex;
                                    }
                                    catch (SocketException ex) {
                                        throw ex;
                                    }
                                    catch (Exception ex) {
                                    }
                                }
                            }
                            catch (IOException ex) {
                                boolean isClosed = ConnectionManager.this.isClosed;
                                try {
                                    ConnectionManager.this.close();
                                }
                                catch (IOException ex1) {
                                    throw new RuntimeException(ex1);
                                }
                                if (!isClosed) {
                                    Sys.error(ErrorLevel.log, "Read failed:", ex, ErrorCategory.InternetIO);
                                }
                            }
                            finally {
                                try {
                                    if (ConnectionManager.this.in != null) {
                                        ConnectionManager.this.in.close();
                                    }
                                }
                                catch (IOException ex) {
                                    Sys.error(ErrorLevel.warning, "Could not close stream!", ex, ErrorCategory.InternetIO);
                                }
                            }
                        }
                    };
                    value.setName("ConnectionManager Inbound Thread");
                    break;
                }
                case "Outbound": {
                    value = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            long millisOfLastPacket = 0L;
                            try {
                                ConnectionManager.this.realOut = (ConnectionManager.this.out = (ConnectionManager.this.type & 0x40) > 0 ? (ConnectionManager.this.out == null ? new DataOutputStream(new FileOutputStream(new File(ConnectionManager.this.host))) : (ConnectionManager.this.out instanceof DataOutputStream ? ConnectionManager.this.out : new DataOutputStream(ConnectionManager.this.out))) : new DataOutputStream(ConnectionManager.this.socket.getOutputStream()));
                            }
                            catch (IOException ex) {
                                Sys.error(ErrorLevel.severe, "Could not get output stream!", ex, ErrorCategory.fileIO);
                                return;
                            }
                            ConnectionManager.this.flushable = true;
                            while (ConnectionManager.this.socket != null && !ConnectionManager.this.socket.isClosed() || (ConnectionManager.this.type & 0x60) > 0 && !ConnectionManager.this.isClosed) {
                                String string;
                                Iterable lst;
                                if (ConnectionManager.this.datastreamInvalid) {
                                    try {
                                        for (int i = 0; i < 32; ++i) {
                                            ConnectionManager.this.out.write(0);
                                        }
                                        ConnectionManager.this.out.write(1);
                                        ConnectionManager.this.datastreamInvalid = false;
                                    }
                                    catch (IOException i) {}
                                    continue;
                                }
                                if (ConnectionManager.this.urgentOutboundPackets.isEmpty() && ConnectionManager.this.outboundPackets.isEmpty() || ConnectionManager.this.encryptionRequired != null && !(ConnectionManager.this.outboundPackets.peek() instanceof PacketEncryptionStart)) {
                                    if (ConnectionManager.this.encryptionRequired != null && !ConnectionManager.this.outboundPackets.isEmpty()) {
                                        Queue i = ConnectionManager.this.outboundPackets;
                                        synchronized (i) {
                                            lst = ConnectionManager.this.outboundPackets.toList();
                                            Iterator it = ((ArrayList)lst).iterator();
                                            while (it.hasNext()) {
                                                Packet outboundPacket = (Packet)it.next();
                                                if (!(outboundPacket instanceof PacketEncryptionStart)) continue;
                                                it.remove();
                                                ((ArrayList)lst).add(0, (Packet)outboundPacket);
                                                ConnectionManager.this.outboundPackets.clear();
                                                for (Packet p : lst) {
                                                    ConnectionManager.this.outboundPackets.enqueue(p);
                                                }
                                            }
                                        }
                                    }
                                    String i = ConnectionManager.this.flushWaitor;
                                    synchronized (i) {
                                        ConnectionManager.this.flushWaitor.notifyAll();
                                    }
                                    if (System.currentTimeMillis() - millisOfLastPacket >= 100L) {
                                        ConnectionManager.this.outboundPackets.enqueue(new PacketPing());
                                        millisOfLastPacket = System.currentTimeMillis();
                                    }
                                    try {
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException ex) {
                                        Sys.error(ErrorLevel.warning, "Could not wait for fresh outbound packets!", ex, ErrorCategory.InternetIO);
                                    }
                                    continue;
                                }
                                try {
                                    Packet packet;
                                    lst = ConnectionManager.this.outboundPackets;
                                    synchronized (lst) {
                                        packet = ConnectionManager.this.urgentOutboundPackets.peek() == null ? (Packet)ConnectionManager.this.outboundPackets.dequeue() : (Packet)ConnectionManager.this.urgentOutboundPackets.dequeue();
                                    }
                                    if (packet == null) continue;
                                    ConnectionManager.sendPacket(ConnectionManager.this.out, packet, ConnectionManager.this.packetSet);
                                    if (packet instanceof PacketEncryptionStart) {
                                        PacketEncryptionStart p = (PacketEncryptionStart)packet;
                                        if (ConnectionManager.this.encryptionRequired.equals(p.encryption)) {
                                            ConnectionManager.this.encryptionRequired = null;
                                        }
                                        if (p.encryption.name.equals("")) {
                                            ConnectionManager.this.outboundEncryption = null;
                                            ConnectionManager.this.out = ConnectionManager.this.realOut;
                                            continue;
                                        }
                                        ConnectionManager.this.outboundEncryption = p.encryption;
                                        ConnectionManager.this.out = ConnectionManager.this.outboundEncryption.encrypt(ConnectionManager.this.realOut);
                                        continue;
                                    }
                                    if (!(packet instanceof PacketRequireEncrypt)) continue;
                                    ConnectionManager.this.encryptionToForce = ((PacketRequireEncrypt)packet).encryption;
                                }
                                catch (RuntimeException ex) {
                                    if (ex.getCause() == null || !(ex.getCause() instanceof SocketException)) continue;
                                    ConnectionManager.this.isClosed = true;
                                    string = ConnectionManager.this.flushWaitor;
                                    synchronized (string) {
                                        ConnectionManager.this.flushWaitor.notifyAll();
                                    }
                                    try {
                                        ConnectionManager.this.close();
                                    }
                                    catch (IOException iOException) {
                                    }
                                }
                                catch (SocketException ex) {
                                    ConnectionManager.this.isClosed = true;
                                    string = ConnectionManager.this.flushWaitor;
                                    synchronized (string) {
                                        ConnectionManager.this.flushWaitor.notifyAll();
                                    }
                                    try {
                                        ConnectionManager.this.close();
                                    }
                                    catch (IOException iOException) {
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                    };
                    value.setName("ConnectionManager Outbound Thread");
                }
            }
        } else if ((this.type & 0x18) > 0 && (this.type & 1) == 1) {
            value = new Thread(){

                @Override
                public void start() {
                }
            };
        }
        if (value != null) {
            value.start();
        }
        return value;
    }

    private void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private void recieveFilePacket(PacketData packet) throws IOException {
        File file;
        Object[] objs = this.fileOutputStreamsForRecievedFiles.get(packet.tag.substring(14));
        if (objs == null) {
            file = new File(this.getFilepath(packet));
            file.getParentFile().mkdirs();
            objs = new Object[]{file, new FileOutputStream(file)};
            this.fileOutputStreamsForRecievedFiles.put(packet.tag.substring(14), objs);
        }
        file = (File)objs[0];
        OutputStream out = (OutputStream)objs[1];
        packet.writeData(out);
        if (packet.packetNumber == packet.totalPacketCount) {
            out.close();
            this.fileOutputStreamsForRecievedFiles.remove(packet.tag.substring(14));
            this.receivedFiles.add(file);
        }
        this.inboundPackets.enqueue(new PacketFileTransmission(packet.tag.substring(14).split("\\|", 2)[1], file.getAbsolutePath(), packet.packetNumber, packet.totalPacketCount));
    }

    private String getFilepath(PacketData packet) {
        String name = Sys.splitString(packet.tag, '|')[2];
        File file = new File(Sys.getRoot(), "Downloaded Files");
        if (!new File(file, name).exists()) {
            return new File(file, name).getAbsolutePath();
        }
        int index = 0;
        while (new File(file, index + " " + name).exists()) {
            ++index;
        }
        return new File(file, index + " " + name).getAbsolutePath();
    }

    private String getNameForFile(File file) {
        int index = 0;
        while (this.filenames.contains(index + "|" + file.getName())) {
            ++index;
        }
        this.filenames.add(index + "|" + file.getName());
        return index + "|" + file.getName();
    }

    public ConnectionManager createLoopback() {
        ConnectionManager[] mngrs = ConnectionManager.createLoopbacks();
        mngrs[0].myServer = this;
        if (this.authenticator != null) {
            this.connectionsAuthenticating.add(mngrs[0]);
            mngrs[0].send(new PacketAuthenticationRequired());
        } else {
            this.connections.add(mngrs[0]);
        }
        return mngrs[1];
    }

    public static ConnectionManager[] createLoopbacks() {
        return ConnectionManager.createLoopbacks(defaultPacketSet);
    }

    public static ConnectionManager[] createLoopbacks(PacketSet set) {
        final ConnectionManager server = new ConnectionManager(set);
        final ConnectionManager client = new ConnectionManager(set);
        server.outbound = client.inbound = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!server.isClosed && !client.isClosed) {
                    Packet p = (Packet)server.outboundPackets.dequeue();
                    if (p == null) {
                        Thread thread = server.outbound;
                        synchronized (thread) {
                            try {
                                server.outbound.wait(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (p instanceof PacketAuthentication) {
                        if (client.myServer == null) continue;
                        client.myServer.authenticate(client, (PacketAuthentication)p);
                        continue;
                    }
                    if (p instanceof PacketAuthenticated) {
                        client.onAuthenticated(((PacketAuthenticated)p).getAuth());
                        client.inboundPackets.enqueue(p);
                        continue;
                    }
                    client.inboundPackets.enqueue(p);
                }
            }
        };
        server.outbound.setName("ConnectionManager Loopback S-C Thread");
        client.outbound = server.inbound = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!client.isClosed && !server.isClosed) {
                    Packet p = (Packet)client.outboundPackets.dequeue();
                    if (p == null) {
                        Thread thread = client.outbound;
                        synchronized (thread) {
                            try {
                                client.outbound.wait(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (p instanceof PacketAuthentication) {
                        if (server.myServer == null) continue;
                        server.myServer.authenticate(server, (PacketAuthentication)p);
                        continue;
                    }
                    if (p instanceof PacketAuthenticated) {
                        server.onAuthenticated(((PacketAuthenticated)p).getAuth());
                        server.inboundPackets.enqueue(p);
                        continue;
                    }
                    server.inboundPackets.enqueue(p);
                }
            }
        };
        client.outbound.setName("ConnectionManager Loopback C-S Thread");
        server.outbound.start();
        client.outbound.start();
        return new ConnectionManager[]{server, client};
    }

    private void setAuthenticator(Authenticator authenticator, Encryption.ReadyEncryption encryption) {
        this.authenticator = authenticator;
        this.outboundEncryption = encryption;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    private void authenticate(final ConnectionManager client, final PacketAuthentication packet) {
        if (this.authenticator == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Authentication auth = null;
                try {
                    auth = ConnectionManager.this.authenticator.authenticate(packet.value, client.outboundEncryption, client.inboundEncryption);
                }
                catch (Throwable t) {
                    Sys.error(ErrorLevel.severe, "Could not authenticate client!", t, ErrorCategory.bug);
                }
                if (auth == null) {
                    client.send(new PacketAuthenticationFailed());
                } else {
                    client.authentication = auth;
                    if (ConnectionManager.this.connectionsAuthenticating.remove(client)) {
                        ConnectionManager.this.connections.add(client);
                    }
                    if (auth.requiresEncryption()) {
                        try {
                            client.encryptionRequired = auth.getRequiredReadyEncryption();
                        }
                        catch (EncryptionNotFoundException encryptionNotFoundException) {
                            // empty catch block
                        }
                    }
                    client.send(new PacketAuthenticated(auth));
                }
            }
        }.start();
    }

    private void onAuthenticated(Authentication auth) {
        if (!this.isAuthenticating) {
            return;
        }
        this.isAuthenticating = false;
        this.authentication = auth;
        if (auth.requiresEncryption()) {
            if (Encryption.isSupported(auth.getRequiredEncryption())) {
                try {
                    this.encryptionRequired = auth.getRequiredReadyEncryption();
                    this.send(new PacketEncryptionStart(this.encryptionRequired));
                }
                catch (EncryptionNotFoundException encryptionNotFoundException) {}
            } else {
                this.inboundPackets.enqueue(new PacketConnectionFailed("Authentication requires unsupported encryption " + auth.getRequiredEncryption()));
                try {
                    this.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (auth.requestsEncryption() && Encryption.isSupported(auth.getRequestedEncryption())) {
            try {
                this.inboundPackets.enqueue(new PacketEncryptionRequested(this, auth.getRequestedReadyEncryption()));
            }
            catch (EncryptionNotFoundException encryptionNotFoundException) {
                // empty catch block
            }
        }
        this.inboundPackets.enqueue(new PacketAuthenticated(auth));
        this.send(new PacketAuthenticationConfirmed());
    }

    public void authenticate(String username, String password) {
        if (this.isAuthenticating || this.authentication != null) {
            return;
        }
        this.isAuthenticating = true;
        this.send(new PacketAuthentication(username, password));
    }

    public void authenticate(Config authData) {
        if (this.isAuthenticating || this.authentication != null) {
            return;
        }
        this.isAuthenticating = true;
        this.send(new PacketAuthentication(authData));
    }

    public boolean checkEncrypt(Encryption.ReadyEncryption encryption) {
        return this.checkEncrypt(encryption, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEncrypt(Encryption.ReadyEncryption encryption, long maxWaitMillis) {
        Object object = this.encryptionCheckSync;
        synchronized (object) {
            long current;
            this.send(new PacketCheckEncryption(encryption.name));
            long over = System.currentTimeMillis() + maxWaitMillis;
            while ((current = System.currentTimeMillis()) <= over) {
                Iterator<Packet> it = this.encryptionPackets.iterator();
                while (it.hasNext()) {
                    Packet p = it.next();
                    if (p instanceof PacketEncryptionNotSupported && encryption.name.equals(((PacketEncryptionNotSupported)p).value)) {
                        it.remove();
                        return false;
                    }
                    if (!(p instanceof PacketEncryptionSupported) || !encryption.name.equals(((PacketEncryptionSupported)p).value)) continue;
                    it.remove();
                    return true;
                }
                if (over <= current) continue;
                try {
                    this.encryptionCheckSync.wait(over - current);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    public boolean encrypt(Encryption.ReadyEncryption encryption) {
        if (this.checkEncrypt(encryption)) {
            this.forceEncrypt(encryption);
            return true;
        }
        return false;
    }

    public void forceEncrypt(Encryption.ReadyEncryption encryption) {
        this.send(new PacketEncryptionStart(encryption));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestEncrypt(Encryption.ReadyEncryption encryption) {
        Object object = this.encryptionCheckSync;
        synchronized (object) {
            long current;
            this.send(new PacketRequestEncrypt(encryption));
            long over = System.currentTimeMillis() + 10000L;
            while ((current = System.currentTimeMillis()) <= over) {
                Iterator<Packet> it = this.encryptionPackets.iterator();
                while (it.hasNext()) {
                    Packet p = it.next();
                    if (p instanceof PacketEncryptionNotSupported && encryption.name.equals(((PacketEncryptionNotSupported)p).value)) {
                        it.remove();
                        return false;
                    }
                    if (!(p instanceof PacketEncryptionSupported) || !encryption.name.equals(((PacketEncryptionSupported)p).value)) continue;
                    it.remove();
                    return true;
                }
                if (over <= current) continue;
                try {
                    this.encryptionCheckSync.wait(over - current);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    public void requireEncrypt(Encryption.ReadyEncryption encryption) {
        this.send(new PacketRequireEncrypt(encryption));
        this.encryptionToForce = encryption;
    }

    public boolean dualEncrypt(Encryption.ReadyEncryption encryption) {
        if (this.encrypt(encryption)) {
            this.requestEncrypt(encryption);
            return true;
        }
        return false;
    }

    public void forceDualEncrypt(Encryption.ReadyEncryption encryption) {
        this.forceEncrypt(encryption);
        this.requireEncrypt(encryption);
    }

    public void revalidateDatastream() throws IOException {
        this.inboundPackets.enqueue(new PacketInvalidDatastream());
        this.send(new PacketValidateDatastream());
        while (true) {
            for (int i = 0; i < 32; ++i) {
                if (this.in.read() != 0) continue;
            }
            break;
        }
        while (this.in.read() != 1) {
        }
    }

    public void requestPingTest() {
        this.send(new PacketPingTest());
    }

    public boolean isDiscoverable() {
        return this.broadcasting;
    }

    public int getDiscoverablePort() {
        return this.broadcastPort;
    }

    public void makeDiscoverable(int portNum, final String keycode, final String message) {
        if (this.broadcasting) {
            throw new IllegalStateException("Server is alerady discoverable!");
        }
        this.broadcastPort = portNum;
        this.broadcasting = true;
        Thread server = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectionManager.this.broadcastSocket = new DatagramSocket(ConnectionManager.this.broadcastPort);
                    byte[] sendMessage = ("SIMPLIB_" + keycode + "_" + ConnectionManager.this.port + (message == null ? "" : "_" + message)).getBytes();
                    while (ConnectionManager.this.broadcasting && !ConnectionManager.this.broadcastSocket.isClosed()) {
                        InetAddress group = InetAddress.getByName("224.0.2.0");
                        DatagramPacket p = new DatagramPacket(sendMessage, sendMessage.length, group, ConnectionManager.this.broadcastPort);
                        ConnectionManager.this.broadcastSocket.send(p);
                        String string = keycode;
                        synchronized (string) {
                            keycode.wait(1000L);
                        }
                    }
                    if (!ConnectionManager.this.broadcastSocket.isClosed()) {
                        ConnectionManager.this.broadcastSocket.close();
                    }
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        };
        server.setName("SimpLib Broadcasting Thread");
        server.start();
    }

    public void makeUndiscoverable() {
        if (!this.broadcasting) {
            throw new IllegalStateException("Server is already undiscoverable!");
        }
        this.broadcasting = false;
        this.broadcastSocket.close();
    }

    static {
        if (!Sys.isInitialized()) {
            throw new IllegalStateException("SimpleLibrary must be initialized before the connection manager can be initialized!");
        }
        ConnectionManager.registerPacketClass(new PacketPing());
        ConnectionManager.registerPacketClass(new PacketInteger());
        ConnectionManager.registerPacketClass(new PacketString());
        ConnectionManager.registerPacketClass(new PacketBoolean());
        ConnectionManager.registerPacketClass(new PacketData());
        ConnectionManager.registerPacketClass(new PacketLong());
        ConnectionManager.registerPacketClass(new PacketConfig());
        ConnectionManager.registerPacketClass(new PacketAuthenticationRequired());
        ConnectionManager.registerPacketClass(new PacketAuthentication());
        ConnectionManager.registerPacketClass(new PacketAuthenticated());
        ConnectionManager.registerPacketClass(new PacketAuthenticationFailed());
        ConnectionManager.registerPacketClass(new PacketAuthenticationConfirmed());
        ConnectionManager.registerPacketClass(new PacketEncryptionStart());
        ConnectionManager.registerPacketClass(new PacketEncryptionNotSupported());
        ConnectionManager.registerPacketClass(new PacketEncryptionSupported());
        ConnectionManager.registerPacketClass(new PacketCheckEncryption());
        ConnectionManager.registerPacketClass(new PacketRequestEncrypt());
        ConnectionManager.registerPacketClass(new PacketRequireEncrypt());
        ConnectionManager.registerPacketClass(new PacketPingTest());
        ConnectionManager.registerPacketClass(new PacketPingTime());
        ConnectionManager.registerPacketClass(new PacketValidateDatastream());
        basePacketSet = defaultPacketSet.copy();
    }

    public static class Discoverer {
        private final String keycode;
        MulticastSocket c;
        public final ArrayList<ServerData> servers = new ArrayList();
        private final ActionListener listener;

        public Discoverer(String keycode, int port, ActionListener listener) throws IOException {
            this.keycode = keycode;
            this.listener = listener;
            this.c = new MulticastSocket(port);
            InetAddress group = InetAddress.getByName("224.0.2.0");
            this.c.joinGroup(group);
            final String expectResponse = "SIMPLIB_" + keycode + "_";
            Thread receive = new Thread(){

                @Override
                public void run() {
                    byte[] recvBuf = new byte[15000];
                    while (!c.isClosed()) {
                        try {
                            DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
                            c.receive(receivePacket);
                            String message = new String(receivePacket.getData()).trim();
                            if (!message.startsWith(expectResponse)) continue;
                            String rest = message.substring(expectResponse.length());
                            String p = rest.indexOf(95) > 0 ? rest.substring(0, rest.indexOf(95)) : rest;
                            rest = rest.indexOf(95) > 0 ? rest.substring(rest.indexOf(95) + 1) : null;
                            int port = Integer.parseInt(p);
                            this.noteServerIP(receivePacket.getAddress().getHostAddress(), port, rest);
                        }
                        catch (IOException | NumberFormatException exception) {}
                    }
                }
            };
            receive.setName("SimpLib Discoverer:  Receiving Thread");
            receive.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            String string = this.keycode;
            synchronized (string) {
                this.c.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void noteServerIP(String ip, int port, String message) {
            long time = System.currentTimeMillis();
            ArrayList<ServerData> arrayList = this.servers;
            synchronized (arrayList) {
                for (ServerData s : this.servers) {
                    if (!s.ip.equals(ip) || s.port != port) continue;
                    s.origin = time;
                    s.message = message;
                    return;
                }
                this.servers.add(new ServerData(ip, port, time, message));
                if (this.listener != null) {
                    this.listener.actionPerformed(new ActionEvent(this, 0, ip + ":" + port + (message == null ? "" : " " + message)));
                }
            }
        }

        public static class ServerData {
            public final String ip;
            public final int port;
            public String message;
            private long origin;

            private ServerData(String ip, int port, long origin, String message) {
                this.ip = ip;
                this.port = port;
                this.origin = origin;
                this.message = message;
            }

            public long getAgeInMillis() {
                return System.currentTimeMillis() - this.origin;
            }
        }
    }
}

