/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net;

import java.util.HashMap;
import simplelibrary.net.packet.Packet;

public class PacketSet {
    Packet[] packets = new Packet[0];
    private final HashMap<Packet, Integer> packetIndexes = new HashMap();

    PacketSet() {
    }

    public synchronized void registerPacketClass(Class<? extends Packet> instance) throws InstantiationException, IllegalAccessException {
        this.registerPacketClass(instance.newInstance());
    }

    public synchronized void registerPacketClass(Packet instance) {
        if (instance == null) {
            throw new NullPointerException("Packet class cannot be null!");
        }
        if (this.packetIndexes.containsKey(instance)) {
            throw new IllegalArgumentException("Packet class already registered!");
        }
        int packetID = this.packets.length;
        Packet[] classes = new Packet[this.packets.length + 1];
        System.arraycopy(this.packets, 0, classes, 0, this.packets.length);
        classes[packetID] = instance;
        this.packetIndexes.put(instance, packetID);
        this.packets = classes;
    }

    public synchronized Packet getPacket(int index) {
        return index >= 0 && index < this.packets.length ? this.packets[index] : null;
    }

    public synchronized int getIndex(Packet packet) {
        return this.packetIndexes.containsKey(packet) ? this.packetIndexes.get(packet) : -1;
    }

    public PacketSet copy() {
        PacketSet s = new PacketSet();
        for (Packet p : this.packets) {
            s.registerPacketClass(p.baseInstance());
        }
        return s;
    }
}

