/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net.authentication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import simplelibrary.config2.Config;
import simplelibrary.encryption.Encryption;
import simplelibrary.encryption.EncryptionNotFoundException;

public class Authentication {
    private final String requiredEncryption;
    private final String[] requiredKeys;
    private final String requestedEncryption;
    private final String[] requestedKeys;
    private final Config authData;

    private Authentication(Encryption requiredEncryption, String[] requiredKeys, Encryption requestedEncryption, String[] requestedKeys, Config authData) {
        this.requiredEncryption = requiredEncryption == null ? null : requiredEncryption.name;
        this.requiredKeys = requiredKeys;
        this.requestedEncryption = requestedEncryption == null ? null : requestedEncryption.name;
        this.requestedKeys = requestedKeys;
        this.authData = authData;
    }

    private Authentication(String requiredEncryption, String[] requiredKeys, String requestedEncryption, String[] requestedKeys, Config authData) {
        this.requiredEncryption = requiredEncryption;
        this.requiredKeys = requiredKeys;
        this.requestedEncryption = requestedEncryption;
        this.requestedKeys = requestedKeys;
        this.authData = authData;
    }

    public static Authentication read(DataInputStream in) throws IOException {
        int i;
        String requiredEncryption = null;
        String[] requiredKeys = null;
        String requestedEncryption = null;
        String[] requestedKeys = null;
        if (in.read() == 1) {
            requiredEncryption = in.readUTF();
            requiredKeys = new String[in.readInt()];
            for (i = 0; i < requiredKeys.length; ++i) {
                requiredKeys[i] = in.readUTF();
            }
        }
        if (in.read() == 1) {
            requestedEncryption = in.readUTF();
            requestedKeys = new String[in.readInt()];
            for (i = 0; i < requestedKeys.length; ++i) {
                requestedKeys[i] = in.readUTF();
            }
        }
        Config authData = Config.newConfig().load(in);
        return new Authentication(requiredEncryption, requiredKeys, requestedEncryption, requestedKeys, authData);
    }

    public static Authentication authenticate(Config authData) {
        return new Authentication((Encryption)null, null, null, null, authData);
    }

    public static Authentication requireEncrypt(Encryption requiredEncryption, String[] requiredKeys, Config authData) {
        return new Authentication(requiredEncryption, requiredKeys, null, null, authData);
    }

    public static Authentication requestEncrypt(Encryption requestedEncryption, String[] requestedKeys, Config authData) {
        return new Authentication(null, null, requestedEncryption, requestedKeys, authData);
    }

    public static Authentication authenticate(Encryption requiredEncryption, String[] requiredKeys, Encryption requestedEncryption, String[] requestedKeys, Config authData) {
        return new Authentication(requiredEncryption, requiredKeys, requestedEncryption, requestedKeys, authData);
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.requiredEncryption == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeUTF(this.requiredEncryption);
            out.writeInt(this.requiredKeys.length);
            for (String s : this.requiredKeys) {
                out.writeUTF(s);
            }
        }
        if (this.requestedEncryption == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeUTF(this.requestedEncryption);
            out.writeInt(this.requestedKeys.length);
            for (String s : this.requestedKeys) {
                out.writeUTF(s);
            }
        }
        this.authData.save(out);
    }

    public boolean requiresEncryption() {
        return this.requiredEncryption != null;
    }

    public String getRequiredEncryption() {
        return this.requiredEncryption;
    }

    public String getRequestedEncryption() {
        return this.requestedEncryption;
    }

    public boolean requestsEncryption() {
        return this.requestedEncryption != null;
    }

    public Config getAuthData() {
        return this.authData.clone();
    }

    public Encryption.ReadyEncryption getRequiredReadyEncryption() throws EncryptionNotFoundException {
        Encryption e = Encryption.getEncryption(this.requiredEncryption);
        if (e instanceof Encryption.LayeredEncryption) {
            return ((Encryption.LayeredEncryption)e).readyLayers(this.requiredKeys);
        }
        return e.ready(this.requiredKeys[0]);
    }

    public Encryption.ReadyEncryption getRequestedReadyEncryption() throws EncryptionNotFoundException {
        Encryption e = Encryption.getEncryption(this.requestedEncryption);
        if (e instanceof Encryption.LayeredEncryption) {
            return ((Encryption.LayeredEncryption)e).readyLayers(this.requestedKeys);
        }
        return e.ready(this.requestedKeys[0]);
    }
}

