/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import simplelibrary.config2.Config;
import simplelibrary.encryption.Encryption;
import simplelibrary.encryption.EncryptionOutputStream;
import simplelibrary.net.packet.Packet;
import simplelibrary.net.packet.PacketConfig;

public class PacketAuthentication
extends PacketConfig {
    private static PacketAuthentication baseInstance;
    private Config data;

    public PacketAuthentication() {
        if (baseInstance == null) {
            baseInstance = this;
        }
    }

    public PacketAuthentication(String username, String password) {
        this(PacketAuthentication.byUsernameAndPassword(username, password));
    }

    public PacketAuthentication(Config authData) {
        super(authData);
    }

    private static Config byUsernameAndPassword(String username, String password) {
        Config c = Config.newConfig();
        c.set("username", username + "");
        c.set("password", password + "");
        return c;
    }

    @Override
    public Packet newInstance() {
        return new PacketAuthentication();
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.value = Config.newConfig().load(Encryption.UNENCRYPTED.decrypt(in));
    }

    @Override
    public Packet baseInstance() {
        return baseInstance;
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        out = Encryption.UNENCRYPTED.encrypt(out);
        this.value.save(out);
        ((EncryptionOutputStream)out).flush();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(value=" + this.value + ")";
    }
}

