/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import simplelibrary.net.packet.Packet;

public class PacketData
implements Packet {
    private static PacketData baseInstance;
    public String tag;
    public int packetNumber;
    public int totalPacketCount;
    public byte[] data;

    public PacketData() {
        if (baseInstance == null) {
            baseInstance = this;
        }
    }

    public PacketData(String tag, int packetNumber, int totalPacketCount, InputStream input) throws IOException {
        int read;
        this.tag = tag;
        this.packetNumber = packetNumber;
        this.totalPacketCount = totalPacketCount;
        this.data = new byte[1024];
        int n = read = input == null ? 0 : input.read(this.data);
        if (read < this.data.length) {
            byte[] filedata2 = new byte[read];
            System.arraycopy(this.data, 0, filedata2, 0, filedata2.length);
            this.data = filedata2;
        }
    }

    public PacketData(String tag, int packetNumber, int totalPacketCount, byte[] inputData) {
        if (inputData.length > 102400) {
            throw new IllegalArgumentException("Data packet size cannot be greater than 100kb (102,400 bytes)!");
        }
        this.tag = tag;
        this.packetNumber = packetNumber;
        this.totalPacketCount = totalPacketCount;
        this.data = inputData;
    }

    public void writeData(OutputStream out) throws IOException {
        out.write(this.data);
    }

    @Override
    public Packet newInstance() {
        return new PacketData();
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.tag = in.readUTF();
        this.packetNumber = in.readInt();
        this.totalPacketCount = in.readInt();
        this.data = new byte[in.readInt()];
        for (int read = in.read(this.data, 0, this.data.length); read < this.data.length; read += in.read(this.data, read, this.data.length - read)) {
        }
    }

    @Override
    public Packet baseInstance() {
        return baseInstance;
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        out.writeUTF(this.tag);
        out.writeInt(this.packetNumber);
        out.writeInt(this.totalPacketCount);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public String toString() {
        return this.getClass().getName() + "(tag=" + this.tag + "&packetNumber=" + this.packetNumber + "&totalPacketCount=" + this.totalPacketCount + "&data=" + (this.data == null ? "null" : "byte[" + this.data.length + "]") + ")";
    }
}

