/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import simplelibrary.net.packet.Packet;

public class PacketPingTest
implements Packet {
    private static PacketPingTest baseInstance;
    long nanos = 0L;
    boolean reflected = false;

    public PacketPingTest() {
        if (baseInstance == null) {
            baseInstance = this;
        }
    }

    @Override
    public Packet newInstance() {
        return new PacketPingTest();
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.nanos = in.readLong();
        this.reflected = in.readBoolean();
        if (this.reflected) {
            this.nanos = System.nanoTime() - this.nanos;
        }
    }

    @Override
    public Packet baseInstance() {
        return baseInstance;
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        if (this.nanos == 0L) {
            out.writeLong(System.nanoTime());
            out.writeBoolean(false);
        } else {
            out.writeLong(this.nanos);
            out.writeBoolean(true);
        }
    }

    public long getTime() {
        return this.nanos;
    }

    public boolean isReflected() {
        return this.reflected;
    }

    public String toString() {
        return this.getClass().getName() + "(nanos=" + this.nanos + ",reflected=" + this.reflected + ")";
    }
}

