/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import simplelibrary.encryption.Encryption;
import simplelibrary.net.packet.Packet;

public class PacketRequireEncrypt
implements Packet {
    public final Encryption.ReadyEncryption encryption;
    private String title;
    private String[] keys;
    private static PacketRequireEncrypt baseInstance;

    public PacketRequireEncrypt(Encryption.ReadyEncryption e) {
        try {
            this.encryption = e;
            this.title = e.name;
            Field f = Encryption.ReadyEncryption.class.getDeclaredField("key");
            f.setAccessible(true);
            if (e instanceof Encryption.ReadyLayeredEncryption) {
                Field f2 = Encryption.ReadyLayeredEncryption.class.getDeclaredField("encryptions");
                f2.setAccessible(true);
                Encryption.ReadyLayeredEncryption le = (Encryption.ReadyLayeredEncryption)e;
                ArrayList lst = (ArrayList)f2.get(e);
                this.keys = new String[lst.size()];
                for (int i = 0; i < this.keys.length; ++i) {
                    this.keys[i] = (String)f.get(lst.get(i));
                }
            } else {
                this.keys = new String[1];
                this.keys[0] = (String)f.get(e);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PacketRequireEncrypt() {
        if (baseInstance == null) {
            baseInstance = this;
        }
        this.encryption = null;
    }

    @Override
    public Packet newInstance() {
        return new PacketRequireEncrypt();
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.title = in.readUTF();
        in = new DataInputStream(Encryption.UNENCRYPTED.decrypt(in));
        this.keys = new String[in.readInt()];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = in.readUTF();
        }
    }

    @Override
    public Packet baseInstance() {
        return baseInstance;
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        out.writeUTF(this.title);
        out = Encryption.UNENCRYPTED.encrypt(out);
        out.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            out.writeUTF(this.keys[i]);
        }
        out.flush();
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getKeys() {
        String[] k = new String[this.keys.length];
        System.arraycopy(this.keys, 0, k, 0, k.length);
        return k;
    }
}

