/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.net.packet.notransmit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import simplelibrary.encryption.Encryption;
import simplelibrary.net.ConnectionManager;
import simplelibrary.net.packet.Packet;
import simplelibrary.net.packet.notransmit.PacketConnectionFailed;

public class PacketEncryptionRequired
implements Packet {
    private ConnectionManager connection;
    private Encryption.ReadyEncryption encryption;

    public PacketEncryptionRequired(ConnectionManager connection, Encryption.ReadyEncryption re) {
        this.connection = connection;
        this.encryption = re;
    }

    public String getEncryptionTitle() {
        return this.encryption.name;
    }

    public void accept() {
        this.connection.forceEncrypt(this.encryption);
        this.connection = null;
        this.encryption = null;
    }

    public void decline() throws IOException {
        this.connection.inboundPackets.enqueue(new PacketConnectionFailed("Other side required encryption " + this.encryption.name + ", but was denied"));
        this.encryption = null;
        this.connection.close();
        this.connection = null;
    }

    @Override
    public Packet newInstance() {
        throw new IllegalStateException("This packet type not to be transmitted.");
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        throw new IllegalStateException("This packet type not to be transmitted.");
    }

    @Override
    public Packet baseInstance() {
        throw new IllegalStateException("This packet type not to be transmitted.");
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        throw new IllegalStateException("This packet type not to be transmitted.");
    }

    public String toString() {
        return this.getClass().getName() + "(secure data)";
    }
}

