/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.numbers;

public class HugeDecimal
implements Comparable<HugeDecimal>,
Cloneable {
    private static final short DIGIT_COUNT = 8192;
    private final byte[] digits = new byte[8192];
    private long firstDecimal = 8192L;
    private boolean negative = false;
    private static final String pi = "3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632788659361533818279682303019520353018529689957736225994138912497217752834791315155748572424541506959508295331168617278558890750983817546374649393192550604009277016711390098488240128583616035637076601047101819429555961989467678374494482553797747268471040475346462080466842590694912933136770289891521047521620569660240580381501935112533824300355876402474964732639141992726042699227967823547816360093417216412199245863150302861829745557067498385054945885869269956909272107975093029553211653449872027559602364806654991198818347977535663698074265425278625518184175746728909777727938000816470600161452491921732172147723501414419735685481613611573525521334757418494684385233239073941433345477624168625189835694855620992192221842725502542568876717904946016534668049886272327917860857843838279679766814541009538837863609506800642251252051173929848960841284886269456042419652850222106611863067442786220391949450471237137869609563643719172874677646575739624138908658326459958133904780275900994657640789512694683983525957098258226205224894077267194782684826014769909026401363944374553050682034962524517493996514314298091906592509372216964615157098583874105978859597729754989301617539284681382686838689427741559918559252459539594310499725246808459872736446958486538367362226260991246080512438843904512441365497627807977156914359977001296160894416948685558484063534220722258284886481584560285060168427394522674676788952521385225499546667278239864565961163548862305774564980355936345681743241125150760694794510965960940252288797108931456691368672287489405601015033086179286809208747609178249385890097149096759852613655497818931297848216829989487226588048575640142704775551323796414515237462343645428584447952658678210511413547357395231134271661021359695362314429524849371871101457654035902799344037420073105785390621983874478084784896833214457138687519435064302184531910484810053706146806749192781911979399520614196634287544406437451237181921799983910159195618146751426912397489409071864942319615679452080951465502252316038819301420937621378559566389377870830390697920773467221825625996615014215030680384477345492026054146659252014974428507325186660021324340881907104863317346496514539057962685610055081066587969981635747363840525714591028970641401109712062804390397595156771577004203378699360072305587631763594218731251471205329281918261861258673215791984148488291644706095752706957220917567116722910981690915280173506712748583222871835209353965725121083579151369882091444210067510334671103141267111369908658516398315019701651511685171437657618351556508849099898599823873455283316355076479185358932261854896321329330898570642046752590709154814165498594616371802709819943099244889575712828905923233260972997120844335732654893823911932597463667305836041428138830320382490375898524374417029132765618093773444030707469211201913020330380197621101100449293215160842444859637669838952286847831235526582131449576857262433441893039686426243410773226978028073189154411010446823252716201052652272111660396665573092547110557853763466820653109896526918620564769312570586356620185581007293606598764861179104533488503461136576867532494416680396265797877185560845529654126654085306143444318586769751456614068007002378776591344017127494704205622305389945613140711270004078547332699390814546646458807972708266830634328587856983052358089330657574067954571637752542021149557615814002501262285941302164715509792592309907965473761255176567513575178296664547791745011299614890304639947132962107340437518957359614589019389713111790429782856475032031986915140287080859904801094121472213179476477726224142548545403321571853061422881375850430633217518297986622371721591607716692547487389866549494501146540628433663937900397692656721463853067360965712091807638327166416274888800786925602902284721040317211860820419000422966171196377921337575114959501566049631862947265473642523081770367515906735023507283540567040386743513622224771589150495309844489333096340878076932599397805419341447377441842631298608099888687413260472156951623965864573021631598193195167353812974167729478672422924654366800980676928238280689964004824354037014163149658979409243237896907069779422362508221688957383798623001593776471651228935786015881617557829735233446042815126272037343146531977774160319906655418763979293344195215413418994854447345673831624993419131814809277771038638773431772075456545322077709212019051660962804909263601975988281613323166636528619326686336062735676303544776280350450777235547105859548702790814356240145171806246436267945612753181340783303362542327839449753824372058353114771199260638133467768796959703098339130771098704085913374641442822772634659470474587847787201927715280731767907707157213444730605700733492436931138350493163128404251219256517980694113528013147013047816437885185290928545201165839341965621349143415956258658655705526904965209858033850722426482939728584783163057777560688876446248246857926039535277348030480290058760758251047470916439613626760449256274204208320856611906254543372131535958450687724602901618766795240616342522577195429162991930645537799140373404328752628889639958794757291746426357455254079091451357111369410911939325191076020825202618798531887705842972591677813149699009019211697173727847684726860849003377024242916513005005168323364350389517029893922334517220138128069650117844087451960121228599371623130171144484640903890644954440061986907548516026327505298349187407866808818338510228334508504860825039302133219715518430635455007668282949304137765527939751754613953984683393638304746119966538581538420568533862186725233402830871123282789212507712629463229563989898935821167456270102183564622013496715188190973038119800497340723961036854066431939509790190699639552453005450580685501956730229219139339185680344903982059551002263535361920419947455385938102343955449597783779023742161727111723643435439478221818528624085140066604433258885698670543154706965747458550332323342107301545940516553790686627333799585115625784322988273723198987571415957811196358330059408730681216028764962867446047746491599505497374256269010490377819868359381465741268049256487985561453723478673303904688383436346553794986419270563872931748723320837601123029911367938627089438799362016295154133714248928307220126901475466847653576164773794675200490757155527819653621323926406160136358155907422020203187277605277219005561484255518792530343513984425322341576233610642506390497500865627109535919465897514131034822769306247435363256916078154781811528436679570611086153315044521274739245449454236828860613408414863776700961207151249140430272538607648236341433462351897576645216413767969031495019108575984423919862916421939949072362346468441173940326591840443780513338945257423995082965912285085558215725031071257012668302402929525220118726767562204154205161841634847565169998116141010029960783869092916030288400269104140792886215078424516709087000699282120660418371806535567252532567532861291042487761825829765157959847035622262934860034158722980534989650226291748788202734209222245339856264766914905562842503912757710284027998066365825488926488025456610172967026640765590429099456815065265305371829412703369313785178609040708667114965583434347693385781711386455873678123014587687126603489139095620099393610310";
    private static HugeDecimal PI = HugeDecimal.parse("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632788659361533818279682303019520353018529689957736225994138912497217752834791315155748572424541506959508295331168617278558890750983817546374649393192550604009277016711390098488240128583616035637076601047101819429555961989467678374494482553797747268471040475346462080466842590694912933136770289891521047521620569660240580381501935112533824300355876402474964732639141992726042699227967823547816360093417216412199245863150302861829745557067498385054945885869269956909272107975093029553211653449872027559602364806654991198818347977535663698074265425278625518184175746728909777727938000816470600161452491921732172147723501414419735685481613611573525521334757418494684385233239073941433345477624168625189835694855620992192221842725502542568876717904946016534668049886272327917860857843838279679766814541009538837863609506800642251252051173929848960841284886269456042419652850222106611863067442786220391949450471237137869609563643719172874677646575739624138908658326459958133904780275900994657640789512694683983525957098258226205224894077267194782684826014769909026401363944374553050682034962524517493996514314298091906592509372216964615157098583874105978859597729754989301617539284681382686838689427741559918559252459539594310499725246808459872736446958486538367362226260991246080512438843904512441365497627807977156914359977001296160894416948685558484063534220722258284886481584560285060168427394522674676788952521385225499546667278239864565961163548862305774564980355936345681743241125150760694794510965960940252288797108931456691368672287489405601015033086179286809208747609178249385890097149096759852613655497818931297848216829989487226588048575640142704775551323796414515237462343645428584447952658678210511413547357395231134271661021359695362314429524849371871101457654035902799344037420073105785390621983874478084784896833214457138687519435064302184531910484810053706146806749192781911979399520614196634287544406437451237181921799983910159195618146751426912397489409071864942319615679452080951465502252316038819301420937621378559566389377870830390697920773467221825625996615014215030680384477345492026054146659252014974428507325186660021324340881907104863317346496514539057962685610055081066587969981635747363840525714591028970641401109712062804390397595156771577004203378699360072305587631763594218731251471205329281918261861258673215791984148488291644706095752706957220917567116722910981690915280173506712748583222871835209353965725121083579151369882091444210067510334671103141267111369908658516398315019701651511685171437657618351556508849099898599823873455283316355076479185358932261854896321329330898570642046752590709154814165498594616371802709819943099244889575712828905923233260972997120844335732654893823911932597463667305836041428138830320382490375898524374417029132765618093773444030707469211201913020330380197621101100449293215160842444859637669838952286847831235526582131449576857262433441893039686426243410773226978028073189154411010446823252716201052652272111660396665573092547110557853763466820653109896526918620564769312570586356620185581007293606598764861179104533488503461136576867532494416680396265797877185560845529654126654085306143444318586769751456614068007002378776591344017127494704205622305389945613140711270004078547332699390814546646458807972708266830634328587856983052358089330657574067954571637752542021149557615814002501262285941302164715509792592309907965473761255176567513575178296664547791745011299614890304639947132962107340437518957359614589019389713111790429782856475032031986915140287080859904801094121472213179476477726224142548545403321571853061422881375850430633217518297986622371721591607716692547487389866549494501146540628433663937900397692656721463853067360965712091807638327166416274888800786925602902284721040317211860820419000422966171196377921337575114959501566049631862947265473642523081770367515906735023507283540567040386743513622224771589150495309844489333096340878076932599397805419341447377441842631298608099888687413260472156951623965864573021631598193195167353812974167729478672422924654366800980676928238280689964004824354037014163149658979409243237896907069779422362508221688957383798623001593776471651228935786015881617557829735233446042815126272037343146531977774160319906655418763979293344195215413418994854447345673831624993419131814809277771038638773431772075456545322077709212019051660962804909263601975988281613323166636528619326686336062735676303544776280350450777235547105859548702790814356240145171806246436267945612753181340783303362542327839449753824372058353114771199260638133467768796959703098339130771098704085913374641442822772634659470474587847787201927715280731767907707157213444730605700733492436931138350493163128404251219256517980694113528013147013047816437885185290928545201165839341965621349143415956258658655705526904965209858033850722426482939728584783163057777560688876446248246857926039535277348030480290058760758251047470916439613626760449256274204208320856611906254543372131535958450687724602901618766795240616342522577195429162991930645537799140373404328752628889639958794757291746426357455254079091451357111369410911939325191076020825202618798531887705842972591677813149699009019211697173727847684726860849003377024242916513005005168323364350389517029893922334517220138128069650117844087451960121228599371623130171144484640903890644954440061986907548516026327505298349187407866808818338510228334508504860825039302133219715518430635455007668282949304137765527939751754613953984683393638304746119966538581538420568533862186725233402830871123282789212507712629463229563989898935821167456270102183564622013496715188190973038119800497340723961036854066431939509790190699639552453005450580685501956730229219139339185680344903982059551002263535361920419947455385938102343955449597783779023742161727111723643435439478221818528624085140066604433258885698670543154706965747458550332323342107301545940516553790686627333799585115625784322988273723198987571415957811196358330059408730681216028764962867446047746491599505497374256269010490377819868359381465741268049256487985561453723478673303904688383436346553794986419270563872931748723320837601123029911367938627089438799362016295154133714248928307220126901475466847653576164773794675200490757155527819653621323926406160136358155907422020203187277605277219005561484255518792530343513984425322341576233610642506390497500865627109535919465897514131034822769306247435363256916078154781811528436679570611086153315044521274739245449454236828860613408414863776700961207151249140430272538607648236341433462351897576645216413767969031495019108575984423919862916421939949072362346468441173940326591840443780513338945257423995082965912285085558215725031071257012668302402929525220118726767562204154205161841634847565169998116141010029960783869092916030288400269104140792886215078424516709087000699282120660418371806535567252532567532861291042487761825829765157959847035622262934860034158722980534989650226291748788202734209222245339856264766914905562842503912757710284027998066365825488926488025456610172967026640765590429099456815065265305371829412703369313785178609040708667114965583434347693385781711386455873678123014587687126603489139095620099393610310");

    public static HugeDecimal PI(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("PI cannot have a precision less than zero!");
        }
        if ((long)precision > PI.getPrecision()) {
            throw new IllegalArgumentException("PI cannot have a precision greater than " + PI.getPrecision() + "!");
        }
        return PI.clone().setPrecision(precision);
    }

    public static HugeDecimal parse(String str) throws NumberFormatException {
        HugeDecimal val = new HugeDecimal();
        byte[] digits = val.digits;
        boolean next = str.contains(".");
        if (str.startsWith("-")) {
            val.negative = true;
            str = str.substring(1);
        }
        if (next) {
            while (str.length() > 8193 && str.startsWith("0")) {
                str = str.substring(1);
            }
            if (str.startsWith(".") && str.length() > 8192) {
                str = str.substring(1);
                val.firstDecimal = 0L;
                next = false;
                while (str.length() > 8192 && str.startsWith("0")) {
                    str = str.substring(1);
                    --val.firstDecimal;
                }
                if (str.length() > 8192) {
                    str = str.substring(0, 8192);
                }
            }
            if (next && str.length() > 8193) {
                val.firstDecimal = str.indexOf(".");
                if (!(str = str.substring(0, 8193)).contains(".") || str.endsWith(".")) {
                    str = str.substring(0, 8192);
                    next = false;
                }
            }
            if (str.startsWith(".")) {
                str = "0" + str;
            }
            if (next && str.length() <= 8193) {
                val.firstDecimal = (short)(digits.length - str.length() + str.indexOf(".") + 1);
                str = str.substring(0, str.indexOf(".")) + str.substring(str.indexOf(".") + 1);
            }
        } else {
            while (str.length() > 8192 && str.startsWith("0")) {
                str = str.substring(1);
            }
            if (str.length() > 8192) {
                val.firstDecimal = str.length();
                str = str.substring(0, 8192);
            } else {
                val.firstDecimal = 8192L;
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            digits[digits.length - str.length() + i] = (byte)(str.charAt(i) - 48);
        }
        return val;
    }

    public static HugeDecimal compare(HugeDecimal a, HugeDecimal b) {
        int i;
        int indexA;
        long magA = a.getMagnitude();
        long magB = b.getMagnitude();
        if (a.negative && !b.negative) {
            return b;
        }
        if (b.negative && !a.negative) {
            return a;
        }
        if (magA > magB) {
            return a.negative ? b : a;
        }
        if (magB > magA) {
            return a.negative ? a : b;
        }
        int indexB = 0;
        for (indexA = 0; indexA < 8192 && a.digits[indexA] == 0; indexA = (int)((short)(indexA + 1))) {
        }
        while (indexB < 8192 && b.digits[indexB] == 0) {
            indexB = (short)(indexB + 1);
        }
        while (indexA < 8192 && indexB < 8192) {
            byte A = a.digits[indexA];
            byte B = b.digits[indexB];
            if (A > B) {
                return a.negative ? b : a;
            }
            if (B > A) {
                return a.negative ? a : b;
            }
            indexA = (short)(indexA + 1);
            indexB = (short)(indexB + 1);
        }
        for (i = indexA; i < 8192; i = (int)((short)(i + 1))) {
            if (a.digits[i] <= 0) continue;
            return a.negative ? b : a;
        }
        for (i = indexB; i < 8192; i = (int)((short)(i + 1))) {
            if (b.digits[i] <= 0) continue;
            return a.negative ? a : b;
        }
        return null;
    }

    @Override
    public int compareTo(HugeDecimal other) {
        HugeDecimal a = HugeDecimal.compare(this, other);
        if (a == this) {
            return 1;
        }
        if (a == other) {
            return -1;
        }
        return 0;
    }

    private HugeDecimal() {
    }

    public static HugeDecimal Zero() {
        return new HugeDecimal();
    }

    public static HugeDecimal One() {
        return HugeDecimal.parse("1");
    }

    public boolean isNegative() {
        return this.negative;
    }

    public String toString() {
        long i;
        String lead;
        boolean hitYet = false;
        boolean hit = false;
        String val = "";
        for (int i2 = 0; i2 < 8192; ++i2) {
            if (!hitYet && this.digits[i2] <= 0 && this.firstDecimal - 1L > (long)i2) continue;
            hitYet = true;
            if ((long)i2 == this.firstDecimal && i2 > 0) {
                val = val + ".";
            }
            val = val + this.digits[i2];
            hit |= this.digits[i2] > 0;
        }
        if (!hit) {
            val = "0";
            this.negative = false;
            this.firstDecimal = 8192L;
        }
        String string = lead = this.negative ? "-" : "";
        if (this.firstDecimal <= 0L) {
            hitYet = true;
            lead = lead + "0.";
            for (i = 0L; i < -this.firstDecimal; ++i) {
                lead = lead + "0";
            }
        }
        val = lead + val;
        for (i = 0L; i < this.firstDecimal - 8192L; ++i) {
            val = val + "0";
        }
        return val;
    }

    public String toReadableString() {
        long i;
        String lead;
        boolean hitYet = false;
        boolean hit = false;
        String val = "";
        for (int i2 = 0; i2 < 8192; ++i2) {
            if (!hitYet && this.digits[i2] <= 0 && this.firstDecimal - 1L > (long)i2) continue;
            if (hitYet && (long)i2 < this.firstDecimal && ((long)i2 - this.firstDecimal) % 3L == 0L) {
                val = val + ",";
            } else if (hitYet && (long)i2 > this.firstDecimal && (this.firstDecimal - (long)i2) % 3L == 0L) {
                val = val + ",";
            }
            hitYet = true;
            if ((long)i2 == this.firstDecimal && i2 > 0) {
                val = val + ".";
            }
            val = val + this.digits[i2];
            hit |= this.digits[i2] > 0;
        }
        if (!hit) {
            val = "0";
            this.negative = false;
            this.firstDecimal = 8192L;
        }
        String string = lead = this.negative ? "-" : "";
        if (this.firstDecimal <= 0L) {
            hitYet = true;
            lead = lead + "0.";
            for (i = 0L; i < -this.firstDecimal; ++i) {
                lead = lead + "0";
            }
        }
        val = lead + val;
        for (i = 0L; i < this.firstDecimal - 8192L; ++i) {
            if ((8192L - this.firstDecimal + i) % 3L == 0L) {
                val = val + ",";
            }
            val = val + "0";
        }
        return val;
    }

    public long getPrecision() {
        return 8192L - this.firstDecimal;
    }

    public long getMagnitude() {
        int mag = 8192;
        for (int i = 0; i < 8192; i = (int)((short)(i + 1))) {
            if (this.digits[i] <= 0) continue;
            mag = i;
            break;
        }
        if (mag == 8192) {
            this.firstDecimal = 8192L;
            this.negative = false;
        }
        return this.firstDecimal - (long)mag;
    }

    public boolean isZero() {
        return this.getMagnitude() == 0L && this.getPrecision() == 0L;
    }

    public HugeDecimal zero() {
        for (int i = 0; i < this.digits.length; ++i) {
            this.digits[i] = 0;
        }
        this.negative = false;
        this.firstDecimal = 8192L;
        return this;
    }

    public HugeDecimal setPrecision(long precision) {
        long mag = this.getMagnitude();
        long current = this.getPrecision();
        short digitsUsed = (short)(mag + current);
        long desiredDigits = mag + precision;
        long precisionChange = precision - current;
        boolean willZero = false;
        if (precisionChange > 8192L || precisionChange < -8192L) {
            willZero = true;
        } else if (precisionChange > 0L && desiredDigits > 8192L) {
            willZero = true;
            for (int i = (int)precisionChange; i < 8192; ++i) {
                if (this.digits[i] <= 0) continue;
                willZero = false;
                break;
            }
        } else if (precisionChange < 0L && mag <= -precision) {
            boolean bl = willZero = mag != -precision || this.digits[8192 + (int)precisionChange] <= 4;
        }
        if (willZero) {
            this.zero();
            this.firstDecimal = 8192L - precision;
        } else if (precisionChange > 0L) {
            this.shiftLeft((short)precisionChange);
        } else if (precisionChange < 0L) {
            byte digit = this.digits[8192 + (int)precisionChange];
            this.shiftRight((short)(-precisionChange));
            if (digit > 4) {
                this.digits[8191] = (byte)(this.digits[8191] + 1);
                this.finishAddition();
            }
        }
        return this;
    }

    public HugeDecimal capPrecision(long precision) {
        this.minimizePrecision();
        if (this.getPrecision() > precision) {
            this.setPrecision(precision);
            this.minimizePrecision();
        }
        return this;
    }

    public HugeDecimal maximizePrecision() {
        if (this.isZero()) {
            return this;
        }
        long digits = this.getMagnitude() + this.getPrecision();
        this.shiftLeft((short)(8192L - digits));
        return this;
    }

    public HugeDecimal minimizePrecision() {
        if (this.isZero()) {
            return this;
        }
        short count = 0;
        for (int i = 8191; i >= 0 && this.digits[i] == 0; --i) {
            count = (short)(count + 1);
        }
        this.shiftRight(count);
        return this;
    }

    private HugeDecimal shiftLeft(short change) {
        int i;
        if (change < 1) {
            return this;
        }
        for (i = 0; i < 8192 - change; ++i) {
            this.digits[i] = this.digits[i + change];
        }
        for (i = 8192 - change; i < 8192; ++i) {
            this.digits[i] = 0;
        }
        this.firstDecimal -= (long)change;
        return this;
    }

    private HugeDecimal shiftRight(short change) {
        int i;
        if (change < 1) {
            return this;
        }
        for (i = 8191; i >= change; --i) {
            this.digits[i] = this.digits[i - change];
        }
        for (i = 0; i < change; ++i) {
            this.digits[i] = 0;
        }
        this.firstDecimal += (long)change;
        return this;
    }

    private void finishAddition() {
        for (int i = 8191; i > 0; --i) {
            while (this.digits[i] > 9) {
                int n = i;
                this.digits[n] = (byte)(this.digits[n] - 10);
                int n2 = i - 1;
                this.digits[n2] = (byte)(this.digits[n2] + 1);
            }
        }
        if (this.digits[0] > 9) {
            this.shiftRight((short)1);
            this.finishAddition();
        }
    }

    private void finishSubtraction() {
        int i;
        for (i = 8191; i > 0; --i) {
            if (this.digits[i] >= 0) continue;
            int n = i;
            this.digits[n] = (byte)(this.digits[n] + 10);
            int n2 = i - 1;
            this.digits[n2] = (byte)(this.digits[n2] - 1);
        }
        if (this.digits[0] < 0) {
            this.digits[0] = 1;
            for (i = 1; i < 8192; ++i) {
                this.digits[i] = -this.digits[i];
            }
            this.negative = !this.negative;
            this.finishSubtraction();
        }
    }

    public HugeDecimal clone() {
        return new HugeDecimal().write(this);
    }

    public HugeDecimal write(HugeDecimal a) {
        this.firstDecimal = a.firstDecimal;
        this.negative = a.negative;
        System.arraycopy(a.digits, 0, this.digits, 0, 8192);
        return this;
    }

    public HugeDecimal add(HugeDecimal a) {
        if (a.negative != this.negative) {
            a = a.clone();
            a.negative = this.negative;
            return this.subtract(a);
        }
        long mag = this.getMagnitude();
        long mag2 = a.getMagnitude();
        long precision = this.getPrecision();
        long precision2 = a.getPrecision();
        long maxPrecision = Math.min(8192L - mag, 8192L - mag2);
        long newPrecision = Math.min(maxPrecision, Math.max(precision, precision2));
        this.setPrecision(newPrecision);
        long offset = newPrecision - precision2;
        for (long i = offset < 0L ? -offset : 0L; i < 8192L - (offset > 0L ? offset : 0L); ++i) {
            int n = (int)i;
            this.digits[n] = (byte)(this.digits[n] + a.digits[(int)(i + offset)]);
        }
        this.finishAddition();
        return this;
    }

    public HugeDecimal subtract(HugeDecimal a) {
        if (a.negative != this.negative) {
            a = a.clone();
            a.negative = this.negative;
            return this.add(a);
        }
        long mag = this.getMagnitude();
        long mag2 = a.getMagnitude();
        long precision = this.getPrecision();
        long precision2 = a.getPrecision();
        long maxPrecision = Math.min(8192L - mag, 8192L - mag2);
        long newPrecision = Math.min(maxPrecision, Math.max(precision, precision2));
        this.setPrecision(newPrecision);
        long offset = newPrecision - precision2;
        for (long i = offset < 0L ? -offset : 0L; i < 8192L - (offset > 0L ? offset : 0L); ++i) {
            int n = (int)i;
            this.digits[n] = (byte)(this.digits[n] - a.digits[(int)(i + offset)]);
        }
        this.finishSubtraction();
        return this;
    }

    public HugeDecimal multiply(HugeDecimal a) {
        boolean willNegative = a.negative != this.negative;
        this.negative = a.negative;
        HugeDecimal b = this.clone();
        HugeDecimal temp = new HugeDecimal();
        this.zero();
        long digits = a.getMagnitude() + a.getPrecision();
        int i = 0;
        while ((long)i < digits) {
            temp.write((HugeDecimal)b).multiply((byte)a.digits[8191 - i]).firstDecimal += (long)i - a.getPrecision();
            this.add(temp);
            ++i;
        }
        this.negative = willNegative;
        return this;
    }

    private HugeDecimal multiply(byte a) {
        int i = 0;
        while (i < this.digits.length) {
            int n = i++;
            this.digits[n] = (byte)(this.digits[n] * a);
        }
        this.finishAddition();
        return this;
    }

    private HugeDecimal setDigit(long magnitude, byte value) {
        long mag = this.getMagnitude();
        long precision = this.getPrecision();
        long maxPrecision = 8192L - magnitude;
        long minPrecision = 1L - magnitude;
        if (precision < minPrecision) {
            long maxPermissible = 8192L - mag;
            if (maxPermissible < minPrecision) {
                return this;
            }
            this.setPrecision(minPrecision);
            precision = this.getPrecision();
        } else if (precision > maxPrecision) {
            this.setPrecision(maxPrecision);
            precision = this.getPrecision();
        }
        long digit = precision + magnitude;
        this.digits[(int)(8192L - digit)] = value;
        return this;
    }

    public HugeDecimal divide(HugeDecimal a) {
        if (a.isZero()) {
            throw new IllegalArgumentException("Cannot devide by zero");
        }
        if (this.isZero()) {
            return this;
        }
        boolean willNegative = a.negative != this.negative;
        this.negative = a.negative;
        HugeDecimal c = a.clone();
        HugeDecimal b = this.clone();
        long origMag = c.getMagnitude();
        this.zero();
        this.setPrecision(b.getPrecision());
        HugeDecimal temp = new HugeDecimal();
        while (!b.isZero() && (this.isZero() || b.getMagnitude() + 8192L >= this.getMagnitude())) {
            b.maximizePrecision();
            long magb = b.getMagnitude();
            long magc = c.getMagnitude();
            long difference = magb - magc;
            long digit = magb - origMag;
            c.firstDecimal += difference;
            if (HugeDecimal.compare(b, c) != c) {
                ++c.firstDecimal;
                ++digit;
            }
            temp.write(c);
            --c.firstDecimal;
            byte val = 10;
            do {
                temp.subtract(c);
                val = (byte)(val - 1);
            } while (HugeDecimal.compare(b, temp) == temp);
            b.subtract(temp);
            this.setDigit(digit, val);
        }
        this.negative = willNegative;
        return this;
    }

    public HugeDecimal remainder(HugeDecimal a) {
        if (a.isZero()) {
            throw new IllegalArgumentException("Cannot devide by zero");
        }
        boolean willNegative = a.negative != this.negative;
        this.negative = a.negative;
        HugeDecimal c = a.clone();
        HugeDecimal b = this.clone();
        long origPrecision = this.getPrecision();
        this.zero();
        this.setPrecision(b.getPrecision());
        HugeDecimal temp = new HugeDecimal();
        while (!b.isZero() && b.getPrecision() - 8192L < this.getPrecision()) {
            b.maximizePrecision();
            long magb = b.getMagnitude();
            long magc = c.getMagnitude();
            long difference = magb - magc;
            long digit = magb - magc;
            c.firstDecimal += difference;
            if (HugeDecimal.compare(b, c) != c) {
                ++c.firstDecimal;
                ++digit;
            }
            temp.write(c);
            --c.firstDecimal;
            byte val = 10;
            do {
                temp.subtract(c);
                val = (byte)(val - 1);
            } while (HugeDecimal.compare(b, temp) == temp);
            if (digit < 1L) break;
            b.subtract(temp);
            this.setDigit(digit, val);
        }
        b.maximizePrecision();
        long p1 = b.getPrecision();
        b.minimizePrecision();
        long p2 = b.getPrecision();
        this.write(b);
        if (!this.isZero()) {
            this.setPrecision(Math.max(p2, Math.min(p1, Math.max(origPrecision, a.getPrecision()))));
        }
        return this;
    }

    public static HugeDecimal add(HugeDecimal a, HugeDecimal b) {
        return a.clone().add(b);
    }

    public static HugeDecimal subtract(HugeDecimal a, HugeDecimal b) {
        return a.clone().subtract(b);
    }

    public static HugeDecimal multiply(HugeDecimal a, HugeDecimal b) {
        return a.clone().multiply(b);
    }

    public static HugeDecimal divide(HugeDecimal a, HugeDecimal b) {
        return a.clone().divide(b);
    }

    public static HugeDecimal remainder(HugeDecimal a, HugeDecimal b) {
        return a.clone().remainder(b);
    }
}

