/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.openal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.lwjgl.openal.AL10;
import simplelibrary.openal.SoundChannel;
import simplelibrary.openal.SoundStash;
import simplelibrary.openal.SoundSystem;
import simplelibrary.openal.decoding.AudioDecoder;
import simplelibrary.openal.decoding.DecodedAudioInputStream;
import simplelibrary.texture.TexturePackManager;

public class Song {
    private int overallSongLength = -1;
    private int totalSongLength = -1;
    private final ArrayList<String> buffers = new ArrayList();
    private final HashSet<SoundChannel> channels = new HashSet();
    private final String path;
    private final int channelCount;
    private final int sampleSize;
    private final int sampleRate;
    private int autoUnload = 2;
    private InputStream in;
    private final SoundSystem ss;
    private int autoUnloadTick;

    Song(String path, SoundSystem ss) throws IOException {
        this.path = path;
        this.ss = ss;
        try (InputStream in = Song.getSoundInputStream(path);){
            int val;
            if (in instanceof AudioInputStream) {
                AudioFormat f = ((AudioInputStream)in).getFormat();
                this.channelCount = f.getChannels();
                this.sampleSize = f.getSampleSizeInBits();
                this.sampleRate = (int)f.getFrameRate();
            } else {
                DecodedAudioInputStream din = (DecodedAudioInputStream)in;
                this.channelCount = din.getChannelCount();
                this.sampleSize = din.getSampleSize();
                this.sampleRate = din.getSampleRate();
            }
            byte[] data = new byte[this.sampleRate * 5 * (this.sampleSize / 8) * this.channelCount];
            for (int pos = 0; pos < data.length; pos += val) {
                val = in.read(data, pos, data.length - pos);
                if (val >= 1) continue;
                throw new IllegalArgumentException("Songs must be over 5 seconds long!");
            }
            SoundStash.allocateNew(data, path, this.channelCount, this.sampleSize, (float)this.sampleRate);
            this.buffers.add(path);
        }
    }

    private static InputStream getSoundInputStream(String filepath) throws IOException {
        BufferedInputStream in = new BufferedInputStream(TexturePackManager.instance.currentTexturePack.getResourceAsStream(filepath));
        in.mark(0);
        try {
            return AudioSystem.getAudioInputStream(in);
        }
        catch (Exception ex) {
            if (!(ex instanceof UnsupportedAudioFileException)) {
                in.close();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
            }
            for (AudioDecoder d : SoundSystem.decoders) {
                DecodedAudioInputStream din = d.getInputStream(in);
                if (din == null) continue;
                return din;
            }
            in.close();
            return null;
        }
    }

    void onDestroy() {
        this.buffers.clear();
        this.channels.clear();
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void update() {
        if (this.channels.isEmpty()) {
            if (this.buffers.size() > 1) {
                boolean autoUnload;
                boolean bl = autoUnload = (this.autoUnload & (this.ss.getAutoUnloadDefault() ? 3 : 1)) > 0;
                if (autoUnload) {
                    ++this.autoUnloadTick;
                    if (this.autoUnloadTick > 60 && autoUnload) {
                        this.doUnload();
                    }
                }
            }
            return;
        }
        this.autoUnloadTick = 0;
        boolean loadNext = false;
        Iterator<SoundChannel> it = this.channels.iterator();
        while (it.hasNext()) {
            SoundChannel c = it.next();
            if (c.isStopped()) {
                c.dequeue();
                it.remove();
                continue;
            }
            String current = c.getCurrentSound();
            if (current == null) {
                c.dequeue();
                it.remove();
                continue;
            }
            if (!this.path.equals(current)) {
                this.dequeue(c);
                it.remove();
                continue;
            }
            if (c.getPlayheadPosition() < this.getLoadedSongLength() - 10000) continue;
            loadNext = true;
        }
        if (loadNext) {
            if (this.overallSongLength > 0 && this.buffers.size() >= this.overallSongLength) {
                return;
            }
            try {
                this.loadNextSegment();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void doUnload() {
        try {
            this.in.close();
            this.in = null;
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        while (this.buffers.size() > 1) {
            SoundStash.removeBuffer(this.buffers.remove(this.buffers.size() - 1));
        }
    }

    private void doCompleteUnload() {
        try {
            this.in.close();
            this.in = null;
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        this.buffers.stream().forEach(e -> SoundStash.removeBuffer(e));
        this.buffers.clear();
    }

    private int getLoadedSongLength() {
        int size = this.buffers.size();
        if (size == 0) {
            return 0;
        }
        if (size == 1) {
            return 5000;
        }
        if (size == 2) {
            return 30000;
        }
        return (size - 2) * 60000 + 30000;
    }

    private synchronized void loadNextSegment() throws IOException {
        int pos;
        int val;
        if (this.in == null) {
            int val2;
            this.in = Song.getSoundInputStream(this.path);
            int length = this.getLoadedSongLength() / 1000;
            byte[] data = new byte[this.sampleRate * 5 * (this.sampleSize / 8) * this.channelCount];
            for (int toSkip = data.length / 5 * length; toSkip > 0; toSkip -= val2) {
                val2 = this.in.read(data, 0, Math.min(toSkip, data.length));
                if (val2 >= 1) continue;
                this.in.close();
                this.overallSongLength = this.buffers.size();
                this.computeTotalSongLength();
                this.in = null;
            }
        }
        byte[] data = new byte[this.sampleRate * (this.sampleSize / 8) * this.channelCount * (this.buffers.size() == 1 ? 25 : 60)];
        for (pos = 0; pos < data.length && (val = this.in.read(data, pos, data.length - pos)) >= 1; pos += val) {
        }
        if (pos == 0) {
            this.in.close();
            this.in = null;
            this.overallSongLength = this.buffers.size();
            this.computeTotalSongLength();
            return;
        }
        if (pos < data.length) {
            byte[] newdata = new byte[pos];
            System.arraycopy(data, 0, newdata, 0, newdata.length);
            data = newdata;
            this.in.close();
            this.in = null;
            this.overallSongLength = this.buffers.size() + 1;
        }
        int buff = SoundStash.allocateNew(data, this.path + "_" + this.buffers.size(), this.channelCount, this.sampleSize, (float)this.sampleRate);
        this.buffers.add(this.path + "_" + this.buffers.size());
        if (this.totalSongLength < 0 && this.overallSongLength > 0) {
            this.computeTotalSongLength();
        }
        this.channels.stream().filter(e -> !e.isStopped()).filter(e -> e.getCurrentSound() != null && e.getCurrentSound().equals(this.path)).forEach(e -> AL10.alSourceQueueBuffers((int)SoundStash.getSource(e.getName()), (int)buff));
    }

    private void computeTotalSongLength() {
        this.totalSongLength = 0;
        for (String b : this.buffers) {
            this.totalSongLength += SoundStash.getMillisecondDuration(b);
        }
    }

    private synchronized void loadFirstSegment() throws IOException {
        if (!this.buffers.isEmpty()) {
            return;
        }
        try (InputStream in = Song.getSoundInputStream(this.path);){
            int val;
            byte[] data = new byte[this.sampleRate * 5 * (this.sampleSize / 8) * this.channelCount];
            for (int pos = 0; pos < data.length; pos += val) {
                val = in.read(data, pos, data.length - pos);
                if (val >= 1) continue;
                throw new IllegalArgumentException("Songs must be over 5 seconds long!");
            }
            SoundStash.allocateNew(data, this.path, this.channelCount, this.sampleSize, (float)this.sampleRate);
            this.buffers.add(this.path);
        }
    }

    public void setAutoUnload(boolean autoUnload) {
        this.autoUnload = autoUnload ? 1 : 0;
    }

    public void resetAutoUnload() {
        this.autoUnload = 2;
    }

    synchronized void addPlayer(SoundChannel channel) {
        try {
            this.loadFirstSegment();
        }
        catch (IOException ex) {
            return;
        }
        channel.doPlay(this.path, channel.isLooping(), channel.autoplay);
        channel.lastSong = this;
        channel.lastSound = null;
        this.channels.add(channel);
        int src = SoundStash.getSource(channel.getName());
        for (int i = 1; i < this.buffers.size(); ++i) {
            AL10.alSourceQueueBuffers((int)src, (int)SoundStash.getBuffer(this.buffers.get(i)));
        }
    }

    private void dequeue(SoundChannel c) {
        int src = SoundStash.getSource(c.getName());
        int buff = AL10.alGetSourcei((int)src, (int)4105);
        if (this.buffers.stream().map(e -> SoundStash.getBuffer(e)).anyMatch(e -> e == buff)) {
            AL10.alSourcei((int)src, (int)4105, (int)0);
        }
    }

    public synchronized void unload() {
        if (this.channels.stream().filter(e -> e.isPlaying() || e.isPaused()).anyMatch(e -> e.getCurrentSound() != null && e.getCurrentSound().equals(this.path))) {
            throw new IllegalStateException("Song is in use!");
        }
        this.doUnload();
    }

    public synchronized void completeUnload() {
        if (this.channels.stream().filter(e -> e.isPlaying() || e.isPaused()).anyMatch(e -> e.getCurrentSound() != null && e.getCurrentSound().equals(this.path))) {
            throw new IllegalStateException("Song is in use!");
        }
        this.doCompleteUnload();
    }

    public synchronized void pushUnload() {
        if (this.channels.stream().filter(e -> e.isPlaying()).anyMatch(e -> e.getCurrentSound() != null && e.getCurrentSound().equals(this.path))) {
            throw new IllegalStateException("Song is in use!");
        }
        this.forceUnload();
    }

    public synchronized void pushCompleteUnload() {
        if (this.channels.stream().filter(e -> e.isPlaying()).anyMatch(e -> e.getCurrentSound() != null && e.getCurrentSound().equals(this.path))) {
            throw new IllegalStateException("Song is in use!");
        }
        this.forceCompleteUnload();
    }

    public synchronized void forceUnload() {
        this.channels.stream().filter(e -> e.getCurrentSound() == null || e.getCurrentSound().equals(this.path)).forEach(e -> e.dequeue());
        this.doUnload();
    }

    public synchronized void forceCompleteUnload() {
        this.channels.stream().filter(e -> e.getCurrentSound() == null || e.getCurrentSound().equals(this.path)).forEach(e -> e.dequeue());
        this.doCompleteUnload();
    }

    public synchronized void loadCompletely() {
        try {
            this.loadFirstSegment();
            while (this.overallSongLength < 0 || this.buffers.size() < this.overallSongLength) {
                this.loadNextSegment();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.channels.isEmpty() && (this.autoUnload & (this.ss.getAutoUnloadDefault() ? 3 : 1)) > 0) {
            this.doUnload();
        }
    }

    public int getTotalLength() {
        return this.totalSongLength < 0 ? this.getLoadedSongLength() : this.totalSongLength;
    }

    public boolean wasLoadedCompletely() {
        return this.overallSongLength > 0;
    }

    public String getPath() {
        return this.path;
    }
}

