/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.openal;

import org.lwjgl.openal.AL10;
import simplelibrary.openal.Autoplayer;
import simplelibrary.openal.Song;
import simplelibrary.openal.SoundStash;
import simplelibrary.openal.SoundSystem;

public class SoundChannel {
    private final SoundSystem sys;
    private final String name;
    private final int src;
    private float volume = 1.0f;
    private int fadeProgress = -1;
    private int fadeSteps = 60;
    private State state;
    Autoplayer autoplay;
    private boolean skipOnFadeComplete;
    String lastSound;
    Song lastSong;
    private long nanoPlayTime;
    private long nanoPauseTime;
    private String nextSound;
    private Song nextSong;

    SoundChannel(SoundSystem sys, String channelName) {
        this.sys = sys;
        this.name = channelName;
        this.src = SoundStash.getSource(this.name);
    }

    void destroy() {
        this.stop();
        SoundStash.removeSource(this.name);
    }

    synchronized void update() {
        int s = AL10.alGetSourcei((int)this.src, (int)4112);
        switch (s) {
            case 4114: {
                this.state = State.PLAYING;
                break;
            }
            case 4115: {
                this.state = State.PAUSED;
                break;
            }
            default: {
                this.state = State.STOPPED;
            }
        }
        if (this.state == State.STOPPED) {
            if (this.fadeProgress >= 0 && !this.skipOnFadeComplete) {
                this.fadeProgress = -1;
                if (this.nextSound != null) {
                    this.doPlay(this.nextSound, false, this.autoplay);
                    this.nextSound = null;
                } else if (this.nextSong != null) {
                    this.doPlay(this.nextSong, false, this.autoplay);
                    this.nextSong = null;
                } else if (this.autoplay != null) {
                    this.tryAutoplay();
                    if (AL10.alGetSourcei((int)this.src, (int)4112) == 4114) {
                        this.pause();
                    } else {
                        this.autoplay = null;
                    }
                }
            }
            this.fadeProgress = -1;
            if (this.autoplay != null) {
                this.tryAutoplay();
            }
        }
        if (this.state == State.PLAYING && this.fadeProgress >= 0) {
            ++this.fadeProgress;
            if (this.fadeProgress >= this.fadeSteps) {
                if (this.skipOnFadeComplete) {
                    this.skipOnFadeComplete = false;
                    Autoplayer auto = this.autoplay;
                    this.stop();
                    this.autoplay(auto);
                } else if (this.nextSound != null) {
                    this.doPlay(this.nextSound, false, this.autoplay);
                    this.nextSound = null;
                } else if (this.nextSong != null) {
                    this.doPlay(this.nextSong, false, this.autoplay);
                    this.nextSong = null;
                } else {
                    this.pause();
                    AL10.alSourcef((int)this.src, (int)4106, (float)(this.volume * this.sys.getMasterVolume()));
                }
                this.fadeProgress = -1;
            } else {
                AL10.alSourcef((int)this.src, (int)4106, (float)(this.volume * this.sys.getMasterVolume() * (float)Math.pow(2.0, -6.0f * (float)this.fadeProgress / (float)this.fadeSteps)));
            }
        }
    }

    public synchronized boolean play() {
        boolean val;
        if (AL10.alGetSourcei((int)this.src, (int)4112) == 4114) {
            return true;
        }
        AL10.alSourcePlay((int)this.src);
        boolean bl = val = AL10.alGetSourcei((int)this.src, (int)4112) == 4114;
        if (val) {
            this.nanoPlayTime += System.nanoTime() - this.nanoPauseTime;
        }
        if (val) {
            this.state = State.PLAYING;
        }
        return val;
    }

    public synchronized boolean pause() {
        boolean val;
        if (AL10.alGetSourcei((int)this.src, (int)4112) == 4115) {
            return true;
        }
        AL10.alSourcePause((int)this.src);
        boolean bl = val = AL10.alGetSourcei((int)this.src, (int)4112) == 4115;
        if (val) {
            this.nanoPauseTime = System.nanoTime();
        }
        if (val) {
            this.state = State.PAUSED;
        }
        return val;
    }

    public synchronized void stop() {
        AL10.alSourceStop((int)this.src);
        this.autoplay = null;
        this.fadeProgress = -1;
        this.nextSound = null;
        this.nextSong = null;
        this.state = State.STOPPED;
    }

    void dequeue() {
        AL10.alSourceStop((int)this.src);
        this.state = State.STOPPED;
        try {
            AL10.alSourceUnqueueBuffers((int)this.src);
            AL10.alSourcei((int)this.src, (int)4105, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void fade(int sixtiethsOfASecond) {
        this.fadeProgress = Math.max(0, this.fadeProgress);
        this.fadeSteps = sixtiethsOfASecond;
    }

    public synchronized boolean isFading() {
        return this.fadeProgress >= 0 && this.state != State.STOPPED;
    }

    public synchronized boolean isPlaying() {
        return this.state == State.PLAYING;
    }

    public synchronized boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public synchronized boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public synchronized boolean isLooping() {
        return AL10.alGetSourcei((int)this.src, (int)4103) == 1;
    }

    public synchronized void setLooping(boolean loop) {
        AL10.alSourcei((int)this.src, (int)4103, (int)(loop ? 1 : 0));
    }

    public synchronized boolean play(String sound) {
        return this.play(sound, false);
    }

    public synchronized boolean play(Song sound) {
        return this.play(sound, false);
    }

    public synchronized boolean play(String sound, boolean loop) {
        return this.doPlay(sound, loop, null);
    }

    public synchronized boolean play(Song sound, boolean loop) {
        return this.doPlay(sound, loop, null);
    }

    synchronized boolean doPlay(String sound, boolean loop, Autoplayer auto) {
        int buffer = this.sys.getSound(sound);
        if (buffer == 0) {
            return false;
        }
        this.stop();
        this.setLooping(loop);
        this.autoplay = auto;
        try {
            AL10.alSourceUnqueueBuffers((int)this.src);
            AL10.alSourcei((int)this.src, (int)4105, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AL10.alSourceQueueBuffers((int)this.src, (int)buffer);
        AL10.alSourcef((int)this.src, (int)4106, (float)(this.volume * this.sys.getMasterVolume()));
        this.lastSound = sound;
        this.lastSong = null;
        this.nanoPlayTime = this.nanoPauseTime = System.nanoTime();
        return this.play();
    }

    synchronized boolean doPlay(Song sound, boolean loop, Autoplayer auto) {
        this.setLooping(loop);
        this.autoplay = auto;
        sound.addPlayer(this);
        this.play();
        return true;
    }

    public synchronized boolean loop(String sound) {
        return this.play(sound, true);
    }

    public synchronized boolean loop(Song sound) {
        return this.play(sound, true);
    }

    public synchronized void autoplay(Autoplayer source) {
        this.autoplay = source;
    }

    public synchronized void setVolume(float volume) {
        this.volume = Math.max(0.0f, Math.min(1.0f, volume));
        AL10.alSourcef((int)this.src, (int)4106, (float)(volume * this.sys.getMasterVolume()));
    }

    private void tryAutoplay() {
        Object sound = this.autoplay.next();
        if (sound == null) {
            return;
        }
        this.setVolume(this.autoplay.getVolume());
        if (sound instanceof String) {
            this.doPlay((String)sound, false, this.autoplay);
        } else {
            this.doPlay((Song)sound, false, this.autoplay);
        }
    }

    void updateMasterVolume() {
        if (this.state == State.PLAYING && this.fadeProgress == -1) {
            this.setVolume(this.volume);
        }
    }

    public void skip() {
        if (this.autoplay == null) {
            return;
        }
        this.tryAutoplay();
    }

    public void fadeSkip(int sixtiethsOfASecond) {
        this.fade(sixtiethsOfASecond);
        this.skipOnFadeComplete = true;
        this.nextSound = null;
        this.nextSong = null;
    }

    public void fadeTo(int sixtiethsOfASecond, String nextSong) {
        this.fade(sixtiethsOfASecond);
        this.nextSound = nextSong;
    }

    public void fadeTo(int sixtiethsOfASecond, Song nextSong) {
        this.fade(sixtiethsOfASecond);
        this.nextSong = nextSong;
    }

    public int getLastSoundLength() {
        if (this.lastSound != null) {
            return SoundStash.getMillisecondDuration(this.lastSound);
        }
        if (this.lastSong != null) {
            return this.lastSong.getTotalLength();
        }
        return -1;
    }

    public int getPlayheadPosition() {
        int state = AL10.alGetSourcei((int)this.src, (int)4112);
        if (state == 4114) {
            return (int)((System.nanoTime() - this.nanoPlayTime) / 1000000L);
        }
        if (state == 4115) {
            return (int)((this.nanoPauseTime - this.nanoPlayTime) / 1000000L);
        }
        return -1;
    }

    public String getCurrentSound() {
        if (this.getPlayheadPosition() >= 0) {
            return this.lastSound == null ? this.lastSong.getPath() : this.lastSound;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    private static enum State {
        PLAYING,
        PAUSED,
        STOPPED;

    }
}

