/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.openal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjgl.openal.AL10;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.texture.TexturePack;
import simplelibrary.texture.TexturePackManager;

public class SoundStash {
    private static final HashMap<String, Integer> sounds = new HashMap();
    private static final HashMap<String, Integer> lengths = new HashMap();
    private static final HashMap<String, Integer> sources = new HashMap();
    public static String lastError;
    public static Exception lastException;
    private static ByteBuffer soundData;
    private static int dataLength;
    private static boolean expanding;

    public static ByteBuffer createDirectByteBuffer(int bufferSize) {
        return ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
    }

    public static void expandAudioBuffer(int size) {
        if (size <= dataLength) {
            return;
        }
        if (size > (dataLength *= 2)) {
            dataLength = size;
        }
        soundData = SoundStash.createDirectByteBuffer(dataLength);
    }

    public static boolean hasBuffer(String filepath) {
        if (filepath == null || filepath.isEmpty()) {
            return false;
        }
        return sounds.containsKey(filepath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getBuffer(String filepath) {
        if (filepath == null) return 0;
        if (filepath.isEmpty()) {
            return 0;
        }
        TexturePack texture = TexturePackManager.instance.currentTexturePack;
        Integer bufferIndex = sounds.get(filepath);
        if (bufferIndex != null) {
            return bufferIndex;
        }
        try {
            InputStream in = texture.getResourceAsStream(filepath);
            if (in == null) {
                lastError = "Could not find sound file " + filepath + "!";
                lastException = null;
                return 0;
            }
            try (BufferedInputStream in2 = new BufferedInputStream(in);){
                int n = SoundStash.allocateNew(AudioSystem.getAudioInputStream(in2), filepath);
                return n;
            }
        }
        catch (Exception ex) {
            lastError = "Could not load sound file " + filepath;
            lastException = ex;
            return 0;
        }
    }

    public static void removeBuffer(String filepath) {
        if (!sounds.containsKey(filepath)) {
            return;
        }
        AL10.alDeleteBuffers((int)sounds.remove(filepath));
        lengths.remove(filepath);
    }

    public static void clearBuffers() {
        for (Integer val : sounds.values()) {
            AL10.alDeleteBuffers((int)val);
        }
        sounds.clear();
        lengths.clear();
    }

    public static int getSource(String name) {
        if (sources.containsKey(name)) {
            return sources.get(name);
        }
        int source = AL10.alGenSources();
        sources.put(name, source);
        return source;
    }

    public static int getMillisecondDuration(String name) {
        return lengths.containsKey(name) ? lengths.get(name) : -1;
    }

    public static void removeSource(String name) {
        if (!sources.containsKey(name)) {
            return;
        }
        AL10.alDeleteSources((int)sources.remove(name));
    }

    public static void clearSources() {
        for (Integer val : sources.values()) {
            AL10.alDeleteSources((int)val);
        }
        sources.clear();
    }

    private SoundStash() {
    }

    private static int allocateNew(AudioInputStream in, String filepath) throws IOException {
        float sampleRate = in.getFormat().getSampleRate();
        int channels = in.getFormat().getChannels();
        int sampleSize = in.getFormat().getSampleSizeInBits();
        return SoundStash.allocateNew(in, filepath, channels, sampleSize, sampleRate);
    }

    public static synchronized int allocateNew(InputStream in, String filepath, int channels, int sampleSize, float sampleRate) throws IOException {
        int alFormat;
        try (InputStream ain = in;){
            int read;
            if (channels == 1 && sampleSize == 8) {
                alFormat = 4352;
            } else if (channels == 1 && sampleSize == 16) {
                alFormat = 4353;
            } else if (channels == 2 && sampleSize == 8) {
                alFormat = 4354;
            } else if (channels == 2 && sampleSize == 16) {
                alFormat = 4355;
            } else {
                ain.close();
                lastError = "Invalid format of " + filepath + "- only supports mono & stereo, in 8 or 16 bits!";
                lastException = null;
                int n = 0;
                return n;
            }
            soundData.clear();
            byte[] data = new byte[1024];
            int size = 0;
            while ((read = ain.read(data)) != -1) {
                soundData.put(data, 0, read);
                size += read;
                if (soundData.remaining() >= 1024) continue;
                Sys.error(ErrorLevel.warning, "File too large, expanding audio buffer...", null, ErrorCategory.audio);
                expanding = true;
                ByteBuffer orig = soundData;
                SoundStash.expandAudioBuffer(dataLength * 2);
                orig.flip();
                soundData.put(orig);
                Sys.error(ErrorLevel.warning, "Audio buffer expansion complete.", null, ErrorCategory.audio);
            }
            if (expanding) {
                Sys.error(ErrorLevel.warning, "Read complete; data size " + soundData.limit() + "B", null, ErrorCategory.audio);
                expanding = false;
            }
        }
        soundData.flip();
        int length = soundData.limit();
        int name = AL10.alGenBuffers();
        AL10.alBufferData((int)name, (int)alFormat, (ByteBuffer)soundData, (int)((int)sampleRate));
        sounds.put(filepath, name);
        lengths.put(filepath, (int)((long)length * 1000L / (long)((int)sampleRate) / (long)channels / (long)(sampleSize / 8)));
        return name;
    }

    public static synchronized int allocateNew(byte[] data, String filepath, int channels, int sampleSize, float sampleRate) throws IOException {
        int alFormat;
        if (channels == 1 && sampleSize == 8) {
            alFormat = 4352;
        } else if (channels == 1 && sampleSize == 16) {
            alFormat = 4353;
        } else if (channels == 2 && sampleSize == 8) {
            alFormat = 4354;
        } else if (channels == 2 && sampleSize == 16) {
            alFormat = 4355;
        } else {
            lastError = "Invalid format of " + filepath + "- only supports mono & stereo, in 8 or 16 bits!";
            lastException = null;
            return 0;
        }
        SoundStash.expandAudioBuffer(data.length);
        soundData.clear();
        soundData.put(data, 0, data.length);
        soundData.flip();
        int name = AL10.alGenBuffers();
        AL10.alBufferData((int)name, (int)alFormat, (ByteBuffer)soundData, (int)((int)sampleRate));
        sounds.put(filepath, name);
        lengths.put(filepath, (int)((long)data.length * 1000L / (long)((int)sampleRate) / (long)channels / (long)(sampleSize / 8)));
        return name;
    }

    static {
        soundData = SoundStash.createDirectByteBuffer(0x4000000);
        dataLength = 0x4000000;
    }
}

