/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.openal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.openal.Song;
import simplelibrary.openal.SoundChannel;
import simplelibrary.openal.SoundStash;
import simplelibrary.openal.decoding.AudioDecoder;
import simplelibrary.openal.decoding.DecodedAudioInputStream;
import simplelibrary.openal.decoding.mp3.JLayerAudioDecoder;
import simplelibrary.texture.TexturePackManager;

public class SoundSystem {
    private boolean autoUnloadDefault = true;
    private int sfxChannel;
    private final int sfxChannels;
    private final String sfxPrefix;
    private final String sfxSuffix;
    private final HashMap<String, SoundChannel> channels = new HashMap();
    private final HashMap<String, Song> songs = new HashMap();
    static final ArrayList<AudioDecoder> decoders = new ArrayList();
    private final Thread loop;
    private boolean running = true;
    private float masterVolume = 1.0f;
    private float sfxVolume = 1.0f;
    private final long device;
    private long context;

    public SoundSystem(int sfxChannels) {
        this(sfxChannels, "/", ".wav");
    }

    public SoundSystem(int sfxChannels, String sfxPrefix, String sfxSuffix) {
        this(sfxChannels, sfxPrefix, sfxSuffix, new String[0]);
    }

    public SoundSystem(int sfxChannels, String sfxPrefix, String sfxSuffix, String ... mains) {
        this.sfxChannels = sfxChannels;
        this.sfxPrefix = sfxPrefix == null ? "" : sfxPrefix;
        this.sfxSuffix = sfxSuffix == null ? "" : sfxSuffix;
        this.device = ALC11.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            throw new IllegalStateException("Failed to open the default OpenAL device!");
        }
        ALCCapabilities deviceCaps = ALC.createCapabilities((long)this.device);
        this.context = ALC11.alcCreateContext((long)this.device, (IntBuffer)null);
        if (this.context == 0L) {
            ALC11.alcCloseDevice((long)this.device);
            throw new IllegalStateException("Failed to create OpenAL context!");
        }
        ALC11.alcMakeContextCurrent((long)this.context);
        AL.createCapabilities((ALCCapabilities)deviceCaps);
        for (String s : mains) {
            this.channels.put(s, new SoundChannel(this, s));
        }
        this.loop = new Thread(){

            @Override
            public void run() {
                while (SoundSystem.this.running) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(SoundSystem.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    SoundSystem.this.update();
                }
            }
        };
        this.loop.setName("SimpLib SoundSystem Thread");
        this.loop.start();
    }

    public Set<String> getChannels() {
        return Collections.unmodifiableSet(this.channels.keySet());
    }

    public synchronized SoundChannel getChannel(String name) {
        return this.channels.get(name);
    }

    public synchronized SoundChannel makeChannel(String name) {
        if (this.channels.containsKey(name)) {
            throw new IllegalStateException("Channel " + name + " already exists!");
        }
        this.channels.put(name, new SoundChannel(this, name));
        return this.getChannel(name);
    }

    public synchronized void deleteChannel(String name) {
        if (this.channels.containsKey(name)) {
            this.channels.remove(name).destroy();
        }
    }

    public synchronized void playSFX(String sound) {
        this.playSFX(sound, 1.0f);
    }

    public synchronized void playSFX(String sound, float volume) {
        ++this.sfxChannel;
        if (this.sfxChannel > this.sfxChannels) {
            this.sfxChannel = 1;
        }
        int src = SoundStash.getSource("SFX source " + this.sfxChannel);
        AL10.alSourceStop((int)src);
        AL10.alSourcef((int)src, (int)4106, (float)(volume * this.masterVolume * this.sfxVolume));
        try {
            AL10.alSourceUnqueueBuffers((int)src);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AL10.alSourceQueueBuffers((int)src, (int)this.getSound(this.sfxPrefix + sound + this.sfxSuffix));
        AL10.alSourcePlay((int)src);
    }

    public int getSound(String filepath) {
        if (SoundStash.hasBuffer(filepath)) {
            return SoundStash.getBuffer(filepath);
        }
        return this.getSound_do(filepath);
    }

    private synchronized int getSound_do(String filepath) {
        int name = SoundStash.getBuffer(filepath);
        if (name == 0) {
            if (SoundStash.lastException != null && SoundStash.lastException instanceof UnsupportedAudioFileException) {
                name = this.tryDecodeSound(filepath);
            } else {
                Sys.error(ErrorLevel.moderate, SoundStash.lastError, SoundStash.lastException, ErrorCategory.audio);
            }
            SoundStash.lastError = null;
            SoundStash.lastException = null;
        }
        return name;
    }

    public synchronized Song getSong(String filepath) {
        if (this.songs.containsKey(filepath)) {
            return this.songs.get(filepath);
        }
        try {
            Song song = new Song(filepath, this);
            this.songs.put(filepath, song);
            return song;
        }
        catch (IOException | NullPointerException ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int tryDecodeSound(String filepath) {
        try (BufferedInputStream in = new BufferedInputStream(TexturePackManager.instance.currentTexturePack.getResourceAsStream(filepath));){
            for (AudioDecoder d : decoders) {
                DecodedAudioInputStream din = d.getInputStream(in);
                if (din == null) continue;
                int n = this.decodeSound(filepath, din);
                return n;
            }
        }
        catch (IOException | NullPointerException ex) {
            Sys.error(ErrorLevel.moderate, "Could not access required audio file!", ex, ErrorCategory.audio);
            return 0;
        }
        Sys.error(ErrorLevel.severe, "Unknown audio format in " + filepath + "!", null, ErrorCategory.audio);
        return 0;
    }

    private int decodeSound(String filepath, DecodedAudioInputStream in) throws IOException {
        return SoundStash.allocateNew(in, filepath, in.getChannelCount(), in.getSampleSize(), (float)in.getSampleRate());
    }

    public void destroy() {
        this.running = false;
        try {
            this.loop.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (Song s : this.songs.values()) {
            s.onDestroy();
        }
        SoundStash.clearSources();
        SoundStash.clearBuffers();
        if (this.context != 0L) {
            ALC11.alcDestroyContext((long)this.context);
        }
        if (this.device != 0L) {
            ALC11.alcCloseDevice((long)this.device);
        }
    }

    public boolean isAlive() {
        return this.running;
    }

    public static void addDecoder(AudioDecoder decoder) {
        decoders.add(decoder);
    }

    public synchronized void update() {
        for (SoundChannel c : this.channels.values()) {
            c.update();
        }
        for (Song s : this.songs.values()) {
            s.update();
        }
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public synchronized void setMasterVolume(float vol) {
        float last = this.masterVolume;
        this.masterVolume = vol;
        for (int i = 0; i < this.sfxChannels; ++i) {
            this.updateSFXVolume(i + 1, last, vol);
        }
        for (SoundChannel c : this.channels.values()) {
            c.updateMasterVolume();
        }
    }

    public float getSFXVolume() {
        return this.sfxVolume;
    }

    public synchronized void setSFXVolume(float vol) {
        float last;
        this.sfxVolume = last = this.sfxVolume;
        for (int i = 0; i < this.sfxChannels; ++i) {
            this.updateSFXVolume(i + 1, last, vol);
        }
    }

    private void updateSFXVolume(int channel, float prevMaster, float newMaster) {
        int src = SoundStash.getSource("SFX source " + channel);
        float vol = AL10.alGetSourcef((int)src, (int)4106);
        AL10.alSourcef((int)src, (int)4106, (float)(vol / prevMaster * newMaster));
    }

    private static boolean classExists(String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public void setDefaultAutoUnload(boolean def) {
        this.autoUnloadDefault = def;
    }

    boolean getAutoUnloadDefault() {
        return this.autoUnloadDefault;
    }

    static {
        if (SoundSystem.classExists("javazoom.jl.decoder.Decoder")) {
            SoundSystem.addDecoder(new JLayerAudioDecoder());
        }
    }
}

