/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.openal.decoding.mp3;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import simplelibrary.CircularStream;
import simplelibrary.openal.decoding.DecodedAudioInputStream;
import simplelibrary.openal.decoding.mp3.JLayerOBuffer;

public class JLayerInputStream
extends DecodedAudioInputStream {
    private Obuffer output;
    private Decoder decoder;
    private Bitstream stream;
    private CircularStream circle = new CircularStream(46080);
    private CircularStream.CircularStreamInput back = this.circle.getInput();
    private Thread readThread;
    private boolean readComplete;
    private int channelCount;
    private int sampleRate;

    public JLayerInputStream(BufferedInputStream in) throws IOException {
        this.decoder = new Decoder();
        this.stream = new Bitstream((InputStream)in);
        this.readNextFrame();
        if (this.output != null) {
            this.readThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (JLayerInputStream.this.readNextFrame()) {
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        JLayerInputStream.this.readComplete = true;
                    }
                }
            };
            this.readThread.setName("MP3 Decoder Thread");
            this.readThread.start();
        }
    }

    private boolean readNextFrame() throws IOException {
        try {
            Obuffer decoderOutput;
            Header header = this.stream.readFrame();
            if (header == null) {
                return false;
            }
            if (this.output == null) {
                int channels = header.mode() == 3 ? 1 : 2;
                int freq = header.frequency();
                this.output = new JLayerOBuffer(this, channels, freq);
                this.decoder.setOutputBuffer(this.output);
            }
            if ((decoderOutput = this.decoder.decodeFrame(header, this.stream)) != this.output) {
                throw new InternalError("Output buffers are different.");
            }
            this.stream.closeFrame();
            return true;
        }
        catch (BitstreamException ex) {
            return false;
        }
        catch (DecoderException ex) {
            return false;
        }
    }

    public boolean isValid() {
        return this.output != null;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    void setChannelCount(int count) {
        this.channelCount = count;
    }

    @Override
    public int getSampleSize() {
        return this.channelCount * 8;
    }

    void setFrequency(int freq) {
        this.sampleRate = freq;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        while (this.back.available() == 0 && !this.readComplete) {
            String string = "";
            // MONITORENTER : ""
            try {
                "".wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.back.available() != 0) return this.back.read();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean read = false;
        while (this.back.available() == 0 && !this.readComplete) {
            String string = "";
            // MONITORENTER : ""
            try {
                "".wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.back.available() != 0) return this.back.read(b, off, Math.min(len, this.back.available()));
        return -1;
    }

    void newData(byte[] buffer, short len) {
        this.circle.write(buffer, 0, len);
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
            this.back.close();
        }
        catch (BitstreamException ex) {
            throw new IOException(ex);
        }
    }
}

