/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import simplelibrary.Queue;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.texture.TexturePack;
import simplelibrary.texture.TexturePackManager;

public class ImageStash {
    public static final ImageStash instance = new ImageStash();
    private final HashMap<String, Integer> textureMap = new HashMap();
    private final ArrayList<Integer> textureNameList = new ArrayList();
    private final IntBuffer singleIntBuffer = ImageStash.createDirectIntBuffer(1);
    private final ByteBuffer imageData = ImageStash.createDirectByteBuffer(0x1000000);
    private final BufferedImage missingTextureImage;
    private final HashMap<String, BufferedImage> multithreadedInserts = new HashMap();
    private int boundImage;
    private final HashMap<String, Integer> bufferMap = new HashMap();
    private final ArrayList<Integer> buffers = new ArrayList();
    private final HashMap<Integer, Integer> bufferToTextureMap = new HashMap();
    private final Queue<Integer> buffersToDelete = new Queue();
    private int boundBuffer;
    private Thread myThread;

    public ImageStash() {
        this.missingTextureImage = new BufferedImage(256, 256, 2);
        Graphics g = this.missingTextureImage.getGraphics();
        String text = "Missing Texture!";
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        g.setColor(Color.BLACK);
        g.drawChars(chars, 0, chars.length, 75, 127);
        g.dispose();
        this.myThread = Thread.currentThread();
    }

    private static void generateTextureNames(IntBuffer intBuffer) {
        GL11.glGenTextures((IntBuffer)intBuffer);
    }

    public static ByteBuffer createDirectByteBuffer(int bufferSize) {
        return ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
    }

    public static IntBuffer createDirectIntBuffer(int bufferSize) {
        return ImageStash.createDirectByteBuffer(bufferSize << 2).asIntBuffer();
    }

    public int getTexture(String filename) {
        if (!this.buffersToDelete.isEmpty() && this.myThread == Thread.currentThread()) {
            this.deleteBuffer(this.buffersToDelete.dequeue());
        }
        if (filename == null || filename.isEmpty() || filename.equals("X")) {
            return -1;
        }
        TexturePack texture = TexturePackManager.instance.currentTexturePack;
        Integer textureName = this.textureMap.get(filename);
        if (textureName != null) {
            return textureName;
        }
        if (this.loadMultithreadedInsert(filename)) {
            return this.getTexture(filename);
        }
        try {
            int name;
            InputStream var7 = texture.getResourceAsStream(filename);
            if (var7 == null) {
                Sys.error(ErrorLevel.warning, "Could not find texture file " + filename + "!  Allocating default texture...", null, ErrorCategory.fileIO);
                name = this.allocateAndSetupTexture(this.missingTextureImage);
            } else {
                name = this.allocateAndSetupTexture(this.readTextureImage(var7));
            }
            this.textureMap.put(filename, name);
            return name;
        }
        catch (Exception ex) {
            Sys.error(ErrorLevel.warning, null, ex, ErrorCategory.fileIO);
            int name = this.allocateAndSetupTexture(this.missingTextureImage);
            this.textureMap.put(filename, name);
            return name;
        }
    }

    public int allocateAndSetupTexture(BufferedImage image) {
        this.singleIntBuffer.clear();
        ImageStash.generateTextureNames(this.singleIntBuffer);
        int name = this.singleIntBuffer.get(0);
        this.setupTexture(image, name);
        this.textureNameList.add(name);
        return name;
    }

    private void setupTexture(BufferedImage image, int name) {
        this.boundImage = name;
        GL11.glBindTexture((int)3553, (int)name);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        int width = image.getWidth();
        int height = image.getHeight();
        int[] imageRGBData = new int[width * height];
        byte[] imageData = new byte[width * height * 4];
        image.getRGB(0, 0, width, height, imageRGBData, 0, width);
        for (int i = 0; i < imageRGBData.length; ++i) {
            imageData[i * 4 + 0] = (byte)(imageRGBData[i] >> 16 & 0xFF);
            imageData[i * 4 + 1] = (byte)(imageRGBData[i] >> 8 & 0xFF);
            imageData[i * 4 + 2] = (byte)(imageRGBData[i] & 0xFF);
            imageData[i * 4 + 3] = (byte)(imageRGBData[i] >> 24 & 0xFF);
        }
        this.imageData.clear();
        this.imageData.put(imageData);
        this.imageData.position(0).limit(imageData.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.imageData);
    }

    public void deleteTexture(int textureName) {
        String[] keys;
        this.textureNameList.remove((Object)textureName);
        this.singleIntBuffer.clear();
        this.singleIntBuffer.put(textureName);
        this.singleIntBuffer.flip();
        GL11.glDeleteTextures((IntBuffer)this.singleIntBuffer);
        for (String key : keys = this.textureMap.keySet().toArray(new String[this.textureMap.size()])) {
            if (this.textureMap.get(key) != textureName) continue;
            this.textureMap.remove(key);
        }
    }

    private BufferedImage readTextureImage(InputStream input) throws IOException {
        BufferedImage image = ImageIO.read(input);
        input.close();
        return image;
    }

    public void bindTexture(int image) {
        if (image >= 0) {
            this.boundImage = image;
            GL11.glBindTexture((int)3553, (int)image);
        }
    }

    public int getBoundTexture() {
        return this.boundImage;
    }

    public void clearTextures() {
        Integer[] keys;
        Integer[] integerArray = keys = this.textureNameList.toArray(new Integer[this.textureNameList.size()]);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int key = integerArray[i];
            this.deleteTexture(key);
        }
    }

    public int multithreadedInsert(String filename) {
        if (filename == null || filename.isEmpty() || filename.equals("X")) {
            return -1;
        }
        TexturePack texture = TexturePackManager.instance.currentTexturePack;
        Integer textureName = this.textureMap.get(filename);
        if (textureName != null) {
            return textureName;
        }
        try {
            InputStream var7 = texture.getResourceAsStream(filename);
            if (var7 == null) {
                Sys.suppressedErrors.add(ErrorLevel.warning, "Could not find texture file " + filename + "!  Cancelling multithreaded insert...", null, ErrorCategory.fileIO);
                return -1;
            }
            this.multithreadedInsert(filename, this.readTextureImage(var7));
            return 0;
        }
        catch (Exception ex) {
            Sys.suppressedErrors.add(ErrorLevel.warning, null, ex, ErrorCategory.fileIO);
            return -1;
        }
    }

    public boolean loadMultithreadedInsert(String filename) {
        BufferedImage img = this.multithreadedInserts.remove(filename);
        if (img != null) {
            this.textureMap.put(filename, this.allocateAndSetupTexture(img));
            return true;
        }
        return false;
    }

    public void multithreadedInsert(String filename, BufferedImage image) {
        this.multithreadedInserts.put(filename, image);
    }

    public int getBuffer(String name) {
        if (!this.bufferMap.containsKey(name)) {
            int buff = GL30.glGenFramebuffers();
            this.bufferMap.put(name, buff);
            this.buffers.add(buff);
        }
        return this.bufferMap.get(name);
    }

    public int getTextureForBuffer(int name) {
        return this.bufferToTextureMap.getOrDefault(name, -1);
    }

    public boolean isBufferConfigured(int name) {
        return this.bufferToTextureMap.containsKey(name);
    }

    public void bindBuffer(int name) {
        if (name >= 0) {
            this.boundBuffer = name;
            GL30.glBindFramebuffer((int)36160, (int)name);
        }
    }

    public void configureBuffer(int name, int width, int height) {
        GL30.glBindFramebuffer((int)36160, (int)name);
        this.singleIntBuffer.clear();
        ImageStash.generateTextureNames(this.singleIntBuffer);
        int texName = this.singleIntBuffer.get(0);
        GL11.glBindTexture((int)3553, (int)texName);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)null);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texName, (int)0);
        this.bufferToTextureMap.put(name, texName);
        GL11.glBindTexture((int)3553, (int)this.boundImage);
        GL30.glBindFramebuffer((int)36160, (int)this.boundBuffer);
    }

    public boolean hasBuffer(String name) {
        return this.bufferMap.containsKey(name);
    }

    public boolean hasTexture(String path) {
        return this.textureMap.containsKey(path);
    }

    public void deleteBuffer(int bufferName) {
        String[] keys;
        if (this.myThread != Thread.currentThread()) {
            this.buffersToDelete.enqueue(bufferName);
            return;
        }
        if (this.bufferToTextureMap.containsKey(bufferName)) {
            this.deleteTexture(this.bufferToTextureMap.remove(bufferName));
        }
        GL30.glDeleteFramebuffers((int)bufferName);
        for (String key : keys = this.bufferMap.keySet().toArray(new String[this.bufferMap.size()])) {
            if (this.bufferMap.get(key) != bufferName) continue;
            this.bufferMap.remove(key);
        }
    }
}

