/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.opengl.model.Model;
import simplelibrary.opengl.model.loader.AdjacentFileProvider;
import simplelibrary.opengl.model.loader.ModelLoader;
import simplelibrary.opengl.model.loader.OBJLoader;
import simplelibrary.texture.TexturePack;
import simplelibrary.texture.TexturePackManager;

public class ModelStash {
    public static final ModelStash instance = new ModelStash();
    private final ArrayList<ModelLoader> loaders = new ArrayList();
    private Model missingModel = new Model();
    private final HashMap<String, Model> modelMap;

    public ModelStash() {
        this.loaders.add(new OBJLoader());
        this.modelMap = new HashMap();
    }

    private Model loadModel(Supplier<InputStream> streamSupplier, AdjacentFileProvider adjacentProvider) throws IOException {
        Iterator<ModelLoader> iterator = this.loaders.iterator();
        if (iterator.hasNext()) {
            ModelLoader loader = iterator.next();
            return loader.loadModel(streamSupplier.get(), adjacentProvider);
        }
        return null;
    }

    public Model getModel(final String filename) {
        if (filename == null) {
            return null;
        }
        TexturePack pack = TexturePackManager.instance.currentTexturePack;
        Model m = this.modelMap.get(filename);
        if (m != null) {
            return m;
        }
        try {
            Model model;
            InputStream stream = pack.getResourceAsStream(filename);
            if (stream == null) {
                Sys.error(ErrorLevel.warning, "Could not find model file " + filename + "! Allocating default model...", null, ErrorCategory.fileIO);
                model = this.missingModel;
            } else {
                model = this.loadModel(() -> pack.getResourceAsStream(filename), new AdjacentFileProvider(){

                    @Override
                    public InputStream getAdjacentFile(String name) {
                        return TexturePackManager.instance.currentTexturePack.getResourceAsStream(this.getAdjacentFilepath(name));
                    }

                    @Override
                    public String getAdjacentFilepath(String name) {
                        String[] strs = filename.replace("\\", "/").split("/");
                        return filename.substring(0, filename.length() - strs[strs.length - 1].length()) + name;
                    }
                });
            }
            this.modelMap.put(filename, model);
            return model;
        }
        catch (Exception ex) {
            Sys.error(ErrorLevel.warning, null, ex, ErrorCategory.fileIO);
            this.modelMap.put(filename, this.missingModel);
            return this.missingModel;
        }
    }
}

