/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl;

import org.lwjgl.opengl.GL11;
import simplelibrary.Stack;
import simplelibrary.font.FontManager;
import simplelibrary.opengl.ImageStash;

public abstract class Renderer2D {
    private static Stack<double[]> bound = new Stack();
    private static Stack<Stack<double[]>> bounds = new Stack();

    public static void translate(double x, double y) {
        double[] current = bound.peek();
        if (current == null) {
            return;
        }
        bound.push(new double[]{current[0] - x, current[1] - y, current[2] - x, current[3] - y});
    }

    public static void untranslate() {
        double[] last;
        if (bound.isEmpty()) {
            return;
        }
        double[] current = bound.pop();
        if (current[0] >= (last = bound.peek())[0] && current[1] >= last[1] && current[2] <= last[2] && current[3] <= last[3]) {
            bound.push(current);
        }
    }

    public static boolean isClickWithinBounds(double clickX, double clickY, double targetXMin, double targetYMin, double targetXMax, double targetYMax) {
        return clickX >= targetXMin && clickY >= targetYMin && clickX <= targetXMax && clickY <= targetYMax;
    }

    public static boolean drawText(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRect(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static boolean drawTextWithBounds(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRectWithBounds(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static String drawTextWithWrap(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRect(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static String drawTextWithWrapAndBounds(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRectWithBounds(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static String drawTextWithWordWrap(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        String[] words = text.split(" ");
        String str = words[0];
        double height = bottomEdge - topEdge;
        double length = rightPossibleEdge - leftEdge;
        for (int i = 1; i < words.length; ++i) {
            String string = str + " " + words[i];
            if (FontManager.getLengthForStringWithHeight(string.trim(), height) >= length) {
                Renderer2D.drawTextWithWrap(leftEdge, topEdge, rightPossibleEdge, bottomEdge, str.trim());
                return text.replaceFirst("\\Q" + str, "").trim();
            }
            str = string;
        }
        return Renderer2D.drawTextWithWrap(leftEdge, topEdge, rightPossibleEdge, bottomEdge, text);
    }

    public static String drawTextWithWordWrapAndBounds(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        String[] words = text.split(" ");
        String str = words[0];
        double height = bottomEdge - topEdge;
        double length = rightPossibleEdge - leftEdge;
        for (int i = 1; i < words.length; ++i) {
            String string = str + " " + words[i];
            if (FontManager.getLengthForStringWithHeight(string.trim(), height) >= length) {
                Renderer2D.drawTextWithWrapAndBounds(leftEdge, topEdge, rightPossibleEdge, bottomEdge, minX, minY, maxX, maxY, str.trim());
                return text.replaceFirst("\\Q" + str, "").trim();
            }
            str = string;
        }
        return Renderer2D.drawTextWithWrapAndBounds(leftEdge, topEdge, rightPossibleEdge, bottomEdge, minX, minY, maxX, maxY, text);
    }

    public static boolean drawCenteredText(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > Math.abs(rightPossibleEdge - leftPossibleEdge) && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRect(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static boolean drawCenteredTextWithBounds(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftPossibleEdge && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRectWithBounds(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static String drawCenteredTextWithWrap(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftPossibleEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRect(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static String drawCenteredTextWithWrapAndBounds(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftPossibleEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer2D.drawRectWithBounds(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static String drawCenteredTextWithWordWrap(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        String[] words = text.split(" ");
        String str = words[0];
        double height = bottomEdge - topEdge;
        double length = rightPossibleEdge - leftPossibleEdge;
        for (int i = 1; i < words.length; ++i) {
            String string = str + " " + words[i];
            if (FontManager.getLengthForStringWithHeight(string.trim(), height) >= length) {
                Renderer2D.drawCenteredTextWithWrap(leftPossibleEdge, topEdge, rightPossibleEdge, bottomEdge, str.trim());
                return text.replaceFirst("\\Q" + str, "").trim();
            }
            str = string;
        }
        return Renderer2D.drawCenteredTextWithWrap(leftPossibleEdge, topEdge, rightPossibleEdge, bottomEdge, text);
    }

    public static String drawCenteredTextWithWordWrapAndBounds(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        String[] words = text.split(" ");
        String str = words[0];
        double height = bottomEdge - topEdge;
        double length = rightPossibleEdge - leftPossibleEdge;
        for (int i = 1; i < words.length; ++i) {
            String string = str + " " + words[i];
            if (FontManager.getLengthForStringWithHeight(string.trim(), height) >= length) {
                Renderer2D.drawCenteredTextWithWrapAndBounds(leftPossibleEdge, topEdge, rightPossibleEdge, bottomEdge, minX, minY, maxX, maxY, str.trim());
                return text.replaceFirst("\\Q" + str, "").trim();
            }
            str = string;
        }
        return Renderer2D.drawCenteredTextWithWrapAndBounds(leftPossibleEdge, topEdge, rightPossibleEdge, bottomEdge, minX, minY, maxX, maxY, text);
    }

    public static void drawRect(double left, double top, double right, double bottom, int texture) {
        Renderer2D.drawRect(left, top, right, bottom, texture, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawRect(double left, double top, double right, double bottom, int texture, double[] texLocation) {
        Renderer2D.drawRect(left, top, right, bottom, texture, texLocation[0], texLocation[1], texLocation[2], texLocation[3]);
    }

    public static void drawRect(double left, double top, double right, double bottom, int texture, double texLeft, double texTop, double texRight, double texDown) {
        if (!bound.isEmpty()) {
            double[] bound = Renderer2D.bound.peek();
            if (bound == null) {
                return;
            }
            Renderer2D.drawRectWithBounds(left, top, right, bottom, bound[0], bound[1], bound[2], bound[3], texture, texLeft, texTop, texRight, texDown);
            return;
        }
        ImageStash.instance.bindTexture(texture);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)texLeft, (double)texTop);
        GL11.glVertex2d((double)left, (double)top);
        GL11.glTexCoord2d((double)texRight, (double)texTop);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glTexCoord2d((double)texRight, (double)texDown);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glTexCoord2d((double)texLeft, (double)texDown);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glEnd();
    }

    public static void drawRectWithBounds(double left, double top, double right, double bottom, double minX, double minY, double maxX, double maxY, int texture) {
        Renderer2D.drawRectWithBounds(left, top, right, bottom, minX, minY, maxX, maxY, texture, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawRectWithBounds(double left, double top, double right, double bottom, double minX, double minY, double maxX, double maxY, int texture, double[] texLocation) {
        Renderer2D.drawRectWithBounds(left, top, right, bottom, minX, minY, maxX, maxY, texture, texLocation[0], texLocation[1], texLocation[2], texLocation[3]);
    }

    public static void drawRectWithBounds(double left, double top, double right, double bottom, double minX, double minY, double maxX, double maxY, int texture, double texLeft, double texTop, double texRight, double texBottom) {
        double texBottom_;
        double texRight_;
        double texTop_;
        double diff;
        double texLeft_;
        if (right < minX && left < minX || right > maxX && left > maxX || top < minY && bottom < minY || bottom > maxY && top > maxY) {
            return;
        }
        double width = right - left;
        double height = bottom - top;
        if (width == 0.0 || height == 0.0) {
            return;
        }
        if (left >= minX) {
            texLeft_ = 0.0;
        } else {
            diff = minX - left;
            texLeft_ = diff / width;
            left = minX;
        }
        if (top >= minY) {
            texTop_ = 0.0;
        } else {
            diff = minY - top;
            texTop_ = diff / height;
            top = minY;
        }
        if (right <= maxX) {
            texRight_ = 1.0;
        } else {
            diff = right - maxX;
            texRight_ = 1.0 - diff / width;
            right = maxX;
        }
        if (bottom <= maxY) {
            texBottom_ = 1.0;
        } else {
            diff = bottom - maxY;
            texBottom_ = 1.0 - diff / height;
            bottom = maxY;
        }
        texLeft_ = texLeft + (texRight - texLeft) * texLeft_;
        texRight_ = texLeft + (texRight - texLeft) * texRight_;
        texTop_ = texTop + (texBottom - texTop) * texTop_;
        texBottom_ = texTop + (texBottom - texTop) * texBottom_;
        ImageStash.instance.bindTexture(texture);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)texLeft_, (double)texTop_);
        GL11.glVertex2d((double)left, (double)top);
        GL11.glTexCoord2d((double)texRight_, (double)texTop_);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glTexCoord2d((double)texRight_, (double)texBottom_);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glTexCoord2d((double)texLeft_, (double)texBottom_);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glEnd();
    }

    public static void drawBorder(double left, double top, double right, double bottom) {
        Renderer2D.drawLine(left, top, left, bottom);
        Renderer2D.drawLine(left, top, right, top);
        Renderer2D.drawLine(left, bottom, right, bottom);
        Renderer2D.drawLine(right, top, right, bottom);
    }

    public static void drawLine(double x1, double y1, double x2, double y2) {
        if (!bound.isEmpty()) {
            double[] bound = Renderer2D.bound.peek();
            if (bound == null) {
                return;
            }
            Renderer2D.drawLineWithBounds(x1, y1, x2, y2, bound[0], bound[1], bound[2], bound[3]);
            return;
        }
        ImageStash.instance.bindTexture(0);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
    }

    public static void drawLineWithBounds(double x1, double y1, double x2, double y2, double minX, double minY, double maxX, double maxY) {
        double f;
        if (minX > maxX || minY > maxY) {
            return;
        }
        if (x1 < minX && x2 < minX || x1 > maxX && x2 > maxX || y1 < minY && y2 < minY || y1 > maxY && y2 > maxY) {
            return;
        }
        if (x1 < minX) {
            f = (x2 - minX) / (x2 - x1);
            x1 = minX;
            y1 = y2 + f * (y1 - y2);
        }
        if (x2 < minX) {
            f = (x1 - minX) / (x1 - x2);
            x2 = minX;
            y2 = y1 + f * (y2 - y1);
        }
        if (x1 > maxX) {
            f = (maxX - x2) / (x1 - x2);
            x1 = maxX;
            y1 = y2 + f * (y1 - y2);
        }
        if (x2 > maxX) {
            f = (maxX - x1) / (x2 - x1);
            x2 = maxX;
            y2 = y1 + f * (y2 - y1);
        }
        if (x1 < minX && x2 < minX || x1 > maxX && x2 > maxX || y1 < minY && y2 < minY || y1 > maxY && y2 > maxY) {
            return;
        }
        if (y1 < minY) {
            f = (y2 - minY) / (y2 - y1);
            y1 = minY;
            x1 = x2 + f * (x1 - x2);
        }
        if (y2 < minY) {
            f = (y1 - minY) / (y1 - y2);
            y2 = minY;
            x2 = x1 + f * (x2 - x1);
        }
        if (y1 > maxY) {
            f = (maxY - y2) / (y1 - y2);
            y1 = maxY;
            x1 = x2 + f * (x1 - x2);
        }
        if (y2 > maxY) {
            f = (maxY - y1) / (y2 - y1);
            y2 = maxY;
            x2 = x1 + f * (x2 - x1);
        }
        if (x1 < minX && x2 < minX || x1 > maxX && x2 > maxX || y1 < minY && y2 < minY || y1 > maxY && y2 > maxY) {
            return;
        }
        ImageStash.instance.bindTexture(0);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
    }

    public static void applyRenderBound(double minX, double minY, double maxX, double maxY) {
        if (!Renderer2D.addRenderBound(minX, minY, maxX, maxY)) {
            bound.push(null);
        }
    }

    @Deprecated
    public static void cancelRenderBound() {
        Renderer2D.removeRenderBound();
    }

    public static boolean addRenderBound(double minX, double minY, double maxX, double maxY) {
        double[] current;
        if (!bound.isEmpty() && (current = bound.peek()) != null) {
            minX = Math.max(minX, current[0]);
            minY = Math.max(minY, current[1]);
            maxX = Math.min(maxX, current[2]);
            maxY = Math.min(maxY, current[3]);
        }
        return Renderer2D.addAbsoluteRenderBound(minX, minY, maxX, maxY);
    }

    public static void removeRenderBound() {
        bound.pop();
    }

    public static boolean addAbsoluteRenderBound(double minX, double minY, double maxX, double maxY) {
        if (maxX <= minX || maxY <= minY) {
            return false;
        }
        bound.push(new double[]{minX, minY, maxX, maxY});
        return true;
    }

    public static void bound(double minX, double minY, double maxX, double maxY, Runnable render) {
        if (!Renderer2D.addRenderBound(minX, minY, maxX, maxY)) {
            return;
        }
        render.run();
        Renderer2D.removeRenderBound();
    }

    public static void clearBoundStack() {
        bound.clear();
    }

    public static void pushBoundStack() {
        bounds.push(bound);
        bound = bound.copy();
    }

    public static void pushAndClearBoundStack() {
        bounds.push(bound);
        bound = new Stack();
    }

    public static void popBoundStack() {
        if (bounds.isEmpty()) {
            return;
        }
        bound = bounds.pop();
    }

    public static int getBoundStackDepth() {
        return bounds.size();
    }

    public static int getBoundDepth() {
        return bound.size();
    }
}

