/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl;

import org.lwjgl.opengl.GL11;
import simplelibrary.font.FontManager;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.model.Face;
import simplelibrary.opengl.model.Model;
import simplelibrary.opengl.model.Vector3f;

public class Renderer3D {
    public static boolean isPointWithinBounds(double pointX, double pointY, double targetXMin, double targetYMin, double targetXMax, double targetYMax) {
        return pointX >= targetXMin && pointY >= targetYMin && pointX <= targetXMax && pointY <= targetYMax;
    }

    public static boolean drawText(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRect(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static boolean drawTextWithBounds(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRectWithBounds(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static String drawTextWithWrap(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRect(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static String drawTextWithWrapAndBounds(double leftEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = 0.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRectWithBounds(leftEdge + skip, topEdge, leftEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static boolean drawCenteredText(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > Math.abs(rightPossibleEdge - leftPossibleEdge) && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRect(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static boolean drawCenteredTextWithBounds(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        boolean trimmed = false;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > Math.abs(rightPossibleEdge - leftPossibleEdge) && !text.isEmpty()) {
            trimmed = true;
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text + "...", bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (trimmed) {
            text = text + "...";
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRectWithBounds(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return true;
    }

    public static String drawCenteredTextWithWrap(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftPossibleEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRect(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static String drawCenteredTextWithWrapAndBounds(double leftPossibleEdge, double topEdge, double rightPossibleEdge, double bottomEdge, double minX, double minY, double maxX, double maxY, String text) {
        String originalText = text;
        double distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        while (distanceForText > rightPossibleEdge - leftPossibleEdge && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
            distanceForText = FontManager.getLengthForStringWithHeight(text, bottomEdge - topEdge);
        }
        if (text.isEmpty()) {
            return originalText;
        }
        double scale = FontManager.getLengthForStringWithHeight("M", bottomEdge - topEdge) / (double)FontManager.getCharLength('M');
        double skip = (Math.abs(rightPossibleEdge - leftPossibleEdge) - distanceForText) / 2.0;
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        for (char character : chars) {
            Renderer3D.drawRectWithBounds(leftPossibleEdge + skip, topEdge, leftPossibleEdge + skip + (double)FontManager.getCharLength(character) * scale, bottomEdge, minX, minY, maxX, maxY, FontManager.getFontImage(), FontManager.getTextureLocationForChar(character));
            skip += (double)FontManager.getCharLength(character) * scale;
        }
        return originalText.substring(text.length());
    }

    public static void drawRect(double left, double top, double right, double bottom, int texture) {
        Renderer3D.drawRect(left, top, right, bottom, texture, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawRect(double left, double top, double right, double bottom, int texture, double[] texLocation) {
        Renderer3D.drawRect(left, top, right, bottom, texture, texLocation[0], texLocation[1], texLocation[2], texLocation[3]);
    }

    public static void drawRect(double left, double top, double right, double bottom, int texture, double texLeft, double texTop, double texRight, double texDown) {
        bottom *= -1.0;
        ImageStash.instance.bindTexture(texture);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)texLeft, (double)texTop);
        GL11.glVertex2d((double)left, (double)(top *= -1.0));
        GL11.glTexCoord2d((double)texRight, (double)texTop);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glTexCoord2d((double)texRight, (double)texDown);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glTexCoord2d((double)texLeft, (double)texDown);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glEnd();
    }

    public static void drawRectWithBounds(double left, double top, double right, double bottom, double minX, double minY, double maxX, double maxY, int texture) {
        Renderer3D.drawRectWithBounds(left, top, right, bottom, minX, minY, maxX, maxY, texture, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawRectWithBounds(double left, double top, double right, double bottom, double minX, double minY, double maxX, double maxY, int texture, double[] texLocation) {
        Renderer3D.drawRectWithBounds(left, top, right, bottom, minX, minY, maxX, maxY, texture, texLocation[0], texLocation[1], texLocation[2], texLocation[3]);
    }

    public static void drawRectWithBounds(double left, double top, double right, double bottom, double minX, double minY, double maxX, double maxY, int texture, double texLeft, double texTop, double texRight, double texBottom) {
        double texBottom_;
        double texRight_;
        double texTop_;
        double diff;
        double texLeft_;
        if (right < minX && left < minX || right > maxX && left > maxX || top < minY && bottom < minY || bottom > maxY && top > maxY) {
            return;
        }
        double width = right - left;
        double height = bottom - top;
        if (width == 0.0 || height == 0.0) {
            return;
        }
        if (left >= minX) {
            texLeft_ = 0.0;
        } else {
            diff = minX - left;
            texLeft_ = diff / width;
            left = minX;
        }
        if (top >= minY) {
            texTop_ = 0.0;
        } else {
            diff = minY - top;
            texTop_ = diff / height;
            top = minY;
        }
        if (right <= maxX) {
            texRight_ = 1.0;
        } else {
            diff = right - maxX;
            texRight_ = 1.0 - diff / width;
            right = maxX;
        }
        if (bottom <= maxY) {
            texBottom_ = 1.0;
        } else {
            diff = bottom - maxY;
            texBottom_ = 1.0 - diff / height;
            bottom = maxY;
        }
        top *= -1.0;
        bottom *= -1.0;
        texLeft_ = texLeft + (texRight - texLeft) * texLeft_;
        texRight_ = texLeft + (texRight - texLeft) * texRight_;
        texTop_ = texTop + (texBottom - texTop) * texTop_;
        texBottom_ = texTop + (texBottom - texTop) * texBottom_;
        ImageStash.instance.bindTexture(texture);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)texLeft_, (double)texTop_);
        GL11.glVertex2d((double)left, (double)top);
        GL11.glTexCoord2d((double)texRight_, (double)texTop_);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glTexCoord2d((double)texRight_, (double)texBottom_);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glTexCoord2d((double)texLeft_, (double)texBottom_);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glEnd();
    }

    public static void drawModel(Model model) {
        Renderer3D.drawModel(model, 0.0, 0.0, 0.0);
    }

    public static void drawModel(Model model, double xRot, double yRot, double zRot) {
        if (model == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)model.origin.x, (double)model.origin.y, (double)model.origin.z);
        GL11.glRotated((double)yRot, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)xRot, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)zRot, (double)0.0, (double)0.0, (double)1.0);
        int oldTexture = -1;
        int oldPolygonSize = 0;
        for (Face face : model.faces) {
            int i;
            int texture = face.getTexture();
            int polygonSize = face.verticies.size();
            if (oldTexture != texture || oldPolygonSize != polygonSize) {
                if (oldTexture != -1 || oldPolygonSize != polygonSize) {
                    GL11.glEnd();
                }
                ImageStash.instance.bindTexture(texture);
                switch (polygonSize) {
                    case 4: {
                        GL11.glBegin((int)7);
                        break;
                    }
                    default: {
                        if (polygonSize < 3) {
                            throw new UnsupportedOperationException("Cannot draw face with " + polygonSize + " vertecies!");
                        }
                    }
                    case 3: {
                        GL11.glBegin((int)4);
                    }
                }
            }
            if (face.colorOverride != null) {
                GL11.glColor4d((double)((double)face.colorOverride.getRed() / 255.0), (double)((double)face.colorOverride.getGreen() / 255.0), (double)((double)face.colorOverride.getBlue() / 255.0), (double)1.0);
            }
            oldTexture = texture;
            oldPolygonSize = polygonSize;
            if (polygonSize > 4) {
                for (i = 0; i < face.verticies.size() - 2; ++i) {
                    Vector3f n;
                    float[] uv;
                    int vert1 = face.verticies.get(0);
                    int vert2 = face.verticies.get(i + 1);
                    int vert3 = face.verticies.get(i + 2);
                    if (face.textureCoords.size() > 0) {
                        float[] uv2 = model.textures.get(face.textureCoords.get(0) - 1);
                        GL11.glTexCoord2f((float)uv2[0], (float)(-uv2[1]));
                    }
                    if (face.normals.size() > 0) {
                        Vector3f n2 = model.normals.get(face.normals.get(0) - 1);
                        GL11.glNormal3f((float)n2.x, (float)n2.y, (float)n2.z);
                    }
                    Vector3f v = model.verticies.get(vert1 - 1);
                    GL11.glVertex3f((float)v.x, (float)v.y, (float)v.z);
                    if (face.textureCoords.size() > 0) {
                        uv = model.textures.get(face.textureCoords.get(i + 1) - 1);
                        GL11.glTexCoord2f((float)uv[0], (float)(-uv[1]));
                    }
                    if (face.normals.size() > 0) {
                        n = model.normals.get(face.normals.get(i + 1) - 1);
                        GL11.glNormal3f((float)n.x, (float)n.y, (float)n.z);
                    }
                    v = model.verticies.get(vert2 - 1);
                    GL11.glVertex3f((float)v.x, (float)v.y, (float)v.z);
                    if (face.textureCoords.size() > 0) {
                        uv = model.textures.get(face.textureCoords.get(i + 2) - 1);
                        GL11.glTexCoord2f((float)uv[0], (float)(-uv[1]));
                    }
                    if (face.normals.size() > 0) {
                        n = model.normals.get(face.normals.get(i + 2) - 1);
                        GL11.glNormal3f((float)n.x, (float)n.y, (float)n.z);
                    }
                    v = model.verticies.get(vert3 - 1);
                    GL11.glVertex3f((float)v.x, (float)v.y, (float)v.z);
                }
                continue;
            }
            for (i = 0; i < face.verticies.size(); ++i) {
                int vert = face.verticies.get(i);
                if (face.textureCoords.size() > 0) {
                    float[] uv = model.textures.get(face.textureCoords.get(i) - 1);
                    GL11.glTexCoord2f((float)uv[0], (float)(-uv[1]));
                }
                if (face.normals.size() > 0) {
                    Vector3f n = model.normals.get(face.normals.get(i) - 1);
                    GL11.glNormal3f((float)n.x, (float)n.y, (float)n.z);
                }
                Vector3f v = model.verticies.get(vert - 1);
                GL11.glVertex3f((float)v.x, (float)v.y, (float)v.z);
            }
        }
        GL11.glEnd();
        GL11.glRotated((double)(-yRot), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(-xRot), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(-zRot), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-model.origin.x), (double)(-model.origin.y), (double)(-model.origin.z));
        GL11.glPopMatrix();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }
}

