/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import simplelibrary.Queue;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.game.GameHelper;
import simplelibrary.opengl.gui.Menu;

public class GUI {
    public final GameHelper helper;
    public ArrayList<Integer> keyboardWereDown = new ArrayList();
    public Menu menu;
    public ArrayList<Integer> mouseWereDown = new ArrayList();
    public int tick;
    public int type;
    public double mouseX;
    public double mouseY;
    private Queue<PendingAction> pending = new Queue();

    public GUI(int type, GameHelper helper) {
        this.type = type;
        this.helper = helper;
    }

    public <V extends Menu> V open(Menu menu) {
        if (this.menu != null) {
            this.menu.onGUIClosed();
        }
        this.menu = menu;
        if (menu != null) {
            menu.onGUIOpened();
        }
        return (V)menu;
    }

    public synchronized void render(int millisSinceLastTick) {
        if (millisSinceLastTick < 0) {
            throw new IllegalArgumentException("The most recent tick can't be in the future!");
        }
        Exception theException = null;
        this.doActions();
        if (this.type == 3 || this.type == 4) {
            this.helper.make2D();
        }
        if (this.menu != null) {
            try {
                this.menu.render(millisSinceLastTick);
            }
            catch (Exception ex) {
                theException = ex;
            }
        }
        if (this.type == 3 || this.type == 4) {
            this.helper.make3D();
        }
        if (theException != null) {
            throw new RuntimeException(theException);
        }
    }

    public void onMouseMoved(double xpos, double ypos) {
        double x = xpos;
        double y = ypos;
        switch (this.type) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                x -= (double)((float)this.helper.displayWidth() / 2.0f);
                y -= (double)((float)this.helper.displayHeight() / 2.0f);
                break;
            }
            case 3: {
                x /= (double)((float)this.helper.displayHeight() / 2.0f);
                y /= (double)((float)this.helper.displayHeight() / 2.0f);
                x -= (double)((float)this.helper.displayWidth() / (float)this.helper.displayHeight());
                y -= 1.0;
            }
        }
        this.mouseX = x *= (double)this.helper.guiScale;
        this.mouseY = y *= (double)this.helper.guiScale;
        if (this.menu != null) {
            this.menu.onMouseMove(x, y);
        }
    }

    public void onMouseButton(int button, int action, int mods) {
        if (1 == action && !this.mouseWereDown.contains(button)) {
            this.mouseWereDown.add(button);
        } else if (action == 0 && this.mouseWereDown.contains(button)) {
            this.mouseWereDown.remove((Object)button);
        }
        if (this.menu != null) {
            this.menu.onMouseButton(button, action == 1, mods);
        }
    }

    public void onMouseScrolled(double xoffset, double yoffset) {
        if (this.menu != null) {
            this.menu.onMouseScrolled(xoffset, yoffset);
        }
    }

    public void onKeyEvent(int key, int scancode, int event, int modifiers) {
        if (event == 1 && !this.keyboardWereDown.contains(key)) {
            this.keyboardWereDown.add(key);
        } else if (event == 0 && this.keyboardWereDown.contains(key)) {
            this.keyboardWereDown.remove((Object)key);
        }
        if (this.menu != null) {
            this.menu.keyEvent(key, scancode, 1 == event, 2 == event, modifiers);
        }
    }

    public void onCharTyped(char c) {
        if (this.menu != null) {
            this.menu.onCharTyped(c);
        }
    }

    public synchronized void tick() {
        ++this.tick;
        if (this.menu != null) {
            try {
                this.menu.tick();
            }
            catch (Throwable throwable) {
                Sys.error(ErrorLevel.severe, "Could not tick GUI!", new RuntimeException(throwable), ErrorCategory.other);
            }
        }
    }

    public void addPendingAction(ActionListener l, ActionEvent e) {
        this.pending.enqueue(new PendingAction(l, e));
    }

    private void doActions() {
        while (!this.pending.isEmpty()) {
            this.pending.dequeue().perform();
        }
    }

    public void onWindowFocused(boolean focused) {
        if (this.menu != null) {
            this.menu.onWindowFocused(focused);
        }
    }

    public void onFileDropped(String[] files) {
        if (this.menu != null) {
            this.menu.onFilesDropped(files);
        }
    }

    private static class PendingAction {
        private final ActionListener l;
        private final ActionEvent e;

        private PendingAction(ActionListener l, ActionEvent e) {
            this.l = l;
            this.e = e;
        }

        private void perform() {
            this.l.actionPerformed(this.e);
        }
    }
}

