/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import simplelibrary.font.FontManager;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.Renderer2D;
import simplelibrary.opengl.gui.GUI;
import simplelibrary.opengl.gui.components.MenuComponent;
import simplelibrary.opengl.gui.components.MenuComponentButton;
import simplelibrary.opengl.gui.components.MenuComponentScrollable;

public abstract class Menu
extends Renderer2D {
    private static boolean hasBackgroundTexture;
    public Menu parent;
    public ArrayList<MenuComponent> components = new ArrayList();
    public MenuComponent selected;
    public GUI gui;
    private static final String menuBackground = "/gui/menuBackground.png";
    public int tooltipTime = 15;
    public int tooltipTimer = 0;
    public boolean tooltipShowing = false;
    private boolean mouseMoving = false;

    public Menu(GUI gui, Menu parent) {
        this.gui = gui;
        this.parent = parent;
    }

    public <V extends MenuComponent> V add(V component) {
        this.components.add(component);
        component.gui = this.gui;
        component.parent = this;
        component.onAdded();
        return component;
    }

    public void tick() {
        boolean hasMouseover;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            if (i >= this.components.size()) continue;
            this.components.get(i).tick();
        }
        if (this.tooltipShowing) {
            hasMouseover = false;
            for (MenuComponent c : this.getAllComponents()) {
                if (!c.isMouseOver || c.getTooltip() == null) continue;
                hasMouseover = true;
                break;
            }
            this.tooltipTimer = hasMouseover ? --this.tooltipTimer : ++this.tooltipTimer;
            if (this.tooltipTimer >= this.tooltipTime) {
                this.tooltipShowing = false;
                this.tooltipTimer = 0;
            }
        } else {
            if (!this.mouseMoving) {
                hasMouseover = false;
                for (MenuComponent c : this.getAllComponents()) {
                    if (!c.isMouseOver || c.getTooltip() == null) continue;
                    hasMouseover = true;
                    break;
                }
                this.tooltipTimer = hasMouseover ? ++this.tooltipTimer : --this.tooltipTimer;
            } else {
                --this.tooltipTimer;
            }
            if (this.tooltipTimer >= this.tooltipTime) {
                this.tooltipShowing = true;
                this.tooltipTimer = 0;
            }
        }
        this.tooltipTimer = Math.min(this.tooltipTime, Math.max(0, this.tooltipTimer));
        this.mouseMoving = false;
    }

    public void render(int millisSinceLastTick) {
        this.renderBackground();
        for (MenuComponent component : this.components) {
            component.render(millisSinceLastTick);
        }
        this.renderForeground();
    }

    public void renderBackground() {
        if (!hasBackgroundTexture) {
            return;
        }
        switch (this.gui.type) {
            case 1: 
            case 4: {
                Menu.drawRect(0.0, 0.0, this.gui.helper.displayWidth(), this.gui.helper.displayHeight(), ImageStash.instance.getTexture(menuBackground));
                break;
            }
            case 2: {
                Menu.drawRect(-this.gui.helper.displayWidth() / 2, -this.gui.helper.displayHeight() / 2, this.gui.helper.displayWidth() / 2, this.gui.helper.displayHeight() / 2, ImageStash.instance.getTexture(menuBackground));
                break;
            }
            case 3: {
                Menu.drawRect(-this.gui.helper.displayWidth() / this.gui.helper.displayHeight(), -1.0, this.gui.helper.displayWidth() / this.gui.helper.displayHeight(), 1.0, ImageStash.instance.getTexture(menuBackground));
                break;
            }
            default: {
                throw new AssertionError(this.gui.type);
            }
        }
    }

    public void renderForeground() {
        if (this.tooltipShowing) {
            for (MenuComponent c : this.getAllComponents()) {
                if (!c.isMouseOver || c.getTooltip() == null) continue;
                this.renderTooltip(c);
                break;
            }
        }
    }

    public void renderTooltip(MenuComponent component) {
        double textHeight = 20.0;
        double textSpacing = textHeight / 10.0;
        double borderSpacing = textHeight / 4.0;
        double borderWidth = textHeight / 10.0;
        String[] tooltips = component.getTooltip().split("\\\n");
        double textWidth = 0.0;
        for (String s : tooltips) {
            textWidth = Math.max(textWidth, FontManager.getLengthForStringWithHeight(s, textHeight));
        }
        double tooltipWidth = borderWidth + borderSpacing + textWidth + borderSpacing + borderWidth;
        double tooltipHeight = borderWidth + borderSpacing + textHeight * (double)tooltips.length + textSpacing * (double)(tooltips.length - 1) + borderSpacing + borderWidth;
        double tooltipX = component.x + component.getTooltipOffsetX();
        double tooltipY = component.y + component.getTooltipOffsetY();
        MenuComponent comp = component;
        while (comp.parent != null && comp.parent instanceof MenuComponent) {
            comp = (MenuComponent)comp.parent;
            if (comp instanceof MenuComponentScrollable) {
                tooltipX -= ((MenuComponentScrollable)comp).getHorizScroll();
                tooltipY -= ((MenuComponentScrollable)comp).getVertScroll();
            }
            tooltipX += comp.x;
            tooltipY += comp.y;
        }
        tooltipX = Math.min(tooltipX, (double)this.gui.helper.displayWidth() - tooltipWidth);
        tooltipY = Math.min(tooltipY, (double)this.gui.helper.displayHeight() - tooltipHeight);
        if (tooltipWidth > (double)this.gui.helper.displayWidth()) {
            tooltipX = 0.0;
        }
        if (tooltipHeight > (double)this.gui.helper.displayHeight()) {
            tooltipY = 0.0;
        }
        GL11.glColor3f((float)((float)component.tooltipBorderColor.getRed() / 255.0f), (float)((float)component.tooltipBorderColor.getGreen() / 255.0f), (float)((float)component.tooltipBorderColor.getBlue() / 255.0f));
        Menu.drawRect(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, 0);
        GL11.glColor3f((float)((float)component.tooltipBackgroundColor.getRed() / 255.0f), (float)((float)component.tooltipBackgroundColor.getGreen() / 255.0f), (float)((float)component.tooltipBackgroundColor.getBlue() / 255.0f));
        Menu.drawRect(tooltipX + borderWidth, tooltipY + borderWidth, tooltipX + tooltipWidth - borderWidth, tooltipY + tooltipHeight - borderWidth, 0);
        GL11.glColor3f((float)((float)component.tooltipTextColor.getRed() / 255.0f), (float)((float)component.tooltipTextColor.getGreen() / 255.0f), (float)((float)component.tooltipTextColor.getBlue() / 255.0f));
        for (int i = 0; i < tooltips.length; ++i) {
            String tt = tooltips[i];
            Menu.drawText(tooltipX + borderWidth + borderSpacing, tooltipY + borderWidth + borderSpacing + (textHeight + textSpacing) * (double)i, tooltipX + tooltipWidth, tooltipY + borderWidth + borderSpacing + (textHeight + textSpacing) * (double)i + textHeight, tt);
        }
    }

    public void buttonClicked(MenuComponentButton button) {
        throw new UnsupportedOperationException("Override missing- " + this.getClass().getName() + " has buttons but never handles events!");
    }

    public boolean onTabPressed(MenuComponent component) {
        return false;
    }

    public boolean onReturnPressed(MenuComponent component) {
        return false;
    }

    public void onGUIOpened() {
    }

    public void onGUIClosed() {
    }

    public void keyEvent(int key, int scancode, boolean isPress, boolean isRepeat, int modifiers) {
        if (this.selected != null) {
            this.selected.keyEvent(key, scancode, isPress, isRepeat, modifiers);
        }
    }

    public void onCharTyped(char c) {
        if (this.selected != null) {
            this.selected.onCharTyped(c);
        }
    }

    public void onMouseMove(double x, double y) {
        for (MenuComponent component : this.components) {
            if (Menu.isClickWithinBounds(x, y, component.x, component.y, component.x + component.width, component.y + component.height)) {
                component.onMouseMove(x - component.x, y - component.y);
                continue;
            }
            component.onMouseMovedElsewhere(x - component.x, y - component.y);
        }
        this.mouseMoving = true;
    }

    void onMouseButton(int button, boolean pressed, int mods) {
        this.onMouseButton(this.gui.mouseX, this.gui.mouseY, button, pressed, mods);
    }

    public void onMouseButton(double x, double y, int button, boolean pressed, int mods) {
        boolean clicked = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            if (i >= this.components.size()) continue;
            MenuComponent component = this.components.get(i);
            if (!Double.isNaN(x) && !clicked && Menu.isClickWithinBounds(x, y, component.x, component.y, component.x + component.width, component.y + component.height)) {
                if (this.selected != component && pressed && button == 0) {
                    if (this.selected != null) {
                        this.selected.onDeselected();
                    }
                    this.selected = component;
                    component.onSelected();
                }
                clicked = true;
                component.onMouseButton(x - component.x, y - component.y, button, pressed, mods);
                continue;
            }
            if (pressed) continue;
            component.onMouseButton(Double.NaN, Double.NaN, button, false, mods);
        }
    }

    void onMouseScrolled(double dx, double dy) {
        this.onMouseScrolled(this.gui.mouseX, this.gui.mouseY, dx, dy);
    }

    public boolean onMouseScrolled(double x, double y, double dx, double dy) {
        for (MenuComponent component : this.components) {
            if (!Menu.isClickWithinBounds(x, y, component.x, component.y, component.x + component.width, component.y + component.height) || !component.onMouseScrolled(x - component.x, y - component.y, dx, dy)) continue;
            return true;
        }
        return false;
    }

    public void onWindowFocused(boolean focused) {
    }

    void onFilesDropped(String[] files) {
        this.onFilesDropped(this.gui.mouseX, this.gui.mouseY, files);
    }

    public boolean onFilesDropped(double x, double y, String[] files) {
        for (MenuComponent component : this.components) {
            if (!Menu.isClickWithinBounds(x, y, component.x, component.y, component.x + component.width, component.y + component.height) || !component.onFilesDropped(x - component.x, y - component.y, files)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<MenuComponent> getAllComponents() {
        ArrayList<MenuComponent> comps = new ArrayList<MenuComponent>(this.components);
        for (MenuComponent c : this.components) {
            comps.addAll(c.getAllComponents());
        }
        return comps;
    }

    static {
        try (InputStream in = Menu.class.getResourceAsStream(menuBackground);){
            if (in != null) {
                hasBackgroundTexture = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

