/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.gui.Menu;
import simplelibrary.opengl.gui.components.MenuComponentButton;

public abstract class MenuComponent
extends Menu {
    public Color color = Color.WHITE;
    public Color foregroundColor = this.defaultForegroundColor();
    public double height;
    public boolean isMouseOver;
    public boolean isSelected;
    public Color selectedColor = Color.WHITE;
    public double width;
    public double x;
    public double y;
    public Color tooltipBackgroundColor = Color.WHITE;
    public Color tooltipTextColor = Color.black;
    public Color tooltipBorderColor = Color.black;
    public String tooltip;

    public MenuComponent(double x, double y, double width, double height) {
        super(null, null);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void draw() {
        if (!this.isSelected && this.color != Color.WHITE) {
            GL11.glColor3f((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f));
        } else if (this.isSelected && this.selectedColor != Color.WHITE) {
            GL11.glColor3f((float)((float)this.selectedColor.getRed() / 255.0f), (float)((float)this.selectedColor.getGreen() / 255.0f), (float)((float)this.selectedColor.getBlue() / 255.0f));
        }
        this.render();
        if (!this.isSelected && this.color != Color.WHITE || this.isSelected && this.selectedColor != Color.WHITE) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void onAdded() {
        this.gui = this.parent.gui;
        for (MenuComponent c : this.components) {
            c.onAdded();
        }
    }

    public abstract void render();

    public MenuComponent setSelectedColor(Color color) {
        this.selectedColor = color;
        return this;
    }

    public MenuComponent setColor(Color color) {
        this.color = color;
        return this;
    }

    public MenuComponent setForegroundColor(Color color) {
        this.foregroundColor = color;
        return this;
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setBounds(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void buttonClicked(MenuComponentButton button) {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Override missing- " + this.getClass().getName() + " has buttons but never handles events!");
        }
        this.parent.buttonClicked(button);
    }

    @Override
    public boolean onTabPressed(MenuComponent component) {
        return false;
    }

    @Override
    public boolean onReturnPressed(MenuComponent component) {
        return false;
    }

    @Override
    public void render(int millisSinceLastTick) {
        if (MenuComponent.addRenderBound(this.x, this.y, this.x + this.width, this.y + this.height)) {
            this.renderBackground();
            this.draw();
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.x, (double)this.y, (double)0.0);
            MenuComponent.translate(this.x, this.y);
            for (MenuComponent c : this.components) {
                c.render(millisSinceLastTick);
            }
            MenuComponent.removeRenderBound();
            MenuComponent.removeRenderBound();
            GL11.glPopMatrix();
            this.renderForeground();
        }
    }

    @Override
    public void renderBackground() {
    }

    @Override
    public void renderForeground() {
    }

    protected Color defaultForegroundColor() {
        return Color.WHITE;
    }

    @Override
    public void onMouseMove(double x, double y) {
        this.isMouseOver = true;
        for (MenuComponent c : this.components) {
            if (MenuComponent.isClickWithinBounds(x, y, c.x, c.y, c.x + c.width, c.y + c.height)) {
                c.onMouseMove(x - c.x, y - c.y);
                continue;
            }
            c.onMouseMovedElsewhere(x - c.x, y - c.y);
        }
    }

    public void onMouseMovedElsewhere(double x, double y) {
        this.isMouseOver = false;
        for (MenuComponent c : this.components) {
            c.onMouseMovedElsewhere(x - c.x, y - c.y);
        }
    }

    public void onDeselected() {
        this.isSelected = false;
    }

    public void onSelected() {
        this.isSelected = true;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public MenuComponent setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public double getTooltipOffsetX() {
        return 0.0;
    }

    public double getTooltipOffsetY() {
        return this.height;
    }
}

