/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.gui.components.MenuComponent;

public class MenuComponentButton
extends MenuComponent
implements ActionListener {
    public String label;
    public boolean enabled;
    public boolean isPressed;
    public double textInset = -1.0;
    public boolean useMouseover = true;
    public boolean actOnPress = DefaultActOnPress;
    public static boolean DefaultActOnPress = false;
    protected String textureRoot = "/gui/button";
    private final ArrayList<ActionListener> listeners = new ArrayList();

    public MenuComponentButton(double x, double y, double width, double height, String label, boolean enabled) {
        super(x, y, width, height);
        this.label = label;
        this.enabled = enabled;
    }

    public MenuComponentButton(double x, double y, double width, double height, String label, boolean enabled, boolean useMouseover) {
        this(x, y, width, height, label, enabled);
        this.useMouseover = useMouseover;
    }

    public MenuComponentButton(double x, double y, double width, double height, String label, boolean enabled, boolean useMouseover, String textureRoot) {
        this(x, y, width, height, label, enabled, useMouseover);
        this.textureRoot = textureRoot;
    }

    @Override
    public void onMouseButton(double x, double y, int button, boolean pressed, int mods) {
        if (pressed && this.enabled && button == 0) {
            this.isPressed = true;
            if (this.actOnPress) {
                this.action();
            }
        } else if (button == 0 && !pressed) {
            if (!this.actOnPress && this.isPressed && !Double.isNaN(x)) {
                this.action();
            }
            this.isPressed = false;
        }
        super.onMouseButton(x, y, button, pressed, mods);
    }

    @Override
    public void render() {
        int texture = -1;
        texture = this.enabled ? (this.isPressed ? ImageStash.instance.getTexture(this.textureRoot + "Pressed.png") : (this.isMouseOver ? ImageStash.instance.getTexture(this.textureRoot + (this.useMouseover ? "Mouseover" : "") + ".png") : ImageStash.instance.getTexture(this.textureRoot + ".png"))) : (this.isMouseOver ? ImageStash.instance.getTexture(this.textureRoot + "Disabled.png") : ImageStash.instance.getTexture(this.textureRoot + "Disabled.png"));
        if (this.textInset < 0.0) {
            switch (this.parent.gui.type) {
                case 1: 
                case 2: 
                case 4: {
                    this.textInset = 5.0;
                    break;
                }
                case 3: {
                    this.textInset = Math.min(this.width / 20.0, this.height / 20.0);
                }
            }
        }
        MenuComponentButton.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, texture);
        GL11.glColor3f((float)((float)this.foregroundColor.getRed() / 255.0f), (float)((float)this.foregroundColor.getGreen() / 255.0f), (float)((float)this.foregroundColor.getBlue() / 255.0f));
        MenuComponentButton.drawCenteredText(this.x + this.textInset, this.y + this.textInset, this.x + this.width - this.textInset, this.y + this.height - this.textInset, this.label);
        GL11.glColor3f((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f));
    }

    public void action() {
        if (this.listeners.isEmpty()) {
            this.parent.buttonClicked(this);
        } else {
            this.actionPerformed(new ActionEvent(this, this.parent.components.indexOf(this), this.label));
        }
    }

    public void addActionListener(ActionListener a) {
        this.listeners.add(a);
    }

    public void removeActionListener(ActionListener a) {
        this.listeners.remove(a);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ActionListener l : this.listeners) {
            this.gui.addPendingAction(l, e);
        }
    }

    @Override
    protected Color defaultForegroundColor() {
        return Color.BLACK;
    }
}

