/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import simplelibrary.opengl.gui.components.MenuComponent;
import simplelibrary.opengl.gui.components.MenuComponentScrollable;

public class MenuComponentMulticolumnList
extends MenuComponentScrollable {
    public double columnWidth;
    public double rowHeight;
    public int columnCount;

    public MenuComponentMulticolumnList(double x, double y, double width, double height, double columnWidth, double rowHeight) {
        this(x, y, width, height, columnWidth, rowHeight, width / 20.0);
    }

    public MenuComponentMulticolumnList(double x, double y, double width, double height, double columnWidth, double rowHeight, double scrollbarWidth) {
        this(x, y, width, height, columnWidth, rowHeight, scrollbarWidth, false);
    }

    public MenuComponentMulticolumnList(double x, double y, double width, double height, double columnWidth, double rowHeight, double scrollbarWidth, boolean alwaysShowScrollbar) {
        super(x, y, width, height, 0.0, scrollbarWidth, alwaysShowScrollbar, false);
        this.columnWidth = columnWidth;
        this.rowHeight = rowHeight;
        this.columnCount = Math.max(1, (int)((width - width % columnWidth) / columnWidth));
    }

    @Override
    public void renderBackground() {
        double width = this.width - (this.hasVertScrollbar() ? this.vertScrollbarWidth : 0.0);
        this.columnCount = Math.max(1, (int)((width - width % this.columnWidth) / this.columnWidth));
        int column = 0;
        double y = 0.0;
        for (MenuComponent c : this.components) {
            c.x = (double)column * this.columnWidth;
            c.y = y;
            c.width = this.columnWidth;
            c.height = this.rowHeight;
            if ((column = (column + 1) % this.columnCount) != 0) continue;
            y += this.rowHeight;
        }
        super.renderBackground();
    }

    public boolean scrollbarPresent() {
        return this.hasVertScrollbar();
    }

    public int getSelectedIndex() {
        return this.components.indexOf(this.selected);
    }

    public void setSelectedIndex(int index) {
        this.selected = index < 0 || index >= this.components.size() ? null : (MenuComponent)this.components.get(index);
    }
}

