/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.gui.components.MenuComponent;

public class MenuComponentOptionButton
extends MenuComponent {
    public final String label;
    public boolean enabled;
    public int startingIndex;
    public int currentIndex;
    public String[] options;
    private boolean isPressed;
    private boolean isRightPressed;
    public double textInset = -1.0;
    private boolean useMouseover = true;
    protected String textureRoot = "/gui/button";
    public boolean actOnPress = DefaultActOnPress;
    public static boolean DefaultActOnPress = false;

    public MenuComponentOptionButton(double x, double y, double width, double height, String label, boolean enabled, int startingOption, String ... options) {
        super(x, y, width, height);
        this.label = label;
        this.enabled = enabled;
        this.startingIndex = startingOption;
        this.currentIndex = startingOption;
        this.options = options;
    }

    public MenuComponentOptionButton(double x, double y, double width, double height, String label, boolean enabled, boolean useMouseover, int startingOption, String ... options) {
        this(x, y, width, height, label, enabled, startingOption, options);
        this.useMouseover = useMouseover;
    }

    public MenuComponentOptionButton(double x, double y, double width, double height, String label, boolean enabled, boolean useMouseover, String textureRoot, int startingOption, String ... options) {
        this(x, y, width, height, label, enabled, useMouseover, startingOption, options);
        this.textureRoot = textureRoot;
    }

    public boolean isChanged() {
        return this.currentIndex != this.startingIndex;
    }

    @Override
    public void onMouseButton(double x, double y, int button, boolean pressed, int mods) {
        if (pressed && this.enabled && button == 0) {
            this.isPressed = true;
            if (this.actOnPress) {
                this.action();
            }
        } else if (button == 0 && !pressed) {
            if (!this.actOnPress && this.isPressed && !Double.isNaN(x)) {
                this.action();
            }
            this.isPressed = false;
        }
        if (pressed && this.enabled && button == 1) {
            this.isRightPressed = true;
            if (this.actOnPress) {
                this.reverseAction();
            }
        } else if (button == 1 && !pressed) {
            if (!this.actOnPress && this.isRightPressed && !Double.isNaN(x)) {
                this.reverseAction();
            }
            this.isRightPressed = false;
        }
        super.onMouseButton(x, y, button, pressed, mods);
    }

    @Override
    public void render() {
        int texture = -1;
        texture = this.enabled ? (this.isPressed || this.isRightPressed ? ImageStash.instance.getTexture(this.textureRoot + "Pressed.png") : (this.isMouseOver ? ImageStash.instance.getTexture(this.textureRoot + (this.useMouseover ? "Mouseover" : "") + ".png") : ImageStash.instance.getTexture(this.textureRoot + ".png"))) : (this.isMouseOver ? ImageStash.instance.getTexture(this.textureRoot + "Disabled.png") : ImageStash.instance.getTexture(this.textureRoot + "Disabled.png"));
        if (this.textInset < 0.0) {
            switch (this.parent.gui.type) {
                case 1: 
                case 2: 
                case 4: {
                    this.textInset = 5.0;
                    break;
                }
                case 3: {
                    this.textInset = Math.min(this.width / 20.0, this.height / 20.0);
                }
            }
        }
        MenuComponentOptionButton.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, texture);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        MenuComponentOptionButton.drawCenteredText(this.x + this.textInset, this.y + this.textInset, this.x + this.width - this.textInset, this.y + this.height - this.textInset, this.label + ": " + this.options[this.currentIndex]);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void action() {
        ++this.currentIndex;
        if (this.currentIndex >= this.options.length) {
            this.currentIndex = 0;
        }
    }

    private void reverseAction() {
        if (this.currentIndex == 0) {
            this.currentIndex = this.options.length;
        }
        --this.currentIndex;
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public void setIndex(int newIndex) {
        this.currentIndex = newIndex;
        if (this.currentIndex >= this.options.length) {
            this.currentIndex = 0;
        }
        if (this.currentIndex < 0) {
            this.currentIndex = this.options.length - 1;
        }
    }

    public String getSelectedString() {
        return this.options[this.currentIndex];
    }
}

