/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.gui.components.MenuComponent;

public class MenuComponentScrollable
extends MenuComponent {
    public final double horizScrollbarHeight;
    public final double vertScrollbarWidth;
    public final boolean alwaysShowHorizScrollbar;
    public final boolean alwaysShowVertScrollbar;
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private double maxScrollX = 0.0;
    private double maxScrollY = 0.0;
    private double horizClickOff;
    private double vertClickOff;
    private boolean horizScrollbarPresent = true;
    private boolean vertScrollbarPresent = true;
    private boolean vertPressed;
    private boolean horizPressed;
    private boolean vertZooming;
    private boolean horizZooming;
    private boolean upPress;
    private boolean downPress;
    private boolean leftPress;
    private boolean rightPress;
    private double scrollMagnitude;
    private double horizWidth;
    private double vertHeight;
    private double vertCenter;
    private double horizCenter;
    private double myX;
    private double myY;
    private double scrollWheelMagnitude = 1.0;

    public MenuComponentScrollable(double x, double y, double width, double height, double horizScrollbarHeight, double vertScrollbarWidth) {
        this(x, y, width, height, horizScrollbarHeight, vertScrollbarWidth, true, true);
    }

    public MenuComponentScrollable(double x, double y, double width, double height, double horizScrollbarHeight, double vertScrollbarWidth, boolean alwaysShowVertScrollbar, boolean alwaysShowHorizScrollbar) {
        super(x, y, width, height);
        this.horizScrollbarHeight = horizScrollbarHeight;
        this.vertScrollbarWidth = vertScrollbarWidth;
        this.alwaysShowHorizScrollbar = alwaysShowHorizScrollbar;
        this.alwaysShowVertScrollbar = alwaysShowVertScrollbar;
        this.scrollMagnitude = Math.min(width, height) / 50.0;
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.x, (double)this.y, (double)0.0);
        this.drawScrollbars();
        GL11.glPopMatrix();
    }

    @Override
    public void draw() {
        double contentHeight = 0.0;
        double contentWidth = 0.0;
        for (MenuComponent c : this.components) {
            contentHeight = Math.max(contentHeight, c.height + c.y);
            contentWidth = Math.max(contentWidth, c.width + c.x);
        }
        this.maxScrollX = contentWidth - this.width;
        this.maxScrollY = contentHeight - this.height + (this.maxScrollX > 0.0 || this.alwaysShowHorizScrollbar ? this.horizScrollbarHeight : 0.0);
        this.maxScrollX = contentWidth - this.width + (this.maxScrollY > 0.0 || this.alwaysShowVertScrollbar ? this.vertScrollbarWidth : 0.0);
        this.horizScrollbarPresent = this.alwaysShowHorizScrollbar || this.maxScrollX > 0.0;
        this.vertScrollbarPresent = this.alwaysShowVertScrollbar || this.maxScrollY > 0.0;
        this.scrollX = Math.max(0.0, Math.min(this.maxScrollX, this.scrollX));
        this.scrollY = Math.max(0.0, Math.min(this.maxScrollY, this.scrollY));
        this.render();
    }

    @Override
    public void render(int millisSinceLastTick) {
        double horizHeight;
        this.renderBackground();
        this.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double vertWidth = this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0;
        double d = horizHeight = this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0;
        if (MenuComponentScrollable.addRenderBound(this.x, this.y, this.x + this.width - vertWidth, this.y + this.height - horizHeight)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.x - this.scrollX), (double)(this.y - this.scrollY), (double)0.0);
            MenuComponentScrollable.translate(this.x - this.scrollX, this.y - this.scrollY);
            for (MenuComponent c : this.components) {
                c.render(millisSinceLastTick);
            }
            MenuComponentScrollable.removeRenderBound();
            MenuComponentScrollable.removeRenderBound();
            GL11.glPopMatrix();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.vertZooming) {
            if (this.myY < this.vertCenter - this.vertHeight / 2.0 && this.myY > this.vertScrollbarWidth) {
                this.zoomUp();
            }
            if (this.myY > this.vertCenter + this.vertHeight / 2.0) {
                double d = this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0;
                if (this.myY < this.height - this.vertScrollbarWidth - d) {
                    this.zoomDown();
                }
            }
        }
        if (this.horizZooming) {
            if (this.myX < this.horizCenter - this.horizWidth / 2.0 && this.myX > this.horizScrollbarHeight) {
                this.zoomLeft();
            }
            if (this.myX > this.horizCenter + this.horizWidth / 2.0) {
                double d = this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0;
                if (this.myX < this.width - this.horizScrollbarHeight - d) {
                    this.zoomRight();
                }
            }
        }
    }

    @Override
    public boolean onTabPressed(MenuComponent component) {
        return this.parent.onTabPressed(component);
    }

    @Override
    public boolean onReturnPressed(MenuComponent component) {
        return this.parent.onReturnPressed(component);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onMouseButton(double x, double y, int button, boolean pressed, int mods) {
        if (button == 0 && !pressed) {
            this.horizZooming = false;
            this.horizPressed = false;
            this.vertZooming = false;
            this.vertPressed = false;
            this.rightPress = false;
            this.leftPress = false;
            this.downPress = false;
            this.upPress = false;
        } else if (button == 0 && pressed) {
            vertWidth = this.vertScrollbarPresent != false ? this.vertScrollbarWidth : 0.0;
            v0 = horizHeight = this.horizScrollbarPresent != false ? this.horizScrollbarHeight : 0.0;
            if (this.horizScrollbarPresent && y >= this.height - this.horizScrollbarHeight) {
                if (MenuComponentScrollable.isClickWithinBounds(x, y, 0.0, this.height - horizHeight, horizHeight, this.height)) {
                    this.scrollLeft();
                } else if (MenuComponentScrollable.isClickWithinBounds(x, y, this.width - vertWidth - horizHeight, this.height - horizHeight, this.width - vertWidth, this.height)) {
                    this.scrollRight();
                } else if (x < this.horizCenter - this.horizWidth / 2.0) {
                    this.horizZooming = true;
                } else if (x > this.horizCenter + this.horizWidth / 2.0) {
                    this.horizZooming = true;
                } else {
                    this.horizClickOff = this.horizCenter - x;
                    this.horizPressed = true;
                }
            } else if (this.vertScrollbarPresent && x >= this.width - this.vertScrollbarWidth) {
                if (MenuComponentScrollable.isClickWithinBounds(x, y, this.width - vertWidth, 0.0, this.width, vertWidth)) {
                    this.scrollUp();
                } else if (MenuComponentScrollable.isClickWithinBounds(x, y, this.width - vertWidth, this.height - vertWidth - horizHeight, this.width, this.height - horizHeight)) {
                    this.scrollDown();
                } else if (y < this.vertCenter - this.vertHeight / 2.0) {
                    this.vertZooming = true;
                } else if (y > this.vertCenter + this.vertHeight / 2.0) {
                    this.vertZooming = true;
                } else {
                    this.vertClickOff = this.vertCenter - y;
                    this.vertPressed = true;
                }
            }
        }
        this.myX = x;
        this.myY = y;
        if (x > this.width - (this.vertScrollbarPresent != false ? this.vertScrollbarWidth : 0.0)) ** GOTO lbl-1000
        v1 = this.horizScrollbarPresent != false ? this.horizScrollbarHeight : 0.0;
        if (y > this.height - v1) lbl-1000:
        // 2 sources

        {
            y = NaN;
            x = NaN;
        } else {
            x += this.scrollX;
            y += this.scrollY;
        }
        super.onMouseButton(x, y, button, pressed, mods);
    }

    @Override
    public void onMouseMove(double x, double y) {
        if (x < this.width - this.vertScrollbarWidth) {
            this.vertZooming = false;
        }
        if (y < this.height - this.horizScrollbarHeight) {
            this.horizZooming = false;
        }
        if (this.vertPressed) {
            this.scrollVert(y - (this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0) + this.vertClickOff);
        }
        if (this.horizPressed) {
            this.scrollHoriz(x - (this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0) + this.horizClickOff);
        }
        boolean elsewhere = false;
        if (this.vertScrollbarPresent && x >= this.width - this.vertScrollbarWidth) {
            elsewhere = true;
        }
        if (this.horizScrollbarPresent && y >= this.height - this.horizScrollbarHeight) {
            elsewhere = true;
        }
        this.myX = x;
        this.myY = y;
        if (!(this.horizPressed || this.horizZooming || this.vertPressed || this.vertZooming)) {
            x += this.scrollX;
            y += this.scrollY;
            if (elsewhere) {
                super.onMouseMovedElsewhere(x, y);
            } else {
                super.onMouseMove(x, y);
            }
        }
    }

    @Override
    public void onMouseMovedElsewhere(double x, double y) {
        if (x < this.width - this.vertScrollbarWidth) {
            this.vertZooming = false;
        }
        if (y < this.height - this.horizScrollbarHeight) {
            this.horizZooming = false;
        }
        if (this.vertPressed) {
            this.scrollVert(y - (this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0) + this.vertClickOff);
        }
        if (this.horizPressed) {
            this.scrollHoriz(x - (this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0) + this.horizClickOff);
        }
        this.myX = x;
        this.myY = y;
        if (!(this.horizPressed || this.horizZooming || this.vertPressed || this.vertZooming)) {
            super.onMouseMovedElsewhere(x += this.scrollX, y += this.scrollY);
        }
    }

    @Override
    public boolean onMouseScrolled(double x, double y, double dx, double dy) {
        if (super.onMouseScrolled(x + this.scrollX, y + this.scrollY, dx, dy)) {
            return true;
        }
        boolean scrolled = false;
        if (dx > 0.0 && this.scrollX > 0.0) {
            this.scrollX = Math.max(0.0, this.scrollX - dx * this.scrollWheelMagnitude);
            scrolled = true;
        }
        if (dy > 0.0 && this.scrollY > 0.0) {
            this.scrollY = Math.max(0.0, this.scrollY - dy * this.scrollWheelMagnitude);
            scrolled = true;
        }
        if (dx < 0.0 && this.scrollX < this.maxScrollX) {
            this.scrollX = Math.min(this.maxScrollX, this.scrollX - dx * this.scrollWheelMagnitude);
            scrolled = true;
        }
        if (dy < 0.0 && this.scrollY < this.maxScrollY) {
            this.scrollY = Math.min(this.maxScrollY, this.scrollY - dy * this.scrollWheelMagnitude);
            scrolled = true;
        }
        return scrolled;
    }

    private void drawScrollbars() {
        double barShift;
        double barSpace;
        if (this.vertScrollbarPresent) {
            double spaceHeight;
            double barTop = 0.0;
            double barBottom = spaceHeight = this.height - (this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0);
            double barLeft = this.width - this.vertScrollbarWidth;
            this.drawVerticalScrollbarBackground(barLeft, 0.0, this.vertScrollbarWidth, barBottom);
            this.drawUpwardScrollbarButton(barLeft, barTop, this.vertScrollbarWidth, this.vertScrollbarWidth);
            this.drawDownwardScrollbarButton(barLeft, barBottom - this.vertScrollbarWidth, this.vertScrollbarWidth, this.vertScrollbarWidth);
            double percentY = this.maxScrollY <= 1.0 ? 0.99 : spaceHeight / (this.maxScrollY + spaceHeight);
            barSpace = (barBottom -= this.vertScrollbarWidth) - (barTop += this.vertScrollbarWidth);
            double barHeight = percentY * barSpace;
            barShift = barSpace - barHeight;
            percentY = this.scrollY / (this.maxScrollY > 0.0 ? this.maxScrollY : 1.0);
            double posY = percentY * barShift;
            this.vertHeight = barHeight;
            this.vertCenter = barTop + posY + barHeight / 2.0;
            this.drawVerticalScrollbarForeground(barLeft, barTop + posY, this.vertScrollbarWidth, barHeight);
        }
        if (this.horizScrollbarPresent) {
            double spaceWidth;
            double barLeft = 0.0;
            double barRight = spaceWidth = this.width - (this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0);
            double barTop = this.height - this.horizScrollbarHeight;
            this.drawHorizontalScrollbarBackground(0.0, barTop, barRight, this.horizScrollbarHeight);
            this.drawLeftwardScrollbarButton(barLeft, barTop, this.horizScrollbarHeight, this.horizScrollbarHeight);
            this.drawRightwardScrollbarButton(barRight - this.horizScrollbarHeight, barTop, this.horizScrollbarHeight, this.horizScrollbarHeight);
            double percentX = this.maxScrollX <= 1.0 ? 0.99 : spaceWidth / (this.maxScrollX + spaceWidth);
            barSpace = (barRight -= this.horizScrollbarHeight) - (barLeft += this.horizScrollbarHeight);
            double barWidth = percentX * barSpace;
            barShift = barSpace - barWidth;
            percentX = this.scrollX / (this.maxScrollX > 0.0 ? this.maxScrollX : 1.0);
            double posX = percentX * barShift;
            this.horizWidth = barWidth;
            this.horizCenter = barLeft + posX + barWidth / 2.0;
            this.drawHorizontalScrollbarForeground(barLeft + posX, barTop, barWidth, this.horizScrollbarHeight);
        }
    }

    public void drawUpwardScrollbarButton(double x, double y, double width, double height) {
        this.drawButton(x, y, width, height);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(x + width / 2.0), (double)(y + height / 4.0));
        GL11.glVertex2d((double)(x + width / 4.0), (double)(y + 3.0 * height / 4.0));
        GL11.glVertex2d((double)(x + 3.0 * width / 4.0), (double)(y + 3.0 * height / 4.0));
        GL11.glEnd();
    }

    public void drawDownwardScrollbarButton(double x, double y, double width, double height) {
        this.drawButton(x, y, width, height);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(x + width / 4.0), (double)(y + height / 4.0));
        GL11.glVertex2d((double)(x + 3.0 * width / 4.0), (double)(y + height / 4.0));
        GL11.glVertex2d((double)(x + width / 2.0), (double)(y + 3.0 * height / 4.0));
        GL11.glEnd();
    }

    public void drawRightwardScrollbarButton(double x, double y, double width, double height) {
        this.drawButton(x, y, width, height);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(x + width / 4.0), (double)(y + height / 4.0));
        GL11.glVertex2d((double)(x + width / 4.0), (double)(y + 3.0 * height / 4.0));
        GL11.glVertex2d((double)(x + 3.0 * width / 4.0), (double)(y + height / 2.0));
        GL11.glEnd();
    }

    public void drawLeftwardScrollbarButton(double x, double y, double width, double height) {
        this.drawButton(x, y, width, height);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)(x + width / 4.0), (double)(y + height / 2.0));
        GL11.glVertex2d((double)(x + 3.0 * width / 4.0), (double)(y + height / 4.0));
        GL11.glVertex2d((double)(x + 3.0 * width / 4.0), (double)(y + 3.0 * height / 4.0));
        GL11.glEnd();
    }

    public void drawVerticalScrollbarBackground(double x, double y, double width, double height) {
        GL11.glColor3f((float)0.7f, (float)0.7f, (float)0.7f);
        MenuComponentScrollable.drawRect(x, y, x + width, y + height, 0);
    }

    public void drawVerticalScrollbarForeground(double x, double y, double width, double height) {
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        MenuComponentScrollable.drawRect(x, y, x + width, y + height, 0);
    }

    public void drawHorizontalScrollbarBackground(double x, double y, double width, double height) {
        GL11.glColor3f((float)0.7f, (float)0.7f, (float)0.7f);
        MenuComponentScrollable.drawRect(x, y, x + width, y + height, 0);
    }

    public void drawHorizontalScrollbarForeground(double x, double y, double width, double height) {
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        MenuComponentScrollable.drawRect(x, y, x + width, y + height, 0);
    }

    public void drawButton(double x, double y, double width, double height) {
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        MenuComponentScrollable.drawRect(x, y, x + width, y + height, 0);
        GL11.glColor3f((float)0.2f, (float)0.2f, (float)0.2f);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)(y + height - 1.0));
        GL11.glVertex2d((double)x, (double)(y + height - 1.0));
        GL11.glVertex2d((double)(x + width - 1.0), (double)(y + height - 1.0));
        GL11.glVertex2d((double)(x + width - 1.0), (double)(y + height - 1.0));
        GL11.glVertex2d((double)(x + width - 1.0), (double)y);
        GL11.glVertex2d((double)(x + width - 1.0), (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public void scrollUp() {
        this.scrollY = Math.max(0.0, this.scrollY - this.scrollMagnitude);
    }

    public void scrollDown() {
        this.scrollY = Math.min(this.maxScrollY, this.scrollY + this.scrollMagnitude);
    }

    public void scrollLeft() {
        this.scrollX = Math.max(0.0, this.scrollX - this.scrollMagnitude);
    }

    public void scrollRight() {
        this.scrollX = Math.min(this.maxScrollX, this.scrollX + this.scrollMagnitude);
    }

    public void scrollVert(double y) {
        if (this.maxScrollY < 1.0) {
            return;
        }
        double spaceHeight = this.height - (this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0);
        double percentY = this.maxScrollY <= 1.0 ? 2.0 : spaceHeight / (this.maxScrollY + spaceHeight);
        double barHeight = percentY * (spaceHeight - this.vertScrollbarWidth * 2.0);
        y -= barHeight / 2.0;
        double maxEffective = Math.round(spaceHeight - this.vertScrollbarWidth * 2.0 - barHeight);
        if (maxEffective <= 0.0) {
            return;
        }
        this.scrollY = y < 0.0 ? 0.0 : (y > maxEffective ? this.maxScrollY : (double)Math.round(y / maxEffective * this.maxScrollY));
    }

    public void scrollHoriz(double x) {
        if (this.maxScrollX < 1.0) {
            return;
        }
        double spaceWidth = this.width - (this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0);
        double percentX = this.maxScrollX < 1.0 ? 2.0 : spaceWidth / (this.maxScrollX + spaceWidth);
        double barWidth = percentX * (spaceWidth - this.horizScrollbarHeight * 2.0);
        x -= barWidth / 2.0;
        double maxEffective = Math.round(spaceWidth - this.horizScrollbarHeight * 2.0 - barWidth);
        if (maxEffective <= 0.0) {
            return;
        }
        this.scrollX = x < 0.0 ? 0.0 : (x > maxEffective ? this.maxScrollX : (double)Math.round(x / maxEffective * this.maxScrollX));
    }

    public void setScrollMagnitude(double scrollMagnitude) {
        this.scrollMagnitude = scrollMagnitude;
    }

    public void setScrollWheelMagnitude(double scrollMagnitude) {
        this.scrollWheelMagnitude = scrollMagnitude;
    }

    public boolean hasVertScrollbar() {
        return this.vertScrollbarPresent && this.vertScrollbarWidth > 0.0;
    }

    public boolean hasHorizScrollbar() {
        return this.horizScrollbarPresent && this.horizScrollbarHeight > 0.0;
    }

    public double getVertScroll() {
        return this.scrollY;
    }

    public double getHorizScroll() {
        return this.scrollX;
    }

    private void zoomUp() {
        this.scrollY = Math.max(0.0, this.scrollY - (this.height - (this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0)) / 2.0);
    }

    private void zoomDown() {
        this.scrollY = Math.min(this.maxScrollY, this.scrollY + (this.height - (this.horizScrollbarPresent ? this.horizScrollbarHeight : 0.0)) / 2.0);
    }

    private void zoomLeft() {
        this.scrollX = Math.min(0.0, this.scrollX - (this.width - (this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0)) / 2.0);
    }

    private void zoomRight() {
        this.scrollX = Math.max(this.maxScrollX, this.scrollX + (this.width - (this.vertScrollbarPresent ? this.vertScrollbarWidth : 0.0)) / 2.0);
    }
}

