/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.gui.components.MenuComponent;

public class MenuComponentSlider
extends MenuComponent {
    public boolean enabled;
    public double textInset = -1.0;
    public double minimum;
    public double maximum;
    public double value;
    public final int digits;
    public boolean isPressed;
    public double sliderHeight;
    public double maxSliderX;
    public double sliderX;

    public MenuComponentSlider(double x, double y, double width, double height, int minimum, int maximum, int initial, boolean enabled) {
        super(x, y, width, height);
        this.minimum = minimum;
        this.maximum = maximum;
        this.value = initial;
        this.digits = 0;
        this.enabled = enabled;
        this.updateSlider();
    }

    public MenuComponentSlider(double x, double y, double width, double height, double minimum, double maximum, double initial, int digits, boolean enabled) {
        super(x, y, width, height);
        this.minimum = minimum;
        this.maximum = maximum;
        this.value = initial;
        this.digits = digits;
        this.enabled = enabled;
        this.updateSlider();
    }

    @Override
    public void onMouseButton(double x, double y, int button, boolean pressed, int mods) {
        if (button == 0 && pressed && this.enabled) {
            this.isPressed = true;
            this.updateSlider(x);
        } else if (button == 0 && !pressed) {
            this.isPressed = false;
        }
    }

    @Override
    public void onMouseMove(double x, double y) {
        if (this.isPressed) {
            this.updateSlider(x);
        }
    }

    @Override
    public void onMouseMovedElsewhere(double x, double y) {
        if (this.isPressed) {
            this.updateSlider(x);
        }
    }

    @Override
    public void render() {
        int texture = -1;
        texture = this.enabled ? (this.isPressed ? ImageStash.instance.getTexture("/gui/sliderPressed.png") : (this.isMouseOver ? ImageStash.instance.getTexture("/gui/slider.png") : ImageStash.instance.getTexture("/gui/slider.png"))) : (this.isMouseOver ? ImageStash.instance.getTexture("/gui/sliderDisabled.png") : ImageStash.instance.getTexture("/gui/sliderDisabled.png"));
        if (this.textInset < 0.0) {
            switch (this.parent.gui.type) {
                case 1: 
                case 2: 
                case 4: {
                    this.textInset = 5.0;
                    break;
                }
                case 3: {
                    this.textInset = Math.min(this.width / 20.0, this.height / 20.0);
                }
            }
        }
        MenuComponentSlider.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, ImageStash.instance.getTexture("/gui/sliderBackground.png"));
        MenuComponentSlider.drawRect(this.x + this.sliderX, this.y, this.x + this.sliderX + this.sliderHeight, this.y + this.sliderHeight, texture);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        MenuComponentSlider.drawCenteredText(this.x + this.textInset, this.y + this.sliderHeight + this.textInset, this.x + this.width - this.textInset, this.y + this.height - this.textInset, this.getValueS());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void updateSlider(double x) {
        double percent = (x -= this.sliderHeight / 2.0) / this.maxSliderX;
        if (percent > 1.0) {
            percent = 1.0;
        } else if (percent < 0.0) {
            percent = 0.0;
        }
        this.value = percent * (this.maximum - this.minimum) + this.minimum;
        this.updateSlider();
    }

    private void updateSlider() {
        this.sliderHeight = this.height / 2.0;
        this.maxSliderX = this.width - this.sliderHeight;
        this.sliderX = 0.0;
        double percent = (this.value - this.minimum) / (this.maximum - this.minimum);
        this.sliderX = this.maxSliderX * percent;
    }

    public String getValueS() {
        if ((double)Math.round(this.getValue()) == this.getValue()) {
            return "" + Math.round(this.getValue());
        }
        return "" + this.getValue();
    }

    public double getValue() {
        if (this.digits == 0) {
            return Math.round(this.value);
        }
        return (double)Math.round(this.value * (double)this.digits) / (double)this.digits;
    }

    public void setValue(double value) {
        this.value = Math.min(this.maximum, Math.max(this.minimum, value));
    }
}

