/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import java.util.ArrayList;
import java.util.Arrays;
import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.gui.components.MenuComponent;

public class MenuComponentTextArea
extends MenuComponent {
    public ArrayList<String> text;
    protected double textHeight;
    public boolean editable;
    public double textInset = -1.0;

    public MenuComponentTextArea(double x, double y, double width, double height, double textHeight, String[] display, boolean editable) {
        super(x, y, width, height);
        this.text = new ArrayList<String>(Arrays.asList(display));
        this.textHeight = textHeight;
    }

    @Override
    public void render() {
        int line = 0;
        if (this.textInset < 0.0) {
            switch (this.parent.gui.type) {
                case 1: 
                case 2: 
                case 4: {
                    this.textInset = 5.0;
                    break;
                }
                case 3: {
                    this.textInset = this.textHeight / 18.0;
                }
            }
        }
        for (String str : this.text) {
            do {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                str = MenuComponentTextArea.drawTextWithWrapAndBounds(this.x + this.textInset, this.y + this.textInset + (double)line * this.textHeight, this.x + this.width - this.textInset, this.y + this.textInset + (double)line * this.textHeight + this.textHeight, this.x + this.textInset, this.y + this.textInset, this.x + this.width - this.textInset, this.y + this.height - this.textInset, str);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ++line;
            } while (str != null && !str.isEmpty());
        }
        double bufferHeight = (double)line * this.textHeight;
    }

    @Override
    public void keyEvent(int key, int scancode, boolean isPress, boolean isRepeat, int modifiers) {
        if (!isPress && !isRepeat || !this.editable) {
            return;
        }
        switch (key) {
            case 258: {
                this.parent.onTabPressed(this);
                break;
            }
            case 257: {
                this.text.add("");
            }
            case 259: {
                String txt = this.text.get(this.text.size() - 1);
                if (!txt.isEmpty()) {
                    this.text.set(this.text.size() - 1, txt.substring(0, txt.length() - 1));
                    break;
                }
                if (this.text.size() <= 1) break;
                this.text.remove(this.text.size() - 1);
            }
        }
    }

    @Override
    public void onCharTyped(char c) {
        if (this.editable) {
            this.text.set(this.text.size() - 1, this.text.get(this.text.size() - 1) + c);
        }
    }
}

