/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.gui.components;

import org.lwjgl.opengl.GL11;
import simplelibrary.opengl.ImageStash;
import simplelibrary.opengl.gui.components.MenuComponent;

public class MenuComponentTextBox
extends MenuComponent {
    public boolean editable;
    public String text;
    public double textInset = -1.0;

    public MenuComponentTextBox(double x, double y, double width, double height, String text, boolean editable) {
        super(x, y, width, height);
        this.text = text;
        this.editable = editable;
    }

    @Override
    public void onCharTyped(char c) {
        if (this.editable) {
            this.text = this.text + c;
        }
    }

    @Override
    public void keyEvent(int key, int scancode, boolean isPress, boolean isRepeat, int modifiers) {
        if (!isPress && !isRepeat || !this.editable) {
            return;
        }
        switch (key) {
            case 259: {
                if (this.text.isEmpty()) break;
                this.text = this.text.substring(0, this.text.length() - 1);
                break;
            }
            case 258: {
                this.parent.onTabPressed(this);
                break;
            }
            case 257: {
                this.parent.onReturnPressed(this);
            }
        }
    }

    @Override
    public void render() {
        MenuComponentTextBox.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, ImageStash.instance.getTexture("/gui/textBox.png"));
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        if (this.textInset < 0.0) {
            switch (this.parent.gui.type) {
                case 1: 
                case 2: 
                case 4: {
                    this.textInset = 5.0;
                    break;
                }
                case 3: {
                    this.textInset = Math.min(this.width / 20.0, this.height / 20.0);
                }
            }
        }
        if (this.editable) {
            MenuComponentTextBox.drawText(this.x + this.textInset, this.y + this.textInset, this.x + this.width - this.textInset, this.y + this.height - this.textInset, this.text + ((this.gui.tick & 0x14) < 10 && this.isSelected ? "_" : ""));
        } else {
            MenuComponentTextBox.drawCenteredText(this.x + this.textInset, this.y + this.textInset, this.x + this.width - this.textInset, this.y + this.height - this.textInset, this.text);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

