/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.model;

import java.awt.Color;
import java.util.ArrayList;
import simplelibrary.opengl.model.Material;

public class Face {
    public final ArrayList<Integer> verticies;
    public final ArrayList<Integer> textureCoords;
    public final ArrayList<Integer> normals;
    public final Material material;
    public Color colorOverride = null;

    public Face(ArrayList<Integer> verticies, ArrayList<Integer> textureCoords, ArrayList<Integer> normals, Material material) {
        this.verticies = new ArrayList<Integer>(verticies);
        this.textureCoords = new ArrayList<Integer>(textureCoords);
        this.normals = new ArrayList<Integer>(normals);
        this.material = material;
    }

    public Face(Face f) {
        this(f.verticies, f.textureCoords, f.normals, f.material);
        this.colorOverride = f.colorOverride;
    }

    public int getTexture() {
        if (this.colorOverride != null) {
            return 0;
        }
        if (this.material.getTexture() == 0) {
            this.colorOverride = new Color((float)this.material.diffuseColor.getRed() / 255.0f, (float)this.material.diffuseColor.getGreen() / 255.0f, (float)this.material.diffuseColor.getBlue() / 255.0f, this.material.dissolve);
            return 0;
        }
        return this.material.getTexture();
    }
}

