/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.model;

import java.util.ArrayList;
import simplelibrary.opengl.model.Face;
import simplelibrary.opengl.model.Line;
import simplelibrary.opengl.model.Material;
import simplelibrary.opengl.model.Vector3f;

public class Model {
    public ArrayList<Face> faces = new ArrayList();
    public ArrayList<Line> lines = new ArrayList();
    public ArrayList<Vector3f> verticies = new ArrayList();
    public ArrayList<Vector3f> normals = new ArrayList();
    public ArrayList<float[]> textures = new ArrayList();
    public ArrayList<Material> materials = new ArrayList();
    public Vector3f origin = new Vector3f(0.0f, 0.0f, 0.0f);
    public double depth;
    public double width;
    public double height;
    public boolean hasNGons = false;

    public Model() {
    }

    public Model(Model m) {
        for (Face face : m.faces) {
            this.faces.add(new Face(face));
        }
        for (Line line : m.lines) {
            this.lines.add(new Line(line));
        }
        for (Vector3f vector3f : m.verticies) {
            this.verticies.add(new Vector3f(vector3f));
        }
        for (Vector3f vector3f : m.normals) {
            this.normals.add(new Vector3f(vector3f));
        }
        for (float[] fArray : m.textures) {
            float[] fl = new float[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fl[i] = fArray[i];
            }
            this.textures.add(fl);
        }
        this.materials.addAll(m.materials);
        this.origin = new Vector3f(m.origin);
    }

    public Material getMaterial(String name) {
        for (Material material : this.materials) {
            if (!material.name.equals(name)) continue;
            return material;
        }
        return null;
    }

    public void calculateDimensions() {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (Vector3f v : this.verticies) {
            minX = Math.min((double)v.x, minX);
            minY = Math.min((double)v.y, minY);
            minZ = Math.min((double)v.z, minZ);
            maxX = Math.max((double)v.x, maxX);
            maxY = Math.max((double)v.y, maxY);
            maxZ = Math.max((double)v.z, maxZ);
        }
        this.depth = maxY - minY;
        this.width = maxX - minX;
        this.height = maxZ - minZ;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void add(Model m) {
        int i;
        for (Face face : m.faces) {
            Face face2 = new Face(face);
            for (i = 0; i < face2.normals.size(); ++i) {
                face2.normals.set(i, face2.normals.get(i) + this.normals.size());
            }
            for (i = 0; i < face2.verticies.size(); ++i) {
                face2.verticies.set(i, face2.verticies.get(i) + this.verticies.size());
            }
            for (i = 0; i < face2.textureCoords.size(); ++i) {
                face2.textureCoords.set(i, face2.textureCoords.get(i) + this.textures.size());
            }
            this.faces.add(face2);
        }
        for (Line line : m.lines) {
            Line line2 = new Line(line);
            for (i = 0; i < line2.verticies.size(); ++i) {
                line2.verticies.set(i, line2.verticies.get(i) + this.verticies.size());
            }
            this.lines.add(new Line(line));
        }
        for (Vector3f vector3f : m.verticies) {
            this.verticies.add(new Vector3f(vector3f));
        }
        for (Vector3f vector3f : m.normals) {
            this.normals.add(new Vector3f(vector3f));
        }
        for (float[] fArray : m.textures) {
            float[] fl = new float[fArray.length];
            for (i = 0; i < fArray.length; ++i) {
                fl[i] = fArray[i];
            }
            this.textures.add(fl);
        }
        this.materials.addAll(m.materials);
    }
}

