/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.opengl.model.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import simplelibrary.opengl.model.Face;
import simplelibrary.opengl.model.Material;
import simplelibrary.opengl.model.Model;
import simplelibrary.opengl.model.Vector3f;
import simplelibrary.opengl.model.loader.AdjacentFileProvider;
import simplelibrary.opengl.model.loader.ModelLoader;

public class OBJLoader
implements ModelLoader {
    @Override
    public Model loadModel(InputStream stream, AdjacentFileProvider adjacentProvider) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Model m = new Model();
        ArrayList<Vector3f> loneVerticies = new ArrayList<Vector3f>();
        Material currentMaterial = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty() || line.startsWith("#")) continue;
            try {
                if (line.startsWith("mtllib ")) {
                    this.expectArgs("OBJ", line, 1);
                    m.materials.addAll(this.loadMTL(adjacentProvider.getAdjacentFile(line.split(" ")[1]), adjacentProvider));
                    continue;
                }
                if (line.startsWith("usemtl ")) {
                    this.expectArgs("OBJ", line, 1);
                    currentMaterial = m.getMaterial(line.split(" ")[1]);
                    continue;
                }
                if (line.startsWith("v ")) {
                    this.expectArgs("OBJ", line, 3);
                    float x = Float.valueOf(line.split(" ")[1]).floatValue();
                    float y = Float.valueOf(line.split(" ")[2]).floatValue();
                    float z = Float.valueOf(line.split(" ")[3]).floatValue();
                    m.verticies.add(new Vector3f(x, y, z));
                    loneVerticies.add(m.verticies.get(m.verticies.size() - 1));
                    this.expectArgs("OBJ", line, 3);
                    continue;
                }
                if (line.startsWith("vn ")) {
                    float x = Float.valueOf(line.split(" ")[1]).floatValue();
                    float y = Float.valueOf(line.split(" ")[2]).floatValue();
                    float z = Float.valueOf(line.split(" ")[3]).floatValue();
                    m.normals.add(new Vector3f(x, y, z));
                    this.expectArgs("OBJ", line, 3);
                    continue;
                }
                if (line.startsWith("vt ")) {
                    float u = Float.valueOf(line.split(" ")[1]).floatValue();
                    float v = Float.valueOf(line.split(" ")[2]).floatValue();
                    m.textures.add(new float[]{u, v});
                    continue;
                }
                if (line.startsWith("o ") || line.startsWith("s ")) continue;
                if (line.startsWith("f ")) {
                    ArrayList<Integer> verticies = new ArrayList<Integer>();
                    ArrayList<Integer> textures = new ArrayList<Integer>();
                    ArrayList<Integer> normals = new ArrayList<Integer>();
                    for (int i = 0; i < line.split(" ").length; ++i) {
                        if (i == 0) continue;
                        String v = line.split(" ")[i];
                        if (v.contains("//")) {
                            verticies.add(Integer.parseInt(v.split("//")[0]));
                            normals.add(Integer.parseInt(v.split("//")[1]));
                            continue;
                        }
                        if (v.contains("/")) {
                            verticies.add(Integer.parseInt(v.split("/")[0]));
                            textures.add(Integer.parseInt(v.split("/")[1]));
                            if (v.split("/").length < 3) continue;
                            normals.add(Integer.parseInt(v.split("/")[2]));
                            continue;
                        }
                        verticies.add(Integer.parseInt(v));
                    }
                    for (Integer i : verticies) {
                        loneVerticies.remove(m.verticies.get(i - 1));
                    }
                    if (verticies.size() > 4) {
                        m.hasNGons = true;
                    }
                    m.faces.add(new Face(verticies, textures, normals, currentMaterial));
                    continue;
                }
                throw new IllegalArgumentException("Unknown OBJ command: " + line);
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new IOException("Error while parsing OBJ command: " + line, ex);
            }
        }
        if (loneVerticies.size() == 1) {
            m.origin = new Vector3f((Vector3f)loneVerticies.get(0));
            for (Vector3f v : m.verticies) {
                v.x -= m.origin.x;
                v.y -= m.origin.y;
                v.z -= m.origin.z;
            }
        }
        reader.close();
        return m;
    }

    private void expectArgs(String type, String fullCommand, int expectedArgs) {
        if (fullCommand.split(" ").length - 1 != expectedArgs) {
            throw new IllegalArgumentException("Failed to parse " + type + " command! Expected " + expectedArgs + ", found " + (fullCommand.split(" ").length - 1) + " |  Full command: " + fullCommand);
        }
    }

    private ArrayList<Material> loadMTL(InputStream stream, AdjacentFileProvider adjacentProvider) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        ArrayList<Material> materials = new ArrayList<Material>();
        Material mat = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty() || line.startsWith("#")) continue;
            try {
                float b;
                float g;
                float r;
                if (line.startsWith("newmtl ")) {
                    this.expectArgs("MTL", line, 1);
                    mat = new Material(line.split(" ")[1]);
                    materials.add(mat);
                    continue;
                }
                if (line.startsWith("Ka ")) {
                    this.expectArgs("MTL", line, 3);
                    r = Float.parseFloat(line.split(" ")[1]);
                    g = Float.parseFloat(line.split(" ")[2]);
                    b = Float.parseFloat(line.split(" ")[3]);
                    mat.ambientColor = new Color(r, g, b);
                    continue;
                }
                if (line.startsWith("Kd ")) {
                    this.expectArgs("MTL", line, 3);
                    r = Float.parseFloat(line.split(" ")[1]);
                    g = Float.parseFloat(line.split(" ")[2]);
                    b = Float.parseFloat(line.split(" ")[3]);
                    mat.diffuseColor = new Color(r, g, b);
                    continue;
                }
                if (line.startsWith("Ke ")) {
                    this.expectArgs("MTL", line, 3);
                    r = Float.parseFloat(line.split(" ")[1]);
                    g = Float.parseFloat(line.split(" ")[2]);
                    b = Float.parseFloat(line.split(" ")[3]);
                    mat.emmissiveColor = new Color(r, g, b);
                    continue;
                }
                if (line.startsWith("Ks ")) {
                    this.expectArgs("MTL", line, 3);
                    r = Float.parseFloat(line.split(" ")[1]);
                    g = Float.parseFloat(line.split(" ")[2]);
                    b = Float.parseFloat(line.split(" ")[3]);
                    mat.specularColor = new Color(r, g, b);
                    continue;
                }
                if (line.startsWith("Ns ")) {
                    this.expectArgs("MTL", line, 1);
                    mat.specularExponent = Float.parseFloat(line.split(" ")[1]);
                    continue;
                }
                if (line.startsWith("d ")) {
                    this.expectArgs("MTL", line, 1);
                    mat.dissolve = Float.parseFloat(line.split(" ")[1]);
                    continue;
                }
                if (line.startsWith("illum ")) {
                    this.expectArgs("MTL", line, 1);
                    mat.illuminationModel = Integer.parseInt(line.split(" ")[1]);
                    continue;
                }
                if (line.startsWith("Tr ")) {
                    this.expectArgs("MTL", line, 1);
                    mat.dissolve = 1.0f - Float.parseFloat(line.split(" ")[1]);
                    continue;
                }
                if (line.startsWith("Ni ")) {
                    this.expectArgs("MTL", line, 1);
                    mat.indexOfRefraction = Float.parseFloat(line.split(" ")[1]);
                    continue;
                }
                if (line.startsWith("map_Kd ")) {
                    this.expectArgs("MTL", line, 1);
                    mat.image = adjacentProvider.getAdjacentFilepath(line.split(" ")[1]);
                    continue;
                }
                throw new IllegalArgumentException("Unknown MTL command: " + line);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Error while parsing MTL command: " + line, ex);
            }
        }
        reader.close();
        return materials;
    }
}

