/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.texture;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;
import simplelibrary.texture.TexturePack;

public class ExternalTexturePack
extends TexturePack {
    private final File file;
    private final String name;
    private ZipFile zip;

    public ExternalTexturePack(File file) throws IOException {
        this.file = file;
        InputStream in = this.getResourceAsStream("/texturepack.info");
        if (in == null) {
            throw new IllegalArgumentException("Illegal texture pack file!");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            this.name = reader.readLine();
        }
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("Couldn't find a texture pack name!");
        }
    }

    @Override
    public void close() {
        try {
            this.zip.close();
            this.zip = null;
        }
        catch (IOException ex) {
            Sys.error(ErrorLevel.severe, "Could not close texture pack " + this.name + "!", ex, ErrorCategory.fileIO);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.zip == null) {
            try {
                this.zip = new ZipFile(this.file);
            }
            catch (IOException ex) {
                Sys.error(ErrorLevel.severe, "Could not open texture pack " + this.name + "!", ex, ErrorCategory.fileIO);
                return null;
            }
        }
        ZipEntry entry = this.zip.getEntry(name.substring(1));
        try {
            return entry == null ? (this.manager == null ? super.getResourceAsStream(name) : this.manager.defaultTexturePack.getResourceAsStream(name)) : this.zip.getInputStream(entry);
        }
        catch (IOException ex) {
            Sys.error(ErrorLevel.severe, "Could not read resource " + name + " in texture pack " + this.name + "!", ex, ErrorCategory.fileIO);
            return null;
        }
    }

    @Override
    public boolean hasResource(String name) {
        ZipEntry entry;
        if (this.zip == null) {
            try {
                this.zip = new ZipFile(this.file);
            }
            catch (IOException ex) {
                Sys.error(ErrorLevel.severe, "Could not open texture pack " + this.name + "!", ex, ErrorCategory.fileIO);
                return false;
            }
        }
        return (entry = this.zip.getEntry(name.substring(1))) != null;
    }

    @Override
    public String name() {
        return this.name;
    }
}

