/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.texture;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import simplelibrary.texture.ExternalTexturePack;
import simplelibrary.texture.TexturePack;

public class TexturePackManager {
    public static TexturePackManager instance;
    public TexturePack currentTexturePack;
    public final File folder;
    public final ArrayList<TexturePack> texturePacks;
    final TexturePack defaultTexturePack;

    public TexturePackManager(File file, TexturePack defaultTexturePack) {
        this.folder = file;
        if (this.folder != null) {
            this.folder.mkdirs();
        }
        this.texturePacks = new ArrayList();
        this.texturePacks.add(defaultTexturePack);
        this.defaultTexturePack = defaultTexturePack;
        this.currentTexturePack = this.texturePacks.get(0);
        instance = this;
        this.findTexturePacks();
    }

    public int findTexturePacks() {
        if (this.folder == null) {
            return 0;
        }
        File[] files = this.folder.listFiles();
        if (files == null) {
            return -1;
        }
        while (!this.texturePacks.isEmpty()) {
            this.texturePacks.remove(0).close();
        }
        this.texturePacks.add(this.defaultTexturePack);
        if (files.length == 0) {
            return 0;
        }
        int loaded = 0;
        for (File file : files) {
            loaded += this.tryLoadTexturepack(file) ? 1 : 0;
        }
        return loaded;
    }

    public ArrayList<String> listTexturePacks() {
        ArrayList<String> names = new ArrayList<String>();
        for (TexturePack texturepack : this.texturePacks) {
            names.add(texturepack.name());
        }
        return names;
    }

    public boolean setTexturePack(String name) {
        for (TexturePack texturePack : this.texturePacks) {
            if (!texturePack.name().equals(name)) continue;
            this.currentTexturePack = texturePack;
            texturePack.manager = this;
            return true;
        }
        return false;
    }

    private boolean tryLoadTexturepack(File file) {
        try {
            ExternalTexturePack texturepack = new ExternalTexturePack(file);
            this.texturePacks.add(texturepack);
            return true;
        }
        catch (IOException | RuntimeException ex) {
            return false;
        }
    }
}

