/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.window;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WindowHelper {
    private static int[] lastValues = null;

    public static Dimension adjustSizeForContents(Dimension size) {
        int x = size.width;
        int y = size.height;
        int[] expansion = WindowHelper.getExpansion();
        return new Dimension(x += expansion[0], y += expansion[1]);
    }

    public static void centerFrame(Window Center, int width, int height) {
        if (Center == null) {
            throw new IllegalArgumentException("Parameter 'Center' cannot be 'null'!");
        }
        if (width == 0) {
            throw new IllegalArgumentException("Parameter 'width' cannot be '0'!");
        }
        if (height == 0) {
            throw new IllegalArgumentException("Parameter 'height' cannot be '0'!");
        }
        Toolkit kit = Center.getToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Insets in = kit.getScreenInsets(gs[0].getDefaultConfiguration());
        Dimension d = kit.getScreenSize();
        int maxWidth = d.width - in.left - in.right;
        int maxHeight = d.height - in.top - in.bottom;
        Center.setSize(Math.min(maxWidth, width), Math.min(maxHeight, height));
        Center.setLocation((maxWidth - Center.getWidth()) / 2, (maxHeight - Center.getHeight()) / 2);
    }

    public static void centerFrame(Window Center, Dimension size) {
        WindowHelper.centerFrame(Center, size.width, size.height);
    }

    public static JFrame createFrame(String title, int width, int height, WindowListener wl) {
        if (title == null || title.isEmpty()) {
            title = "A program for " + System.getProperty("os.name");
        }
        JFrame value = new JFrame(title);
        int[] expansion = WindowHelper.getExpansion();
        WindowHelper.centerFrame(value, width + expansion[0], height + expansion[1]);
        value.setDefaultCloseOperation(0);
        if (wl != null) {
            value.addWindowListener(wl);
        }
        value.setVisible(true);
        return value;
    }

    public static JFrame createFrame(String title, Dimension size, WindowListener wl) {
        return WindowHelper.createFrame(title, size.width, size.height, wl);
    }

    public static JFrame createFrameWithoutAppearance(String title, int width, int height, WindowListener wl) {
        if (title == null || title.isEmpty()) {
            title = "A program for " + System.getProperty("os.name");
        }
        JFrame value = new JFrame(title);
        int[] expansion = WindowHelper.getExpansion();
        WindowHelper.centerFrame(value, width + expansion[0], height + expansion[1]);
        value.setDefaultCloseOperation(0);
        if (wl != null) {
            value.addWindowListener(wl);
        }
        return value;
    }

    public static JFrame createFrameWithoutAppearance(String title, Dimension size, WindowListener wl) {
        return WindowHelper.createFrameWithoutAppearance(title, size.width, size.height, wl);
    }

    public static void findExpansion() {
        JFrame frame = new JFrame("Test frame");
        JPanel panel = new JPanel();
        frame.add(panel);
        frame.setVisible(true);
        Rectangle frameBounds = frame.getBounds();
        Rectangle panelBounds = panel.getBounds();
        lastValues = new int[]{frameBounds.width - panelBounds.width, frameBounds.height - panelBounds.height};
        frame.dispose();
    }

    public static int[] getExpansion() {
        if (lastValues == null) {
            WindowHelper.findExpansion();
        }
        return (int[])lastValues.clone();
    }

    public static void positionFrame(Container frame, int x, int y, int width, int height) {
        Toolkit kit = frame.getToolkit();
        Dimension d = kit.getScreenSize();
        x = Math.min(d.width - width, Math.max(0, x));
        y = Math.min(d.height - height, Math.max(0, y));
        frame.setBounds(x, y, width, height);
    }

    private WindowHelper() {
    }
}

