/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.client.gui;

import org.lwjgl.input.Mouse;
import sonar.reactorbuilder.client.gui.GuiScrollerOrientation;

public class GuiScroller {
    public float currentScroll;
    public boolean isScrolling;
    public boolean wasClicking;
    public int left;
    public int top;
    public int length;
    public int width;
    public GuiScrollerOrientation orientation = GuiScrollerOrientation.VERTICAL;

    public GuiScroller(int scrollerLeft, int scrollerStart, int length, int width) {
        this.left = scrollerLeft;
        this.top = scrollerStart;
        this.length = length;
        this.width = width;
    }

    public GuiScroller setOrientation(GuiScrollerOrientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public void handleMouse(boolean needsScrollBars, int listSize) {
        int i = Mouse.getEventDWheel();
        if (i != 0 && needsScrollBars) {
            int j = listSize + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void drawScreen(int x, int y, boolean needsScrollBars) {
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.left && y >= this.top && x < this.left + this.width && y < this.top + this.length) {
            this.isScrolling = needsScrollBars;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            float f = this.currentScroll = this.orientation.isVertical() ? ((float)(y - this.top) - 7.5f) / ((float)this.length - 15.0f) : ((float)(x - this.left) - 7.5f) / ((float)this.width - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }
}

