/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.client.renderer;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sonar.reactorbuilder.client.renderer.TemplateBlockAccess;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;

public class TemplateRenderer {
    public static void renderCachedTemplate(AbstractTemplate template) {
        if (template.bufferState3D != null) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_178993_a((BufferBuilder.State)template.bufferState3D);
            Tessellator.func_178181_a().func_78381_a();
        } else {
            TemplateBlockAccess blockAccess = new TemplateBlockAccess(template);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (int x = 0; x < template.xSize; ++x) {
                for (int y = 0; y < template.ySize; ++y) {
                    for (int z = 0; z < template.zSize; ++z) {
                        DictionaryEntry info = template.blocks[x][y][z];
                        if (info == null) continue;
                        BlockPos actualPos = new BlockPos(x, y, z);
                        IBlockState state = info.getBlockState();
                        IBakedModel bakedModel = renderer.func_184389_a(state);
                        renderer.func_175019_b().func_178267_a((IBlockAccess)blockAccess, bakedModel, state, actualPos, buffer, true);
                    }
                }
            }
            template.bufferState3D = buffer.func_181672_a();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public static void renderCachedLayers(AbstractTemplate template, double yOffset) {
        if (template.bufferState2D != null) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_178993_a((BufferBuilder.State)template.bufferState2D);
            Tessellator.func_178181_a().func_78381_a();
        } else {
            BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int y = 0; y < template.ySize; ++y) {
                for (int x = 0; x < template.xSize; ++x) {
                    for (int z = 0; z < template.zSize; ++z) {
                        DictionaryEntry info = template.getComponent(x, y, z);
                        if (info == null) continue;
                        IBlockState state = info.getBlockState();
                        IBakedModel bakedModel = renderer.func_184389_a(state);
                        TemplateRenderer.renderBlockFaceRapidly(buffer, bakedModel, state, x, (double)z + yOffset * (double)y, 0.0, 1.0, 1.0);
                    }
                }
            }
            template.bufferState2D = buffer.func_181672_a();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public static void renderBlockFaceRapidly(BufferBuilder buffer, IBakedModel modelIn, IBlockState stateIn, double x, double y, double z, double width, double height) {
        List list = modelIn.func_188616_a(stateIn, EnumFacing.UP, 0L);
        TextureAtlasSprite sprite = list.isEmpty() ? modelIn.func_177554_e() : ((BakedQuad)list.get(0)).func_187508_a();
        buffer.func_181662_b(x + 0.0, y + height, z).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(x + width, y + height, z).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(x + width, y + 0.0, z).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, z).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
    }
}

