/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.client.gui.GuiIconButton;
import sonar.reactorbuilder.client.gui.GuiScroller;
import sonar.reactorbuilder.common.ReactorBuilderContainer;
import sonar.reactorbuilder.common.ReactorBuilderGuiPages;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.files.HellrageJSONOverhaulReader;
import sonar.reactorbuilder.common.files.HellrageJSONUnderhaulReader;
import sonar.reactorbuilder.common.files.ThizNCPFReader;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.network.EnumSyncPacket;
import sonar.reactorbuilder.network.PacketHandler;
import sonar.reactorbuilder.network.PacketTileSync;
import sonar.reactorbuilder.network.templates.TemplateManager;
import sonar.reactorbuilder.registry.RBConfig;
import sonar.reactorbuilder.util.Translate;
import sonar.reactorbuilder.util.Util;

public class ReactorBuilderGui
extends GuiContainer {
    public static final ResourceLocation background = new ResourceLocation("reactorbuilder", "textures/gui/reactorbuilder.png");
    public static final ResourceLocation buttons = new ResourceLocation("reactorbuilder", "textures/gui/buttons.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 219;
    public static final int WINDOW_LEFT = 8;
    public static final int WINDOW_TOP = 8;
    public static final int WINDOW_WIDTH = 156;
    public static final int WINDOW_HEIGHT = 75;
    public ReactorBuilderTileEntity builder;
    public ReactorBuilderGuiPages.EnumPages currentPage = ReactorBuilderGuiPages.EnumPages.REACTOR_STATS;
    public GuiScroller scroller;
    public String fileError = "";

    public ReactorBuilderGui(ReactorBuilderTileEntity builder, ReactorBuilderContainer container) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 219;
        this.builder = builder;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiIconButton((GuiScreen)this, 0, this.field_147003_i + 7, this.field_147009_r + 89, 72, 0, 18, 18, Translate.PASTE_FILE.t()));
        this.field_146292_n.add(new GuiIconButton((GuiScreen)this, 2, this.field_147003_i + 133, this.field_147009_r + 89, 108, 0, 18, 18, Translate.BUILD_REACTOR.t()));
        this.field_146292_n.add(new GuiIconButton((GuiScreen)this, 3, this.field_147003_i + 151, this.field_147009_r + 89, 126, 0, 18, 18, Translate.DESTROY_REACTOR.t()));
        this.field_146292_n.add(new GuiIconButton((GuiScreen)this, 4, this.field_147003_i - 6, this.field_147009_r + 40, 180, 0, 5, 8, Translate.PREV_PAGE.t()));
        this.field_146292_n.add(new GuiIconButton((GuiScreen)this, 5, this.field_147003_i + 176 + 6 - 5, this.field_147009_r + 40, 198, 0, 5, 8, Translate.NEXT_PAGE.t()));
        this.scroller = new GuiScroller(this.field_147003_i + 8 + 161 - 4, this.field_147009_r + 8, 75, 4);
        this.currentPage = ReactorBuilderGuiPages.EnumPages.values()[this.builder.page];
        this.scroller.currentScroll = this.builder.scroll;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        this.func_73732_a(this.field_146289_q, this.getBuilderTotalProgress(), 117, 125, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.getBuilderEnergyText(), 117, 165, 0xFFFFFF);
        GlStateManager.func_179121_F();
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        double scaleW = (double)Minecraft.func_71410_x().field_71443_c / res.func_78327_c();
        double scaleH = (double)Minecraft.func_71410_x().field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)(this.field_147003_i + 8) * scaleW)), (int)((int)((double)Minecraft.func_71410_x().field_71440_d - (double)(this.field_147009_r + 8 + 75) * scaleH)), (int)((int)(156.0 * scaleW)), (int)((int)(75.0 * scaleH)));
        GlStateManager.func_179094_E();
        int pageSize = Math.max(0, this.currentPage.page.getPageSize(this) - 75);
        GlStateManager.func_179109_b((float)8.0f, (float)(8.0f - this.scroller.getCurrentScroll() * (float)pageSize), (float)0.0f);
        this.currentPage.page.renderPage(this, mouseX - this.field_147003_i - 8, (float)(mouseY - this.field_147009_r - 8) - this.scroller.getCurrentScroll() * (float)pageSize);
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3089);
        for (GuiButton guiButton : this.field_146292_n) {
            guiButton.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int progress = this.builder.getProgress();
        int totalProgress = this.builder.getTotalProgress();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (progress != 0) {
            this.drawTexturedModalRectDouble(this.field_147003_i + 6, this.field_147009_r + 110, 0.0, 219.0, (double)progress * 164.0 / (double)totalProgress, 6.0);
        }
        this.drawTexturedModalRectDouble(this.field_147003_i + 6, this.field_147009_r + 122, 0.0, 225.0, (double)(this.builder.shouldUseEnergy() ? this.builder.energyStorage.getEnergyStored() : this.builder.energyStorage.getMaxEnergyStored()) * 164.0 / (double)this.builder.energyStorage.getMaxEnergyStored(), 10.0);
        this.drawTexturedModalRectDouble(this.scroller.left, this.scroller.top + (int)((float)(this.scroller.length - 11) * this.scroller.getCurrentScroll()), 0.0, 235.0, 4.0, 11.0);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.pasteTemplateFile();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTileSync(this.builder, EnumSyncPacket.TOGGLE_BUILDING));
                    break;
                }
                case 3: {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTileSync(this.builder, EnumSyncPacket.TOGGLE_DESTROYING));
                    break;
                }
                case 4: {
                    if (this.builder.template == null) {
                        return;
                    }
                    int prev = this.currentPage.ordinal() - 1;
                    this.currentPage = prev >= 0 ? ReactorBuilderGuiPages.EnumPages.values()[prev] : ReactorBuilderGuiPages.EnumPages.values()[ReactorBuilderGuiPages.EnumPages.values().length - 1];
                    this.onPageChanged();
                    this.scroller.currentScroll = 0.0f;
                    this.onScrollerChanged();
                    break;
                }
                case 5: {
                    if (this.builder.template == null) {
                        return;
                    }
                    int next = this.currentPage.ordinal() + 1;
                    this.currentPage = next < ReactorBuilderGuiPages.EnumPages.values().length ? ReactorBuilderGuiPages.EnumPages.values()[next] : ReactorBuilderGuiPages.EnumPages.values()[0];
                    this.onPageChanged();
                    this.scroller.currentScroll = 0.0f;
                    this.onScrollerChanged();
                }
            }
        }
    }

    public void pasteTemplateFile() {
        AbstractTemplate newTemplate = null;
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object obj = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (obj instanceof List && !((List)obj).isEmpty() && ((List)obj).get(0) instanceof File) {
                    File file = (File)((List)obj).get(0);
                    String extension = Util.getFileExtension(file);
                    if (!extension.isEmpty()) {
                        if (extension.equalsIgnoreCase("ncpf")) {
                            if (RBConfig.allowThizNCPF) {
                                newTemplate = ThizNCPFReader.INSTANCE.readTemplate(file);
                                if (newTemplate == null) {
                                    this.fileError = ThizNCPFReader.INSTANCE.error;
                                }
                            } else {
                                this.fileError = Translate.FEATURE_DISABLED.format("NCPF");
                            }
                        } else if (extension.equalsIgnoreCase("json")) {
                            if (RBConfig.allowHellrageJSON) {
                                if (ReactorBuilder.isOverhaul()) {
                                    newTemplate = HellrageJSONOverhaulReader.INSTANCE.readTemplate(file);
                                    if (newTemplate == null) {
                                        this.fileError = HellrageJSONOverhaulReader.INSTANCE.error;
                                    }
                                } else {
                                    newTemplate = HellrageJSONUnderhaulReader.INSTANCE.readTemplate(file);
                                    if (newTemplate == null) {
                                        this.fileError = HellrageJSONUnderhaulReader.INSTANCE.error;
                                    }
                                }
                            } else {
                                this.fileError = Translate.FEATURE_DISABLED.format("JSON");
                            }
                        } else {
                            this.fileError = (Object)((Object)Translate.FILE_INVALID_EXTENSION) + ": " + extension;
                        }
                    } else {
                        this.fileError = Translate.FILE_MISSING_EXTENSION.t();
                    }
                }
            } else {
                this.fileError = Translate.FILE_NO_FILE.t();
            }
        }
        catch (Exception ignored) {
            this.fileError = Translate.FILE_ERROR.t();
            ReactorBuilder.logger.error("Error reading reactor file", (Throwable)ignored);
        }
        if (newTemplate != null) {
            newTemplate.templateID = newTemplate.fileName.hashCode();
            TemplateManager.getDownloadHandler(true).sendLocalTemplate(newTemplate, null, this.builder);
            this.fileError = "";
        }
    }

    public void drawTexturedModalRectDouble(double x, double y, double textureX, double textureY, double width, double height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x + 0.0, y + height, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0.0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + 0.0, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0.0) * f1)).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0.0) * f), (double)((float)(textureY + 0.0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scroller.handleMouse(true, this.currentPage.page.getPageSize(this));
        this.onScrollerChanged();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.field_147003_i + 8 <= mouseX && mouseX <= this.field_147003_i + 8 + 156 && this.field_147009_r + 8 <= mouseY && mouseY <= this.field_147009_r + 8 + 75) {
            this.currentPage.page.onClicked(this, mouseX - this.field_147003_i - 8, (float)(mouseY - this.field_147009_r - 8) + this.scroller.getCurrentScroll() * (float)Math.max(0, this.currentPage.page.getPageSize(this) - 75));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        this.scroller.drawScreen(mouseX, mouseY, true);
        this.onScrollerChanged();
    }

    public void onScrollerChanged() {
        this.builder.scroll = this.scroller.currentScroll;
    }

    public void onPageChanged() {
        this.builder.page = this.currentPage.ordinal();
    }

    public String getBuilderStatus() {
        if (!this.fileError.isEmpty()) {
            return TextFormatting.RED + this.fileError;
        }
        if (this.builder.template == null) {
            return Translate.FILE_NO_TEMPLATE.t();
        }
        if (!this.builder.error.isEmpty()) {
            return TextFormatting.RED + this.builder.error;
        }
        if (this.builder.isBuilding) {
            return TextFormatting.GREEN + String.format("%s %s/%s", this.builder.getPassName(), this.builder.getPassProgress(), this.builder.getPassTotal());
        }
        if (this.builder.isDestroying) {
            return TextFormatting.GREEN + String.format("%s %s/%s", Translate.PASS_REMOVING_COMPONENTS.t(), this.builder.getProgress(), this.builder.getTotalProgress());
        }
        if (this.builder.getProgress() == this.builder.getTotalProgress()) {
            return Translate.STATUS_FINISHED.t();
        }
        return Translate.STATUS_IDLE.t();
    }

    public String getBuilderTotalProgress() {
        int totalProgress = this.builder.getTotalProgress();
        int percentage = totalProgress != 0 ? this.builder.getProgress() * 100 / totalProgress : 0;
        return (this.builder.isDestroying ? Translate.STATUS_DESTROYING.t() : Translate.STATUS_BUILDING.t()) + ": " + percentage + " %";
    }

    private String getBuilderEnergyText() {
        if (!this.builder.shouldUseEnergy()) {
            return Translate.ENERGY_INFINITE.t() + " RF";
        }
        return String.format("%s RF", this.builder.energyStorage.getEnergyStored());
    }

    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    public RenderItem getRenderItem() {
        return this.field_146296_j;
    }
}

