/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.reactorbuilder.client.renderer.TemplateRenderer;
import sonar.reactorbuilder.common.ReactorBuilderGui;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.reactors.EnumCasingConfig;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.common.reactors.templates.UnderhaulSFRTemplate;
import sonar.reactorbuilder.network.EnumSyncPacket;
import sonar.reactorbuilder.network.PacketHandler;
import sonar.reactorbuilder.network.PacketTileSync;
import sonar.reactorbuilder.util.Translate;

public abstract class ReactorBuilderGuiPages
extends Gui {
    public abstract void renderPage(ReactorBuilderGui var1, float var2, float var3);

    public abstract int getPageSize(ReactorBuilderGui var1);

    public void onClicked(ReactorBuilderGui gui, float relativeX, float relativeY) {
    }

    public static class ReactorPage
    extends ReactorBuilderGuiPages {
        public long startRotate = -1L;

        @Override
        public void renderPage(ReactorBuilderGui gui, float relativeX, float relativeY) {
            float rotateTime = 20000.0f;
            long currentTime = System.currentTimeMillis();
            if (this.startRotate == -1L || (float)this.startRotate + rotateTime < (float)currentTime) {
                this.startRotate = System.currentTimeMillis();
            }
            float percentage = currentTime - this.startRotate;
            float rotation = 360.0f * (percentage / rotateTime);
            AbstractTemplate template = gui.builder.template;
            if (template == null) {
                return;
            }
            GlStateManager.func_179094_E();
            gui.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            gui.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(100.0f + this.field_73735_i));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            float scaling = Math.min(156.0f / (float)template.xSize, 75.0f / (float)template.ySize) / 2.0f;
            GlStateManager.func_179152_a((float)scaling, (float)scaling, (float)scaling);
            GlStateManager.func_179109_b((float)(156.0f / scaling / 2.0f), (float)(-(75.0f / scaling) / 2.0f), (float)0.0f);
            GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)((double)(-template.xSize) / 2.0), (double)((double)(-template.ySize) / 2.0), (double)((double)(-template.zSize) / 2.0));
            TemplateRenderer.renderCachedTemplate(template);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            gui.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            gui.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)75.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(100.0f + this.field_73735_i));
            float flatScaling = (float)Math.min(156 / template.xSize, 75 / template.zSize) * 0.8f;
            GlStateManager.func_179152_a((float)flatScaling, (float)flatScaling, (float)flatScaling);
            GlStateManager.func_179109_b((float)(156.0f / flatScaling / 2.0f), (float)(75.0f / flatScaling / 2.0f), (float)0.0f);
            GlStateManager.func_179137_b((double)(-0.5 - (double)(template.xSize / 2)), (double)(-0.5 - (double)(template.zSize / 2)), (double)0.0);
            TemplateRenderer.renderCachedLayers(template, 75.0f / flatScaling);
            GlStateManager.func_179121_F();
            for (int i = 0; i < template.ySize; ++i) {
                gui.func_73732_a(gui.getFont(), String.valueOf(i + 1), 30, 116 + 75 * i, -1);
            }
        }

        @Override
        public int getPageSize(ReactorBuilderGui gui) {
            return 75 + (gui.builder.template == null ? 0 : gui.builder.template.ySize * 75);
        }
    }

    public static class ComponentsPage
    extends ReactorBuilderGuiPages {
        @Override
        public void onClicked(ReactorBuilderGui gui, float relativeX, float relativeY) {
            int config;
            super.onClicked(gui, relativeX, relativeY);
            if (10.0f <= relativeY && relativeY < 28.0f && (config = (int)(relativeX - 6.0f) / 21) < 7) {
                if (config == 6 && gui.builder.template instanceof UnderhaulSFRTemplate) {
                    ItemStack stack = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77946_l();
                    stack.func_190920_e(1);
                    ((UnderhaulSFRTemplate)gui.builder.template).edgeItem = stack;
                    gui.builder.template.caseConfig[config] = !stack.func_190926_b();
                } else {
                    gui.builder.template.caseConfig[config] = !gui.builder.template.caseConfig[config];
                }
                gui.builder.template.updateAdditionalInfo();
                gui.builder.template.sortAdditionalInfo();
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTileSync(gui.builder, EnumSyncPacket.SYNC_CASING_TYPES));
            }
            float itemStart = 52.5f;
            float itemHeight = 13.5f;
            if (itemStart <= relativeY) {
                int itemPos = (int)((relativeY - itemStart) / itemHeight);
                Map.Entry<DictionaryEntry, Integer> entry = null;
                int pos = 0;
                for (Map.Entry<DictionaryEntry, Integer> required : gui.builder.template.required.entrySet()) {
                    if (pos == itemPos) {
                        entry = required;
                        break;
                    }
                    ++pos;
                }
                if (entry != null) {
                    Integer globalID = ((DictionaryEntry)entry.getKey()).globalID;
                    if (gui.builder.template.highlights.contains(globalID)) {
                        gui.builder.template.highlights.removeIf(i -> i.equals(globalID));
                    } else {
                        gui.builder.template.highlights.add(globalID);
                    }
                }
                System.out.println(entry != null ? ((DictionaryEntry)entry.getKey()).globalName : "null");
            }
        }

        @Override
        public void renderPage(ReactorBuilderGui gui, float relativeX, float relativeY) {
            if (gui.builder.template != null) {
                int i;
                RenderHelper.func_74520_c();
                ItemStack solid = gui.builder.template.getDefaultSolidCasing().getItemStack();
                ItemStack glass = gui.builder.template.getDefaultGlassCasing().getItemStack();
                for (i = 0; i < 7; ++i) {
                    ItemStack stack;
                    ItemStack itemStack = stack = gui.builder.template.caseConfig[i] ? glass : solid;
                    if (i == 6 && gui.builder.template instanceof UnderhaulSFRTemplate) {
                        stack = ((UnderhaulSFRTemplate)gui.builder.template).edgeItem;
                    }
                    gui.getRenderItem().func_175042_a(stack, 6 + 21 * i, 14);
                }
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                for (i = 0; i < 7; ++i) {
                    gui.func_73732_a(gui.getFont(), EnumCasingConfig.values()[i].name().toLowerCase(), (int)((5.5 + (double)(21 * i) + 9.0) / 0.5), 64, -1);
                }
                GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73731_b(gui.getFont(), TextFormatting.BLUE + Translate.CASING_CONFIG.t() + ": ", 4, 4, -1);
                int totalY = 44;
                this.func_73731_b(gui.getFont(), TextFormatting.BLUE + Translate.REQUIRED_COMPONENTS.t() + ": ", 4, totalY += 14, -1);
                totalY += 12;
                for (Map.Entry<DictionaryEntry, Integer> required : gui.builder.template.required.entrySet()) {
                    boolean highlighted = gui.builder.template.highlights.contains(required.getKey().globalID);
                    ItemStack stack = required.getKey().getItemStack();
                    gui.getRenderItem().func_175042_a(stack, 10, totalY);
                    gui.func_73731_b(gui.getFont(), (highlighted ? "" + TextFormatting.BLUE : "") + required.getValue() + " x " + stack.func_82833_r(), 34, 4 + totalY, -1);
                    totalY += 18;
                }
                RenderHelper.func_74518_a();
            }
        }

        @Override
        public int getPageSize(ReactorBuilderGui gui) {
            if (gui.builder.template != null) {
                return (int)((double)((gui.builder.template.required.size() + 2) * 18) * 0.75) + 40;
            }
            return 0;
        }
    }

    public static class StatsPage
    extends ReactorBuilderGuiPages {
        @Override
        public void renderPage(ReactorBuilderGui gui, float relativeX, float relativeY) {
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            AbstractTemplate template = gui.builder.template;
            int totalY = -10;
            this.func_73731_b(gui.getFont(), TextFormatting.BLUE + Translate.STATUS.t() + ": " + TextFormatting.RESET + gui.getBuilderStatus(), 4, totalY += 12, -1);
            if (template != null) {
                LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
                template.getStats(stats);
                for (Map.Entry stat : stats.entrySet()) {
                    if (!((String)stat.getValue()).isEmpty() || !((String)stat.getKey()).isEmpty()) {
                        this.func_73731_b(gui.getFont(), TextFormatting.BLUE + (String)stat.getKey() + ": " + TextFormatting.RESET + (String)stat.getValue(), 4, totalY += 12, -1);
                        continue;
                    }
                    totalY += 5;
                }
                this.func_73731_b(gui.getFont(), TextFormatting.BLUE + "Build Pass: " + TextFormatting.RESET + (gui.builder.buildPass + 1) + "/" + template.getBuildPasses(), 4, totalY += 12, -1);
            }
            if (gui.builder.isBuilding) {
                int seconds = (int)((float)(gui.builder.getTotalProgress() - gui.builder.getProgress()) / gui.builder.getBlocksPerTick()) / 20;
                int secondsLeft = seconds % 3600 % 60;
                int minutes = (int)Math.floor(seconds % 3600 / 60);
                int hours = (int)Math.floor(seconds / 3600);
                String timeString = (hours != 0 ? hours + " h " : "") + (minutes != 0 ? minutes + " m " : "") + (secondsLeft != 0 ? secondsLeft + " s " : "");
                this.func_73731_b(gui.getFont(), TextFormatting.BLUE + "Time Remaining: " + TextFormatting.RESET + timeString, 4, totalY += 12, -1);
            }
        }

        @Override
        public int getPageSize(ReactorBuilderGui gui) {
            int totalY = 12;
            if (gui.builder.template != null) {
                LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
                gui.builder.template.getStats(stats);
                totalY += stats.size() * 12;
            }
            return totalY;
        }
    }

    public static enum EnumPages {
        REACTOR_STATS(new StatsPage()),
        COMPONENTS(new ComponentsPage()),
        RENDER_REACTOR(new ReactorPage());

        public ReactorBuilderGuiPages page;

        private EnumPages(ReactorBuilderGuiPages page) {
            this.page = page;
        }
    }
}

