/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;

public class ReactorBuilderRenderer
extends TileEntitySpecialRenderer<ReactorBuilderTileEntity> {
    public static AxisAlignedBB FULL_BLOCK = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public void render(ReactorBuilderTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te == null) {
            return;
        }
        if (te.template != null) {
            BlockPos startPos = te.getStartPos();
            GlStateManager.func_179094_E();
            GlStateManager.func_179118_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)240.0f);
            AxisAlignedBB bb = new AxisAlignedBB(te.template.getIntStart(), te.template.getIntEnd().func_177982_a(1, 1, 1));
            ReactorBuilderRenderer.drawBoundingBox(bb, startPos, partialTicks, 0.0f, 0.0f, 0.0f, 1.0f);
            AxisAlignedBB casing = new AxisAlignedBB(te.template.getExtStart(), te.template.getExtEnd().func_177982_a(1, 1, 1));
            ReactorBuilderRenderer.drawBoundingBox(casing, startPos, partialTicks, 0.0f, 0.0f, 0.0f, 1.0f);
            if (te.errorPosition != null) {
                GlStateManager.func_179097_i();
                ReactorBuilderRenderer.drawBoundingBox(FULL_BLOCK, te.errorPosition, partialTicks, 1.0f, 0.1f, 0.1f, 1.0f);
                GlStateManager.func_179126_j();
            }
            if (!te.template.highlights.isEmpty()) {
                GlStateManager.func_179097_i();
                for (int xPos = te.template.getExtStart().func_177958_n(); xPos <= te.template.getExtEnd().func_177958_n(); ++xPos) {
                    for (int yPos = te.template.getExtStart().func_177956_o(); yPos <= te.template.getExtEnd().func_177956_o(); ++yPos) {
                        for (int zPos = te.template.getExtStart().func_177952_p(); zPos <= te.template.getExtEnd().func_177952_p(); ++zPos) {
                            DictionaryEntry component = te.template.getComponent(xPos, yPos, zPos);
                            if (component == null || !te.template.highlights.contains(component.globalID)) continue;
                            ReactorBuilderRenderer.drawBoundingBox(FULL_BLOCK, startPos.func_177982_a(xPos, yPos, zPos), partialTicks, 0.1f, 0.4f, 1.0f, 1.0f);
                        }
                    }
                }
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
    }

    public static void drawBoundingBox(AxisAlignedBB box, BlockPos pos, float partialTicks, float r, float g, float b, float alpha) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        if (Minecraft.func_71410_x().field_71441_e.func_175723_af().func_177746_a(pos)) {
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179137_b((double)(-d0 + (double)pos.func_177958_n()), (double)(-d1 + (double)pos.func_177956_o()), (double)(-d2 + (double)pos.func_177952_p()));
            RenderGlobal.func_189697_a((AxisAlignedBB)box.func_72321_a(-0.002, -0.002, -0.002), (float)r, (float)g, (float)b, (float)alpha);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(ReactorBuilderTileEntity te) {
        return true;
    }
}

