/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.reactors.EnumCasingConfig;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.common.reactors.templates.UnderhaulSFRTemplate;
import sonar.reactorbuilder.network.EnumSyncPacket;
import sonar.reactorbuilder.network.PacketHandler;
import sonar.reactorbuilder.network.PacketTileSync;
import sonar.reactorbuilder.network.templates.TemplateManager;
import sonar.reactorbuilder.network.templates.TemplateServerData;
import sonar.reactorbuilder.registry.RBConfig;
import sonar.reactorbuilder.util.EnergyStorageSyncable;

public class ReactorBuilderTileEntity
extends TileEntity
implements ITickable {
    public EnergyStorageSyncable energyStorage = new EnergyStorageSyncable(RBConfig.energyCapacityDefault, RBConfig.energyTransferDefault);
    public int templateID = -1;
    public boolean isBuilding = false;
    public boolean isDestroying = false;
    public byte buildPass = 0;
    public int xPos;
    public int yPos;
    public int zPos;
    public int[] passProgress = new int[1];
    public int destroyProgress = 0;
    public String error = "";
    public BlockPos errorPosition = null;
    private float loopTick;
    private BlockPos startPos = null;
    public int page;
    public float scroll;
    public AbstractTemplate template = null;

    public void func_73660_a() {
        if (this.template == null && this.templateID != -1) {
            this.initTemplate();
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.template == null) {
            if (this.isDestroying || this.isBuilding) {
                this.reset();
            }
            return;
        }
        if (this.isDestroying) {
            this.destroy();
            this.func_70296_d();
            return;
        }
        if (this.isBuilding) {
            if (!this.template.isCustomPass(this.buildPass)) {
                this.build();
            } else {
                this.template.tickCustomPass(this, this.buildPass);
                if (this.getPassProgress() == this.getPassTotal()) {
                    this.nextPass();
                }
            }
            this.func_70296_d();
        }
    }

    public boolean canBuild() {
        return this.template != null && this.checkBuildArea();
    }

    public boolean canDestroy() {
        return this.template != null;
    }

    public void startBuilding() {
        if (this.isDestroying) {
            this.isDestroying = false;
            this.reset();
        }
        if (this.isBuilding) {
            this.isBuilding = false;
        } else if (this.canBuild()) {
            this.isBuilding = true;
            this.reset();
        }
    }

    public void startDestroying() {
        if (this.isBuilding) {
            this.isBuilding = false;
            this.reset();
        }
        if (this.isDestroying) {
            this.isDestroying = false;
        } else if (this.canDestroy()) {
            this.isDestroying = true;
            this.reset();
        }
    }

    public void pauseWithError(BlockPos errorPosition, String error) {
        this.errorPosition = errorPosition;
        this.isBuilding = false;
        this.isDestroying = false;
        this.error = error;
        this.sendPacketToNearby(EnumSyncPacket.GENERAL_SYNC, 64);
    }

    public void reset() {
        this.buildPass = 0;
        this.xPos = -1;
        this.yPos = -1;
        this.zPos = -1;
        this.passProgress = new int[this.template != null ? this.template.getBuildPasses() : 1];
        this.error = "";
        this.errorPosition = null;
        this.destroyProgress = 0;
    }

    public void nextPass() {
        if (this.buildPass == this.template.getBuildPasses() - 1) {
            this.isBuilding = false;
        } else {
            this.buildPass = (byte)(this.buildPass + 1);
            this.xPos = -1;
            this.yPos = -1;
            this.zPos = -1;
        }
    }

    public float getBlocksPerTick() {
        return RBConfig.blocksPerTickDefault;
    }

    public void build() {
        this.loopTick += this.getBlocksPerTick();
        int place = (int)Math.floor(this.loopTick);
        if (place >= 1) {
            this.loopTick -= (float)place;
            for (int i = 0; i < place; ++i) {
                this.placeComponent();
                if (this.isBuilding) continue;
                return;
            }
        }
    }

    public void placeComponent() {
        DictionaryEntry component = this.template.getComponent(this.xPos, this.yPos, this.zPos);
        BlockPos nextPos = this.getStartPos().func_177982_a(this.xPos, this.yPos, this.zPos);
        if (component != null && this.template.canPlaceThisPass(this.buildPass, this.xPos, this.yPos, this.zPos, component) && !this.isMatchingComponentAtPos(component, nextPos)) {
            if (!this.canPlaceComponentAtPos(component, nextPos)) {
                this.pauseWithError(nextPos, String.format("Invalid block %sx: %s, y: %s, z: %s", TextFormatting.GOLD, nextPos.func_177958_n(), nextPos.func_177956_o(), nextPos.func_177952_p()));
                return;
            }
            if (this.shouldUseEnergy() && !this.hasRequiredEnergy()) {
                this.pauseWithError(null, "Not enough energy");
                return;
            }
            if (this.shouldUseItems()) {
                IItemHandler inventory = this.getAdjacentInventory();
                if (inventory == null) {
                    this.pauseWithError(null, "No inventory detected");
                    return;
                }
                int targetSlot = this.getSlotContainingComponent(inventory, component);
                if (targetSlot == -1) {
                    this.pauseWithError(null, String.format("Missing %s%s", TextFormatting.GOLD, component.getItemStack().func_82833_r()));
                    return;
                }
                inventory.extractItem(targetSlot, 1, false);
            }
            if (this.shouldUseEnergy()) {
                this.energyStorage.extractEnergy(this.getEnergyPerBlock(), false);
            }
            this.field_145850_b.func_180501_a(nextPos, component.getBlockState(), 2);
            this.onComponentPlaced(component, nextPos);
        }
        if (!this.incrementBuildPos()) {
            this.nextPass();
        }
    }

    public boolean incrementBuildPos() {
        while (this.yPos <= this.template.ySize) {
            while (this.xPos <= this.template.xSize) {
                while (this.zPos <= this.template.zSize) {
                    DictionaryEntry info = this.template.getComponent(this.xPos, this.yPos, this.zPos);
                    BlockPos nextPos = this.getStartPos().func_177982_a(this.xPos, this.yPos, this.zPos);
                    if (info != null && this.template.canPlaceThisPass(this.buildPass, this.xPos, this.yPos, this.zPos, info)) {
                        if (!this.isMatchingComponentAtPos(info, nextPos)) {
                            return true;
                        }
                        byte by = this.buildPass;
                        this.passProgress[by] = this.passProgress[by] + 1;
                    }
                    ++this.zPos;
                }
                this.zPos = -1;
                ++this.xPos;
            }
            this.xPos = -1;
            ++this.yPos;
        }
        return false;
    }

    public void destroy() {
        this.loopTick += this.getBlocksPerTick();
        int place = (int)Math.floor(this.loopTick);
        if (place >= 1) {
            this.loopTick -= (float)place;
            for (int i = 0; i < place; ++i) {
                this.destroyComponent();
                if (this.isDestroying) continue;
                return;
            }
        }
    }

    public void destroyComponent() {
        DictionaryEntry component = this.template.getComponent(this.xPos, this.yPos, this.zPos);
        BlockPos nextPos = this.getStartPos().func_177982_a(this.xPos, this.yPos, this.zPos);
        if (component != null && this.isMatchingComponentAtPos(component, nextPos)) {
            if (this.shouldUseEnergy() && !this.hasRequiredEnergy()) {
                this.pauseWithError(null, "Not enough energy");
                return;
            }
            IBlockState state = this.field_145850_b.func_180495_p(nextPos);
            NonNullList drops = NonNullList.func_191196_a();
            state.func_177230_c().getDrops(drops, (IBlockAccess)this.field_145850_b, nextPos, state, 0);
            if (this.shouldUseItems()) {
                IItemHandler inventory = this.getAdjacentInventory();
                if (inventory == null) {
                    this.pauseWithError(null, "No inventory detected");
                    return;
                }
                for (ItemStack drop : drops) {
                    ItemStack insert = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)drop, (boolean)true);
                    if (insert.func_190926_b()) continue;
                    this.pauseWithError(null, "Inventory too full");
                    return;
                }
                for (ItemStack drop : drops) {
                    ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)drop, (boolean)false);
                }
            }
            if (this.shouldUseEnergy()) {
                this.energyStorage.extractEnergy(this.getEnergyPerBlock(), false);
            }
            this.field_145850_b.func_180501_a(nextPos, Blocks.field_150350_a.func_176223_P(), 2);
            this.onComponentDestroyed(component, nextPos);
        }
        if (!this.incrementDestroyPos()) {
            this.reset();
            this.isDestroying = false;
        }
    }

    public boolean incrementDestroyPos() {
        while (this.yPos <= this.template.ySize) {
            while (this.xPos <= this.template.xSize) {
                while (this.zPos <= this.template.zSize) {
                    DictionaryEntry info = this.template.getComponent(this.xPos, this.yPos, this.zPos);
                    BlockPos nextPos = this.getStartPos().func_177982_a(this.xPos, this.yPos, this.zPos);
                    if (info != null) {
                        if (this.isMatchingComponentAtPos(info, nextPos)) {
                            return true;
                        }
                        ++this.destroyProgress;
                    }
                    ++this.zPos;
                }
                this.zPos = -1;
                ++this.xPos;
            }
            this.xPos = -1;
            ++this.yPos;
        }
        return false;
    }

    public int getProgress() {
        if (this.template == null) {
            return 0;
        }
        if (this.isDestroying) {
            return this.destroyProgress;
        }
        int progress = 0;
        for (int i = 0; i < this.passProgress.length; ++i) {
            progress += this.passProgress[i];
        }
        return progress;
    }

    public int getTotalProgress() {
        if (this.template == null) {
            return 0;
        }
        if (this.isDestroying) {
            return this.template.totalSolidComponents + this.template.totalEdges + this.template.totalSolidCasing + this.template.totalGlassCasing;
        }
        int total = 0;
        for (int i = 0; i < this.template.getBuildPasses(); ++i) {
            total += this.template.getBuildPassTotal(i);
        }
        return total;
    }

    public int getPassProgress() {
        if (this.template == null) {
            return 0;
        }
        return this.passProgress[this.buildPass];
    }

    public int getPassTotal() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getBuildPassTotal(this.buildPass);
    }

    public String getPassName() {
        if (this.template == null) {
            return "";
        }
        return this.template.getBuildPassNames()[this.buildPass];
    }

    public void onComponentPlaced(DictionaryEntry component, BlockPos pos) {
        this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 0.5f);
    }

    public void onComponentDestroyed(DictionaryEntry component, BlockPos pos) {
        this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, 0.5f);
    }

    public boolean canPlaceComponentAtPos(@Nullable DictionaryEntry component, BlockPos pos) {
        if (component != null) {
            return component.canPlaceComponentAtPos(this.field_145850_b, pos);
        }
        return this.field_145850_b.func_175623_d(pos) || this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BlockLiquid || this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof IFluidBlock;
    }

    public boolean isMatchingComponentAtPos(@Nullable DictionaryEntry component, BlockPos pos) {
        if (component != null) {
            return component.isMatchingComponentAtPos(this.field_145850_b, pos);
        }
        return this.field_145850_b.func_175623_d(pos);
    }

    public BlockPos getStartPos() {
        if (this.startPos != null) {
            return this.startPos;
        }
        this.startPos = this.template.getStartPos(this);
        return this.startPos;
    }

    public boolean checkBuildArea() {
        for (int testY = this.template.getExtStart().func_177956_o(); testY <= this.template.getExtEnd().func_177956_o(); ++testY) {
            for (int testX = this.template.getExtStart().func_177958_n(); testX <= this.template.getExtEnd().func_177958_n(); ++testX) {
                for (int testZ = this.template.getExtStart().func_177952_p(); testZ <= this.template.getExtEnd().func_177952_p(); ++testZ) {
                    BlockPos pos = this.getStartPos().func_177982_a(testX, testY, testZ);
                    DictionaryEntry info = this.template.getComponent(testX, testY, testZ);
                    if (this.canPlaceComponentAtPos(info, pos) || this.isMatchingComponentAtPos(info, pos)) continue;
                    this.pauseWithError(pos, String.format("Invalid block %sx: %s, y: %s, z: %s", TextFormatting.GOLD, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    return false;
                }
            }
        }
        return true;
    }

    public boolean shouldUseItems() {
        return true;
    }

    @Nullable
    public IItemHandler getAdjacentInventory() {
        BlockPos invPos = this.func_174877_v().func_177972_a(EnumFacing.UP);
        TileEntity tile = this.field_145850_b.func_175625_s(invPos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        }
        return null;
    }

    public int getSlotContainingComponent(IItemHandler inventory, DictionaryEntry component) {
        int targetSlot = -1;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)component.getItemStack()) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)component.getItemStack())) continue;
            if (inventory.extractItem(slot, 1, true).func_190926_b()) break;
            targetSlot = slot;
            break;
        }
        return targetSlot;
    }

    public boolean shouldUseEnergy() {
        return true;
    }

    public int getEnergyPerBlock() {
        return RBConfig.energyPerBlockDefault;
    }

    public boolean hasRequiredEnergy() {
        return this.energyStorage.getEnergyStored() >= this.getEnergyPerBlock();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void initTemplate() {
        this.startPos = null;
        this.template = TemplateManager.getTemplateManager(this.field_145850_b.field_72995_K).getTemplate(this.templateID);
        if (!this.field_145850_b.field_72995_K && this.template == null) {
            this.templateID = -1;
        }
        if (this.template != null) {
            this.template.updateAdditionalInfo();
            this.template.sortAdditionalInfo();
        }
    }

    public void changeTemplate(int templateID) {
        if (this.templateID == templateID) {
            return;
        }
        this.removeTemplateData();
        this.templateID = templateID;
        if (!this.field_145850_b.field_72995_K) {
            this.sendPacketToNearby(EnumSyncPacket.SYNC_TEMPLATE, 32);
            this.func_70296_d();
        }
        this.initTemplate();
    }

    public void removeTemplateData() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TemplateServerData.get().templates.remove(this.templateID);
        TemplateServerData.get().func_76185_a();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isBuilding = compound.func_74767_n("building");
        this.isDestroying = compound.func_74767_n("destroy");
        this.xPos = compound.func_74762_e("xPos");
        this.yPos = compound.func_74762_e("yPos");
        this.zPos = compound.func_74762_e("zPos");
        this.passProgress = compound.func_74759_k("progress");
        this.destroyProgress = compound.func_74762_e("destroyP");
        this.error = compound.func_74779_i("error");
        this.energyStorage.readFromNBT(compound);
        this.errorPosition = compound.func_74764_b("errorPos") ? BlockPos.func_177969_a((long)compound.func_74763_f("errorPos")) : null;
        this.templateID = compound.func_74762_e("templateID");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("building", this.isBuilding);
        compound.func_74757_a("destroy", this.isDestroying);
        compound.func_74768_a("xPos", this.xPos);
        compound.func_74768_a("yPos", this.yPos);
        compound.func_74768_a("zPos", this.zPos);
        compound.func_74783_a("progress", this.passProgress);
        compound.func_74768_a("destroyP", this.destroyProgress);
        compound.func_74778_a("error", this.error);
        this.energyStorage.writeToNBT(compound);
        if (this.errorPosition != null) {
            compound.func_74772_a("errorPos", this.errorPosition.func_177986_g());
        }
        compound.func_74768_a("templateID", this.templateID);
        return compound;
    }

    public void sendPacketToNearby(EnumSyncPacket type, int range) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)range);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketTileSync(this, type), point);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 8, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void writeSyncPacket(ByteBuf buf, EnumSyncPacket type) {
        switch (type) {
            case GENERAL_SYNC: {
                buf.writeBoolean(this.isBuilding);
                buf.writeBoolean(this.isDestroying);
                buf.writeByte((int)this.buildPass);
                buf.writeInt(this.xPos);
                buf.writeInt(this.yPos);
                buf.writeInt(this.zPos);
                buf.writeInt(this.destroyProgress);
                buf.writeInt(this.passProgress.length);
                for (int i = 0; i < this.passProgress.length; ++i) {
                    buf.writeInt(this.passProgress[i]);
                }
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.error);
                this.energyStorage.writeToBuf(buf);
                buf.writeBoolean(this.errorPosition != null);
                if (this.errorPosition == null) break;
                buf.writeLong(this.errorPosition.func_177986_g());
                break;
            }
            case SYNC_TEMPLATE: {
                buf.writeInt(this.templateID);
                buf.writeBoolean(this.template != null);
                if (this.template == null) break;
                this.template.writeHeaderToBuf(buf);
                break;
            }
            case TOGGLE_BUILDING: {
                break;
            }
            case SYNC_CASING_TYPES: {
                for (int i = 0; i < EnumCasingConfig.values().length; ++i) {
                    buf.writeBoolean(this.template.caseConfig[i]);
                }
                if (!(this.template instanceof UnderhaulSFRTemplate)) break;
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((UnderhaulSFRTemplate)this.template).edgeItem);
            }
        }
    }

    public void readSyncPacket(ByteBuf buf, EnumSyncPacket type) {
        switch (type) {
            case GENERAL_SYNC: {
                this.isBuilding = buf.readBoolean();
                this.isDestroying = buf.readBoolean();
                this.buildPass = buf.readByte();
                this.xPos = buf.readInt();
                this.yPos = buf.readInt();
                this.zPos = buf.readInt();
                this.destroyProgress = buf.readInt();
                int passes = buf.readInt();
                this.passProgress = new int[passes];
                for (int i = 0; i < passes; ++i) {
                    this.passProgress[i] = buf.readInt();
                }
                this.error = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.energyStorage.readFromBuf(buf);
                if (buf.readBoolean()) {
                    this.errorPosition = BlockPos.func_177969_a((long)buf.readLong());
                    break;
                }
                this.errorPosition = null;
                break;
            }
            case SYNC_TEMPLATE: {
                this.templateID = buf.readInt();
                this.initTemplate();
                if (!buf.readBoolean() || this.template == null) break;
                this.template.readHeaderFromBuf(buf);
                this.template.updateAdditionalInfo();
                this.template.sortAdditionalInfo();
                break;
            }
            case TOGGLE_BUILDING: {
                this.startBuilding();
                break;
            }
            case TOGGLE_DESTROYING: {
                this.startDestroying();
                break;
            }
            case SYNC_CASING_TYPES: {
                for (int i = 0; i < EnumCasingConfig.values().length; ++i) {
                    this.template.caseConfig[i] = buf.readBoolean();
                }
                if (this.template instanceof UnderhaulSFRTemplate) {
                    ((UnderhaulSFRTemplate)this.template).edgeItem = ByteBufUtils.readItemStack((ByteBuf)buf);
                }
                this.template.updateAdditionalInfo();
                this.template.sortAdditionalInfo();
                TemplateServerData.get().func_76185_a();
            }
        }
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static class Creative
    extends ReactorBuilderTileEntity {
        @Override
        public boolean shouldUseItems() {
            return false;
        }

        @Override
        public boolean shouldUseEnergy() {
            return false;
        }

        @Override
        public float getBlocksPerTick() {
            return RBConfig.blocksPerTickCreative;
        }
    }
}

