/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.dictionary;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.dictionary.DictionaryEntryType;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;

public abstract class DictionaryEntry {
    public int globalID;
    public String globalName;
    public DictionaryEntryType entryType;
    public boolean ignoreMeta = false;

    public DictionaryEntry(int id, String globalName, DictionaryEntryType entryType) {
        this.globalID = id;
        this.globalName = globalName;
        this.entryType = entryType;
    }

    public abstract String getDisplayName();

    public ItemStack getItemStack() {
        return ((ItemEntry)this).getDefaultItemStack();
    }

    public IBlockState getBlockState() {
        return ((ItemEntry)this).getDefaultBlockState();
    }

    public FluidStack getFluidStack() {
        return ((FluidEntry)this).getDefaultFluidStack();
    }

    public boolean canPlaceComponentAtPos(World world, BlockPos pos) {
        return false;
    }

    public boolean isMatchingComponentAtPos(World world, BlockPos pos) {
        return false;
    }

    public void ignoreMeta() {
        this.ignoreMeta = true;
    }

    public int hashCode() {
        return this.globalID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DictionaryEntry) {
            DictionaryEntry info = (DictionaryEntry)obj;
            return info.globalID == this.globalID && info.entryType == this.entryType && info.globalName.equals(this.globalName);
        }
        return super.equals(obj);
    }

    @Nullable
    public static DictionaryEntry readFromNBTSafely(NBTTagCompound compound) {
        if (compound.func_74764_b("type")) {
            DictionaryEntryType type = DictionaryEntryType.getType(compound.func_74771_c("type"));
            if (type.isOverhaul == ReactorBuilder.isOverhaul()) {
                String globalName = compound.func_74779_i("gName");
                DictionaryEntry info = GlobalDictionary.getComponentInfo(globalName);
                if (info != null) {
                    return info;
                }
                return null;
            }
        }
        return null;
    }

    public static NBTTagCompound writeToNBTSafely(NBTTagCompound compound, @Nullable DictionaryEntry component) {
        if (component != null) {
            compound.func_74778_a("gName", component.globalName);
            compound.func_74774_a("type", component.entryType.getID());
        }
        return compound;
    }

    public static ItemEntry makeEdgeComponent(ItemStack itemStack) {
        return new ItemEntry(-1, "edge", DictionaryEntryType.UNDERHAUL_EDGES, Lists.newArrayList((Object[])new ItemStack[]{itemStack.func_77946_l()}));
    }

    public static String toStringList(List<DictionaryEntry> entries) {
        StringBuilder builder = new StringBuilder();
        for (DictionaryEntry entry : entries) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(entry.getDisplayName());
        }
        return builder.toString();
    }

    public static class FluidEntry
    extends DictionaryEntry {
        public FluidStack fluidStack;

        public FluidEntry(int id, String globalName, DictionaryEntryType entryType, FluidStack fluidStack) {
            super(id, globalName, entryType);
            this.fluidStack = fluidStack;
        }

        public FluidStack getDefaultFluidStack() {
            return this.fluidStack;
        }

        @Override
        public String getDisplayName() {
            return this.fluidStack.getLocalizedName();
        }
    }

    public static class ItemEntry
    extends DictionaryEntry {
        public List<ItemStack> validStacks;

        public ItemEntry(int id, String globalName, DictionaryEntryType entryType, List<ItemStack> itemStack) {
            super(id, globalName, entryType);
            this.validStacks = itemStack;
        }

        public ItemStack getDefaultItemStack() {
            return this.validStacks.get(0);
        }

        public IBlockState getDefaultBlockState() {
            Block block = Block.func_149634_a((Item)this.getDefaultItemStack().func_77973_b());
            int metadata = this.getDefaultItemStack().func_77960_j();
            if (this.entryType == DictionaryEntryType.OVERHAUL_TURBINE_BLADE) {
                metadata = 1;
            }
            return block.func_176203_a(metadata);
        }

        @Override
        public boolean isMatchingComponentAtPos(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            IBlockState place = this.getBlockState();
            return place != null && state.func_177230_c() == place.func_177230_c() && (this.ignoreMeta || state.func_177230_c().func_176201_c(state) == place.func_177230_c().func_176201_c(place));
        }

        @Override
        public boolean canPlaceComponentAtPos(World world, BlockPos pos) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return world.func_175623_d(pos) || block.func_176200_f((IBlockAccess)world, pos) || block instanceof BlockLiquid || block instanceof IFluidBlock;
        }

        @Override
        public String getDisplayName() {
            return this.getDefaultItemStack().func_82833_r();
        }
    }
}

