/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.dictionary;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.DictionaryEntryType;
import sonar.reactorbuilder.common.dictionary.OverhaulDictionary;
import sonar.reactorbuilder.common.dictionary.UnderhaulDictionary;

public class GlobalDictionary {
    public static Map<String, DictionaryEntry> GLOBAL_DICTIONARY;
    private static int globalID;
    private static int[] componentTallies;

    public static void initDictionary(boolean isOverhaul) {
        GLOBAL_DICTIONARY = new LinkedHashMap<String, DictionaryEntry>();
        globalID = 0;
        componentTallies = new int[DictionaryEntryType.values().length];
        if (isOverhaul) {
            OverhaulDictionary.buildDictionary();
        } else {
            UnderhaulDictionary.buildDictionary();
        }
        for (DictionaryEntryType type : DictionaryEntryType.values()) {
            if (type.isOverhaul != isOverhaul) continue;
            ReactorBuilder.logger.info("Loaded {} {} types", (Object)componentTallies[type.ordinal()], (Object)type.logName);
        }
    }

    public static void addDictionaryItemEntry(DictionaryEntryType type, String globalName, String modid, String name, int meta) {
        GlobalDictionary.addDictionaryItemEntry(type, globalName, modid, name, meta, false);
    }

    public static void addDictionaryItemEntry(DictionaryEntryType type, String globalName, String modid, String name, int meta, boolean ignoreMeta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name));
        if (item == null) {
            ReactorBuilder.logger.error("Dictionary Error: Missing {} {}, Item: {}:{}:{}", (Object)type, (Object)globalName, (Object)modid, (Object)name, (Object)meta);
            return;
        }
        DictionaryEntry.ItemEntry entry = new DictionaryEntry.ItemEntry(globalID++, globalName, type, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(item, 1, meta)}));
        GLOBAL_DICTIONARY.put(globalName, entry);
        int n = type.ordinal();
        componentTallies[n] = componentTallies[n] + 1;
        if (ignoreMeta) {
            entry.ignoreMeta();
        }
    }

    public static void addDictionaryFluidEntry(DictionaryEntryType type, String globalName, String fluidName) {
        FluidStack fluid = FluidRegistry.getFluidStack((String)fluidName, (int)1000);
        if (fluid == null) {
            ReactorBuilder.logger.error("Dictionary Error: Missing {} {}, Fluid: {}", (Object)type, (Object)globalName, (Object)fluidName);
            return;
        }
        GLOBAL_DICTIONARY.put(globalName, new DictionaryEntry.FluidEntry(globalID++, globalName, type, fluid));
        int n = type.ordinal();
        componentTallies[n] = componentTallies[n] + 1;
    }

    @Nullable
    public static DictionaryEntry getComponentInfo(String globalName) {
        return GLOBAL_DICTIONARY.get(globalName);
    }

    @Nullable
    public static DictionaryEntry getComponentInfoFromID(int globalID) {
        if (globalID == -1) {
            return null;
        }
        for (DictionaryEntry info : GLOBAL_DICTIONARY.values()) {
            if (info.globalID != globalID) continue;
            return info;
        }
        return null;
    }
}

