/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.files;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractFileDictionary {
    private LinkedHashMap<String, String> LOCAL_TO_GLOBAL = new LinkedHashMap();
    private LinkedHashMap<String, String> GLOBAL_TO_LOCAL = new LinkedHashMap();

    public AbstractFileDictionary() {
        this.buildDictionary();
    }

    public final void add(String localName, String globalName) {
        this.LOCAL_TO_GLOBAL.put(localName, globalName);
        this.GLOBAL_TO_LOCAL.put(globalName, localName);
    }

    public final String getGlobalName(String localName) {
        return this.LOCAL_TO_GLOBAL.get(localName);
    }

    public final String getGlobalName(Function<String, Boolean> matches) {
        for (Map.Entry<String, String> entry : this.LOCAL_TO_GLOBAL.entrySet()) {
            if (!matches.apply(entry.getKey()).booleanValue()) continue;
            return entry.getValue();
        }
        return null;
    }

    public final String getLocalName(String localName) {
        return this.GLOBAL_TO_LOCAL.get(localName);
    }

    public final String getLocalName(Function<String, Boolean> matches) {
        for (Map.Entry<String, String> entry : this.GLOBAL_TO_LOCAL.entrySet()) {
            if (!matches.apply(entry.getKey()).booleanValue()) continue;
            return entry.getValue();
        }
        return null;
    }

    public abstract void buildDictionary();
}

