/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.files;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import org.apache.commons.io.IOUtils;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.common.files.AbstractFileReader;
import sonar.reactorbuilder.common.files.ThizNCPFDictionary;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.common.reactors.templates.OverhaulFissionTemplate;

public class HellrageJSONOverhaulReader
extends AbstractFileReader {
    public static final HellrageJSONOverhaulReader INSTANCE = new HellrageJSONOverhaulReader();
    public String error = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AbstractTemplate readTemplate(File file) {
        AbstractTemplate abstractTemplate;
        this.error = "";
        Path path = file.toPath();
        BufferedReader reader = null;
        OverhaulFissionTemplate template = null;
        try {
            reader = Files.newBufferedReader(path);
            String contents = IOUtils.toString((Reader)reader);
            JsonObject json = (JsonObject)JsonUtils.func_188178_a((Gson)new Gson(), (String)contents, JsonObject.class);
            if (json == null) {
                this.error = "Failed to deserialize JSON";
                AbstractTemplate abstractTemplate2 = null;
                return abstractTemplate2;
            }
            JsonObject saveVersion = json.getAsJsonObject("SaveVersion");
            int major = saveVersion.get("Major").getAsInt();
            int minor = saveVersion.get("Minor").getAsInt();
            int build = saveVersion.get("Build").getAsInt();
            if (major != 2 || minor != 1 || build < 1) {
                this.error = String.format("Old JSON version %s.%s.%s", major, minor, build);
                AbstractTemplate abstractTemplate3 = null;
                return abstractTemplate3;
            }
            JsonObject data = json.getAsJsonObject("Data");
            JsonObject dims = data.getAsJsonObject("InteriorDimensions");
            boolean isMSR = true;
            JsonObject testFuelCells = data.getAsJsonObject("FuelCells");
            for (Map.Entry name : testFuelCells.entrySet()) {
                if (((String)name.getKey()).startsWith("[F4]")) continue;
                isMSR = false;
                break;
            }
            OverhaulFissionTemplate fissionTemplate = isMSR ? new OverhaulFissionTemplate.MSR(file.getName(), dims.get("X").getAsInt(), dims.get("Y").getAsInt(), dims.get("Z").getAsInt()) : new OverhaulFissionTemplate.SFR(file.getName(), dims.get("X").getAsInt(), dims.get("Y").getAsInt(), dims.get("Z").getAsInt());
            JsonObject heatSinks = data.getAsJsonObject("HeatSinks");
            for (Object heatSink : heatSinks.entrySet()) {
                DictionaryEntry entry = isMSR ? this.getMatchingCoolantHeater((String)heatSink.getKey()) : this.getMatchingHeatSink((String)heatSink.getKey());
                this.setDictionaryEntryFromCoordinates(entry, fissionTemplate, ((JsonElement)heatSink.getValue()).getAsJsonArray());
            }
            JsonObject moderators = data.getAsJsonObject("Moderators");
            for (Map.Entry moderator : moderators.entrySet()) {
                DictionaryEntry entry = this.getMatchingModerator((String)moderator.getKey());
                this.setDictionaryEntryFromCoordinates(entry, fissionTemplate, ((JsonElement)moderator.getValue()).getAsJsonArray());
            }
            DictionaryEntry conductorEntry = GlobalDictionary.getComponentInfo("conductor");
            JsonArray conductors = data.getAsJsonArray("Conductors");
            this.setDictionaryEntryFromCoordinates(conductorEntry, fissionTemplate, conductors);
            JsonObject reflectors = data.getAsJsonObject("Reflectors");
            for (Object reflector : reflectors.entrySet()) {
                DictionaryEntry entry = this.getMatchingReflector((String)reflector.getKey());
                this.setDictionaryEntryFromCoordinates(entry, fissionTemplate, ((JsonElement)reflector.getValue()).getAsJsonArray());
            }
            JsonObject neutronShields = data.getAsJsonObject("NeutronShields");
            for (Map.Entry neutronShield : neutronShields.entrySet()) {
                DictionaryEntry entry = this.getMatchingNeutronShield((String)neutronShield.getKey());
                this.setDictionaryEntryFromCoordinates(entry, fissionTemplate, ((JsonElement)neutronShield.getValue()).getAsJsonArray());
            }
            DictionaryEntry irradiatorEntry = GlobalDictionary.getComponentInfo("neutron_irradiator");
            JsonObject irradiators = data.getAsJsonObject("Irradiators");
            for (Map.Entry irradiator : irradiators.entrySet()) {
                this.setDictionaryEntryFromCoordinates(irradiatorEntry, fissionTemplate, ((JsonElement)irradiator.getValue()).getAsJsonArray());
            }
            DictionaryEntry fuelVesselEntry = GlobalDictionary.getComponentInfo("fuel_vessel");
            DictionaryEntry fuelCellEntry = GlobalDictionary.getComponentInfo("fuel_cell");
            JsonObject fuelCells = data.getAsJsonObject("FuelCells");
            for (Map.Entry fuelCell : fuelCells.entrySet()) {
                String[] fuelSettings = ((String)fuelCell.getKey()).split(";");
                String fuelName = fuelSettings[0];
                boolean hasSource = Boolean.parseBoolean(fuelSettings[1]);
                DictionaryEntry fuel = this.getMatchingFuel(fuelName);
                if (fuel != null) {
                    this.setFuelRecipeFromCoordinates(fuel, fissionTemplate, ((JsonElement)fuelCell.getValue()).getAsJsonArray());
                } else {
                    ReactorBuilder.logger.error("Missing Fuel Type: " + fuelName);
                }
                this.setDictionaryEntryFromCoordinates(isMSR ? fuelVesselEntry : fuelCellEntry, fissionTemplate, ((JsonElement)fuelCell.getValue()).getAsJsonArray());
                template = fissionTemplate;
            }
        }
        catch (JsonParseException jsonparseexception) {
            this.error = "Error parsing JSON - see log";
            ReactorBuilder.logger.error("Error parsing JSON" + path.toString(), (Throwable)jsonparseexception);
            abstractTemplate = null;
            return abstractTemplate;
        }
        catch (IOException ioexception) {
            this.error = "Error reading JSON - see log";
            ReactorBuilder.logger.error("Error reading reactor file" + path + " from " + file, (Throwable)ioexception);
            abstractTemplate = null;
            return abstractTemplate;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return template;
    }

    public void setDictionaryEntryFromCoordinates(DictionaryEntry entry, AbstractTemplate template, JsonArray array) {
        for (Object blok : array) {
            JsonObject blockLoc = (JsonObject)blok;
            int x = blockLoc.get("X").getAsInt() - 1;
            int y = blockLoc.get("Y").getAsInt() - 1;
            int z = blockLoc.get("Z").getAsInt() - 1;
            template.setComponentInfo(entry, x, y, z);
        }
    }

    public void setFuelRecipeFromCoordinates(DictionaryEntry fuel, OverhaulFissionTemplate template, JsonArray array) {
        template.recipeToIndexMap.putIfAbsent(fuel, new ArrayList());
        for (Object blok : array) {
            JsonObject blockLoc = (JsonObject)blok;
            int x = blockLoc.get("X").getAsInt() - 1;
            int y = blockLoc.get("Y").getAsInt() - 1;
            int z = blockLoc.get("Z").getAsInt() - 1;
            template.recipeToIndexMap.get(fuel).add(template.getIndexFromInternalPos(x, y, z));
        }
    }

    public DictionaryEntry getMatchingHeatSink(String localName) {
        String globalName = ThizNCPFDictionary.INSTANCE.getGlobalName(thizName -> {
            if (!thizName.contains("Heat Sink")) {
                return false;
            }
            String testName = thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").replace("heatsink", "").replace("liquid", "");
            String local = localName.toLowerCase(Locale.ENGLISH).replace(" ", "");
            return testName.equalsIgnoreCase(local);
        });
        return GlobalDictionary.getComponentInfo(globalName);
    }

    public DictionaryEntry getMatchingCoolantHeater(String localName) {
        String globalName = ThizNCPFDictionary.INSTANCE.getGlobalName(thizName -> {
            if (!thizName.contains("Coolant Heater")) {
                return false;
            }
            String testName = thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").replace("coolant", "").replace("heater", "").replace("liquid", "");
            String local = localName.toLowerCase(Locale.ENGLISH).replace("water", "standard").replace(" ", "");
            return testName.equalsIgnoreCase(local);
        });
        return GlobalDictionary.getComponentInfo(globalName);
    }

    public DictionaryEntry getMatchingModerator(String localName) {
        String globalName = ThizNCPFDictionary.INSTANCE.getGlobalName(thizName -> {
            if (!thizName.contains("Moderator")) {
                return false;
            }
            String testName = thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").replace("moderator", "");
            String local = localName.replace(" ", "");
            return testName.equalsIgnoreCase(local);
        });
        return GlobalDictionary.getComponentInfo(globalName);
    }

    public DictionaryEntry getMatchingReflector(String localName) {
        String globalName = ThizNCPFDictionary.INSTANCE.getGlobalName(thizName -> {
            if (!thizName.contains("Reflector")) {
                return false;
            }
            String testName = thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").replace("reflector", "");
            String local = localName.replace(" ", "");
            return testName.equalsIgnoreCase(local);
        });
        return GlobalDictionary.getComponentInfo(globalName);
    }

    public DictionaryEntry getMatchingNeutronShield(String localName) {
        String globalName = ThizNCPFDictionary.INSTANCE.getGlobalName(thizName -> {
            if (!thizName.contains("Neutron Shield")) {
                return false;
            }
            String testName = thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").replace("neutronshield", "").replace("shield", "");
            String local = localName.replace(" ", "");
            return testName.equalsIgnoreCase(local);
        });
        return GlobalDictionary.getComponentInfo(globalName);
    }

    public DictionaryEntry getMatchingFuel(String localName) {
        String globalName = ThizNCPFDictionary.INSTANCE.getGlobalName(thizName -> {
            if (thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").equalsIgnoreCase(localName.substring(4).replace(" ", ""))) {
                return true;
            }
            String appendName = localName;
            if (localName.startsWith("[OX]")) {
                appendName = appendName.substring(4) + " Oxide";
            }
            if (localName.startsWith("[NI]")) {
                appendName = appendName.substring(4) + " Nitride";
            }
            if (localName.startsWith("[ZA]")) {
                appendName = appendName.substring(4) + "-Zirconium Alloy";
            }
            if (localName.startsWith("[F4]")) {
                appendName = appendName.substring(4) + " Fluoride";
            }
            return thizName.toLowerCase(Locale.ENGLISH).replace(" ", "").equalsIgnoreCase(appendName.replace(" ", ""));
        });
        return GlobalDictionary.getComponentInfo(globalName);
    }
}

