/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.files;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import org.apache.commons.io.IOUtils;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.common.files.AbstractFileReader;
import sonar.reactorbuilder.common.files.HellrageJSONDictionary;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.common.reactors.templates.UnderhaulSFRTemplate;

public class HellrageJSONUnderhaulReader
extends AbstractFileReader {
    public static final HellrageJSONUnderhaulReader INSTANCE = new HellrageJSONUnderhaulReader();
    public String error = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AbstractTemplate readTemplate(File file) {
        AbstractTemplate abstractTemplate;
        this.error = "";
        Path path = file.toPath();
        BufferedReader reader = null;
        UnderhaulSFRTemplate template = null;
        try {
            reader = Files.newBufferedReader(path);
            String contents = IOUtils.toString((Reader)reader);
            JsonObject json = (JsonObject)JsonUtils.func_188178_a((Gson)new Gson(), (String)contents, JsonObject.class);
            if (json == null) {
                this.error = "Failed to deserialize JSON";
                AbstractTemplate abstractTemplate2 = null;
                return abstractTemplate2;
            }
            JsonObject saveVersion = json.getAsJsonObject("SaveVersion");
            int major = saveVersion.get("Major").getAsInt();
            int minor = saveVersion.get("Minor").getAsInt();
            int build = saveVersion.get("Build").getAsInt();
            if (major != 1 || minor != 2 || build < 23) {
                this.error = String.format("Old JSON version %s.%s.%s", major, minor, build);
                AbstractTemplate abstractTemplate3 = null;
                return abstractTemplate3;
            }
            JsonObject dims = json.getAsJsonObject("InteriorDimensions");
            JsonObject usedFuel = json.getAsJsonObject("UsedFuel");
            String fuelName = usedFuel.get("Name").getAsString();
            String fuelGlobalName = HellrageJSONDictionary.INSTANCE.getGlobalName(fuelName);
            DictionaryEntry fuelInfo = GlobalDictionary.getComponentInfo(fuelGlobalName);
            if (fuelInfo == null) {
                ReactorBuilder.logger.error("Missing Fuel Type: " + fuelName);
            }
            UnderhaulSFRTemplate sfr = new UnderhaulSFRTemplate(file.getName(), dims.get("X").getAsInt(), dims.get("Y").getAsInt(), dims.get("Z").getAsInt(), fuelInfo);
            JsonObject compressedReactor = json.getAsJsonObject("CompressedReactor");
            for (Map.Entry elementEntry : compressedReactor.entrySet()) {
                String globalName = HellrageJSONDictionary.INSTANCE.getGlobalName((String)elementEntry.getKey());
                DictionaryEntry info = GlobalDictionary.getComponentInfo(globalName);
                if (info != null) {
                    JsonArray array = ((JsonElement)elementEntry.getValue()).getAsJsonArray();
                    for (JsonElement locElement : array) {
                        JsonObject locObject = locElement.getAsJsonObject();
                        int x = locObject.get("X").getAsInt() - 1;
                        int y = locObject.get("Y").getAsInt() - 1;
                        int z = locObject.get("Z").getAsInt() - 1;
                        sfr.setComponentInfo(info, x, y, z);
                    }
                    continue;
                }
                ReactorBuilder.logger.error("Missing Component Type: " + (String)elementEntry.getKey());
            }
            template = sfr;
        }
        catch (JsonParseException jsonparseexception) {
            this.error = "Error parsing JSON - see log";
            ReactorBuilder.logger.error("Error parsing JSON" + path.toString(), (Throwable)jsonparseexception);
            abstractTemplate = null;
            return abstractTemplate;
        }
        catch (IOException ioexception) {
            this.error = "Error reading JSON - see log";
            ReactorBuilder.logger.error("Error reading reactor file" + path + " from " + file, (Throwable)ioexception);
            abstractTemplate = null;
            return abstractTemplate;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return template;
    }
}

