/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.reactors.templates;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.reactorbuilder.ReactorBuilder;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.common.reactors.TemplateType;
import sonar.reactorbuilder.util.Util;

public abstract class AbstractTemplate {
    public int templateID;
    public String fileName;
    public int xSize;
    public int ySize;
    public int zSize;
    public DictionaryEntry[][][] blocks;
    public boolean[] caseConfig = new boolean[7];
    public Map<DictionaryEntry, Integer> required = new HashMap<DictionaryEntry, Integer>();
    public int totalSolidComponents;
    public int totalAirComponents;
    public int totalSolidCasing;
    public int totalGlassCasing;
    public int totalEdges;
    public Object bufferState3D;
    public Object bufferState2D;
    public List<Integer> highlights = new ArrayList<Integer>();
    protected BlockPos internalStart;
    protected BlockPos internalEnd;
    protected BlockPos casingStart;
    protected BlockPos casingEnd;

    public AbstractTemplate() {
    }

    public AbstractTemplate(String fileName, int xSize, int ySize, int zSize) {
        this.fileName = fileName;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.blocks = new DictionaryEntry[xSize][ySize][zSize];
    }

    public abstract TemplateType getTemplateType();

    @Nullable
    public abstract DictionaryEntry getComponent(int var1, int var2, int var3);

    public void setComponentInfo(DictionaryEntry info, int xPos, int yPos, int zPos) {
        this.blocks[xPos][yPos][zPos] = info;
    }

    public boolean isComponent(int x, int y, int z) {
        return this.getIntStart().func_177958_n() <= x && x <= this.getIntEnd().func_177958_n() && this.getIntStart().func_177956_o() <= y && y <= this.getIntEnd().func_177956_o() && this.getIntStart().func_177952_p() <= z && z <= this.getIntEnd().func_177952_p();
    }

    public boolean isCasing(int x, int y, int z) {
        return !this.isComponent(x, y, z) && !this.isEdge(x, y, z);
    }

    public boolean isEdge(int x, int y, int z) {
        boolean xEdge = x == this.getExtStart().func_177958_n() || x == this.getExtEnd().func_177958_n();
        boolean yEdge = y == this.getExtStart().func_177956_o() || y == this.getExtEnd().func_177956_o();
        boolean zEdge = z == this.getExtStart().func_177952_p() || z == this.getExtEnd().func_177952_p();
        return xEdge && yEdge || xEdge && zEdge || yEdge && zEdge;
    }

    public boolean isCasingGlass(int x, int y, int z) {
        if (this.isEdge(x, y, z)) {
            return this.caseConfig[6];
        }
        if (this.isCasing(x, y, z)) {
            EnumFacing face = null;
            if (x == this.getExtStart().func_177958_n()) {
                face = EnumFacing.WEST;
            } else if (x == this.getExtEnd().func_177958_n()) {
                face = EnumFacing.EAST;
            } else if (y == this.getExtStart().func_177956_o()) {
                face = EnumFacing.DOWN;
            } else if (y == this.getExtEnd().func_177956_o()) {
                face = EnumFacing.UP;
            } else if (z == this.getExtStart().func_177952_p()) {
                face = EnumFacing.NORTH;
            } else if (z == this.getExtEnd().func_177952_p()) {
                face = EnumFacing.SOUTH;
            }
            return face != null && this.caseConfig[face.ordinal()];
        }
        return false;
    }

    public abstract int getBuildPasses();

    public abstract String[] getBuildPassNames();

    public abstract int getBuildPassTotal(int var1);

    public abstract boolean canPlaceThisPass(int var1, int var2, int var3, int var4, DictionaryEntry var5);

    public boolean isCustomPass(int buildPass) {
        return false;
    }

    public void tickCustomPass(ReactorBuilderTileEntity builder, int buildPass) {
    }

    public abstract DictionaryEntry getDefaultSolidCasing();

    public abstract DictionaryEntry getDefaultGlassCasing();

    public abstract void getStats(Map<String, String> var1);

    public void updateAdditionalInfo() {
        this.required = new HashMap<DictionaryEntry, Integer>();
        this.totalSolidComponents = 0;
        this.totalAirComponents = 0;
        this.totalSolidCasing = 0;
        this.totalGlassCasing = 0;
        this.totalEdges = 0;
        for (int x = this.getExtStart().func_177958_n(); x <= this.getExtEnd().func_177958_n(); ++x) {
            for (int y = this.getExtStart().func_177956_o(); y <= this.getExtEnd().func_177956_o(); ++y) {
                for (int z = this.getExtStart().func_177952_p(); z <= this.getExtEnd().func_177952_p(); ++z) {
                    if (this.isComponent(x, y, z)) {
                        DictionaryEntry componentInfo = this.blocks[x][y][z];
                        if (componentInfo != null) {
                            Integer total = this.required.get(componentInfo);
                            this.required.put(componentInfo, (total == null ? 0 : total) + 1);
                            ++this.totalSolidComponents;
                            continue;
                        }
                        ++this.totalAirComponents;
                        continue;
                    }
                    if (this.isCasing(x, y, z)) {
                        if (this.isCasingGlass(x, y, z)) {
                            ++this.totalGlassCasing;
                            continue;
                        }
                        ++this.totalSolidCasing;
                        continue;
                    }
                    if (!this.isEdge(x, y, z)) continue;
                    ++this.totalEdges;
                }
            }
        }
    }

    public void sortAdditionalInfo() {
        this.required = this.required.entrySet().stream().sorted((c1, c2) -> -((Integer)c1.getValue()).compareTo((Integer)c2.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    public BlockPos getIntStart() {
        if (this.internalStart != null) {
            return this.internalStart;
        }
        this.internalStart = new BlockPos(0, 0, 0);
        return this.internalStart;
    }

    public BlockPos getIntEnd() {
        if (this.internalEnd != null) {
            return this.internalEnd;
        }
        this.internalEnd = new BlockPos(this.xSize - 1, this.ySize - 1, this.zSize - 1);
        return this.internalEnd;
    }

    public BlockPos getExtStart() {
        if (this.casingStart != null) {
            return this.casingStart;
        }
        this.casingStart = new BlockPos(-1, -1, -1);
        return this.casingStart;
    }

    public BlockPos getExtEnd() {
        if (this.casingEnd != null) {
            return this.casingEnd;
        }
        this.casingEnd = new BlockPos(this.xSize, this.ySize, this.zSize);
        return this.casingEnd;
    }

    public BlockPos getStartPos(ReactorBuilderTileEntity tileEntity) {
        EnumFacing front = EnumFacing.func_82600_a((int)tileEntity.func_145832_p());
        BlockPos startPos = tileEntity.func_174877_v().func_177967_a(front.func_176734_d(), 2).func_177967_a(EnumFacing.UP, 1).func_177967_a(front.func_176746_e().func_176734_d(), 2);
        switch (front) {
            case NORTH: {
                startPos = startPos.func_177982_a(1 - this.xSize, 0, 0);
                break;
            }
            case SOUTH: {
                startPos = startPos.func_177982_a(0, 0, 1 - this.zSize);
                break;
            }
            case WEST: {
                startPos = startPos.func_177982_a(0, 0, 0);
                break;
            }
            case EAST: {
                startPos = startPos.func_177982_a(1 - this.xSize, 0, 1 - this.zSize);
            }
        }
        return startPos;
    }

    public int getIndexFromInternalPos(int xPos, int yPos, int zPos) {
        return xPos * this.ySize * this.zSize + yPos * this.zSize + zPos;
    }

    public BlockPos getPosFromIndexLoop(int index) {
        int i = 0;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    if (i == index) {
                        return new BlockPos(x, y, z);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public BlockPos getPosFromIndexCalc(int index) {
        int xPos = index / (this.ySize * this.zSize);
        int yPos = (index -= xPos * this.ySize * this.zSize) / this.zSize;
        int zPos = index - yPos * this.zSize;
        return new BlockPos(xPos, yPos, zPos);
    }

    public int getIndexSize() {
        return this.xSize * this.ySize * this.zSize;
    }

    @Nullable
    public static AbstractTemplate readTemplateFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("template")) {
            NBTTagCompound templateTag = compound.func_74775_l("template");
            TemplateType type = TemplateType.values()[templateTag.func_74771_c("type")];
            if (type.overhaul == ReactorBuilder.isOverhaul()) {
                AbstractTemplate template = type.creator.create();
                template.readFromNBT(templateTag, true);
                template.updateAdditionalInfo();
                template.sortAdditionalInfo();
                return template;
            }
            return null;
        }
        return null;
    }

    public static void writeTemplateToNBT(NBTTagCompound compound, @Nullable AbstractTemplate template) {
        if (template != null) {
            NBTTagCompound templateTag = new NBTTagCompound();
            templateTag.func_74774_a("type", (byte)template.getTemplateType().ordinal());
            template.writeToNBT(templateTag, true);
            compound.func_74782_a("template", (NBTBase)templateTag);
        }
    }

    public void readFromNBT(NBTTagCompound compound, boolean array) {
        this.templateID = compound.func_74762_e("templateID");
        this.fileName = compound.func_74779_i("fileName");
        this.xSize = compound.func_74762_e("xSize");
        this.ySize = compound.func_74762_e("ySize");
        this.zSize = compound.func_74762_e("zSize");
        this.caseConfig = Util.getBooleanArrayFromByteArray(compound.func_74770_j("caseConfig"), 7);
        if (!array) {
            return;
        }
        this.blocks = new DictionaryEntry[this.xSize][this.ySize][this.zSize];
        HashMap<Integer, DictionaryEntry> refs = new HashMap<Integer, DictionaryEntry>();
        NBTTagList list = compound.func_150295_c("refs", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound componentTag = list.func_150305_b(i);
            DictionaryEntry info = DictionaryEntry.readFromNBTSafely(componentTag);
            int oldID = componentTag.func_74762_e("oldID");
            refs.put(oldID, info);
        }
        int[] blockArray = compound.func_74759_k("blocks");
        int count = 0;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    this.blocks[x][y][z] = (DictionaryEntry)refs.get(blockArray[count]);
                    ++count;
                }
            }
        }
    }

    public void writeToNBT(NBTTagCompound compound, boolean array) {
        compound.func_74768_a("templateID", this.templateID);
        compound.func_74778_a("fileName", this.fileName);
        compound.func_74768_a("xSize", this.xSize);
        compound.func_74768_a("ySize", this.ySize);
        compound.func_74768_a("zSize", this.zSize);
        compound.func_74773_a("caseConfig", Util.getByteArrayFromBooleanArray(this.caseConfig, 7));
        if (!array) {
            return;
        }
        if (this.required.isEmpty()) {
            this.updateAdditionalInfo();
            this.sortAdditionalInfo();
        }
        NBTTagList list = new NBTTagList();
        for (DictionaryEntry info : this.required.keySet()) {
            NBTTagCompound componentTag = new NBTTagCompound();
            DictionaryEntry.writeToNBTSafely(componentTag, info);
            componentTag.func_74768_a("oldID", info.globalID);
            list.func_74742_a((NBTBase)componentTag);
        }
        compound.func_74782_a("refs", (NBTBase)list);
        int[] blockArray = new int[this.xSize * this.ySize * this.zSize];
        int count = 0;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    DictionaryEntry componentInfo = this.blocks[x][y][z];
                    blockArray[count] = componentInfo == null ? -1 : componentInfo.globalID;
                    ++count;
                }
            }
        }
        compound.func_74783_a("blocks", blockArray);
    }

    @Nullable
    public static AbstractTemplate readTemplateHeaderFromByteBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            TemplateType type = TemplateType.values()[buf.readByte()];
            AbstractTemplate template = type.creator.create();
            template.readHeaderFromBuf(buf);
            return template;
        }
        return null;
    }

    @Nullable
    public static void writeTemplateHeaderToByteBuf(ByteBuf buf, AbstractTemplate template) {
        buf.writeBoolean(template != null);
        if (template != null) {
            buf.writeByte((int)((byte)template.getTemplateType().ordinal()));
            template.writeHeaderToBuf(buf);
        }
    }

    public void readHeaderFromBuf(ByteBuf buf) {
        NBTTagCompound headerTag = ByteBufUtils.readTag((ByteBuf)buf);
        this.readFromNBT(headerTag, false);
    }

    public void writeHeaderToBuf(ByteBuf buf) {
        NBTTagCompound headerTag = new NBTTagCompound();
        this.writeToNBT(headerTag, false);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)headerTag);
    }

    public void readPayloadFromBuf(ByteBuf buf, int start, int end) {
        if (start == 0) {
            this.blocks = new DictionaryEntry[this.xSize][this.ySize][this.zSize];
        }
        int index = 0;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    if (start <= index && index < end) {
                        this.blocks[x][y][z] = GlobalDictionary.getComponentInfoFromID(buf.readShort());
                    }
                    ++index;
                }
            }
        }
    }

    public void writePayloadToBuf(ByteBuf buf, int start, int end) {
        int index = 0;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    if (start <= index && index < end) {
                        DictionaryEntry componentInfo = this.blocks[x][y][z];
                        buf.writeShort(componentInfo == null ? -1 : componentInfo.globalID);
                    }
                    ++index;
                }
            }
        }
    }
}

