/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.reactors.templates;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.DictionaryEntryType;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.common.reactors.TemplateType;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.registry.RBConfig;
import sonar.reactorbuilder.util.OverhaulHelper;
import sonar.reactorbuilder.util.Translate;

public abstract class OverhaulFissionTemplate
extends AbstractTemplate {
    public static DictionaryEntry casingSolid = GlobalDictionary.getComponentInfo("sfr_casing");
    public static DictionaryEntry casingGlass = GlobalDictionary.getComponentInfo("sfr_glass");
    public Map<DictionaryEntry, List<Integer>> recipeToIndexMap = new HashMap<DictionaryEntry, List<Integer>>();
    public int totalRecipes;
    public List<DictionaryEntry> fuels;
    public List<DictionaryEntry> recipes;
    public String fuelNameList;
    public String recipeNameList;

    public OverhaulFissionTemplate() {
    }

    public OverhaulFissionTemplate(String fileName, int xSize, int ySize, int zSize) {
        super(fileName, xSize, ySize, zSize);
    }

    @Override
    @Nullable
    public DictionaryEntry getComponent(int x, int y, int z) {
        if (this.isComponent(x, y, z)) {
            return this.blocks[x][y][z];
        }
        if (this.isCasing(x, y, z) || this.isEdge(x, y, z)) {
            return this.isCasingGlass(x, y, z) ? casingGlass : casingSolid;
        }
        return null;
    }

    @Override
    public int getBuildPasses() {
        return 3;
    }

    @Override
    public String[] getBuildPassNames() {
        return new String[]{Translate.PASS_PLACING_COMPONENTS.t(), Translate.PASS_SETTING_FILTERS.t(), Translate.PASS_PLACING_CASINGS.t()};
    }

    @Override
    public int getBuildPassTotal(int buildPass) {
        switch (buildPass) {
            case 0: {
                return this.totalSolidComponents;
            }
            case 1: {
                return this.totalRecipes;
            }
            case 2: {
                return this.totalGlassCasing + this.totalSolidCasing + this.totalEdges;
            }
        }
        return 0;
    }

    @Override
    public boolean canPlaceThisPass(int buildPass, int x, int y, int z, DictionaryEntry info) {
        switch (buildPass) {
            case 0: {
                return info.entryType == DictionaryEntryType.OVERHAUL_COMPONENT;
            }
            case 1: {
                return false;
            }
            case 2: {
                return info.entryType == DictionaryEntryType.OVERHAUL_CASING_SOLID || info.entryType == DictionaryEntryType.OVERHAUL_CASING_GLASS;
            }
        }
        return false;
    }

    @Override
    public boolean isCustomPass(int buildPass) {
        return buildPass == 1;
    }

    @Override
    public void tickCustomPass(ReactorBuilderTileEntity builder, int buildPass) {
        super.tickCustomPass(builder, buildPass);
        if (buildPass == 1) {
            int index = 0;
            for (Map.Entry<DictionaryEntry, List<Integer>> map : this.recipeToIndexMap.entrySet()) {
                DictionaryEntry input = map.getKey();
                if ((input.entryType == DictionaryEntryType.OVERHAUL_FUEL || input.entryType == DictionaryEntryType.OVERHAUL_LIQUID_FUEL) && this.fuels.size() == 1) {
                    builder.passProgress[buildPass] = index += map.getValue().size();
                    continue;
                }
                if (input.entryType == DictionaryEntryType.IRRADIATOR_RECIPE && this.recipes.size() == 1) {
                    builder.passProgress[buildPass] = index += map.getValue().size();
                    continue;
                }
                for (Integer i : map.getValue()) {
                    TileEntity tile;
                    if (++index <= builder.passProgress[buildPass]) continue;
                    int n = buildPass;
                    builder.passProgress[n] = builder.passProgress[n] + 1;
                    BlockPos pos = this.getPosFromIndexLoop(i);
                    DictionaryEntry info = this.getComponent(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    BlockPos nextPos = builder.getStartPos().func_177971_a((Vec3i)pos);
                    if (info == null || !builder.isMatchingComponentAtPos(info, nextPos)) continue;
                    if (RBConfig.allowFuelCellFiltering && info.globalName.equals("fuel_cell")) {
                        tile = builder.func_145831_w().func_175625_s(nextPos);
                        OverhaulHelper.setItemStackFilter(tile, input.getItemStack());
                        continue;
                    }
                    if (RBConfig.allowIrradiatorFiltering && info.globalName.equals("neutron_irradiator")) {
                        tile = builder.func_145831_w().func_175625_s(nextPos);
                        OverhaulHelper.setItemStackFilter(tile, input.getItemStack());
                        continue;
                    }
                    if (!RBConfig.allowFuelVesselFiltering || !info.globalName.equals("fuel_vessel")) continue;
                    tile = builder.func_145831_w().func_175625_s(nextPos);
                    OverhaulHelper.setFluidStackFilter(tile, input.getFluidStack());
                }
            }
        }
    }

    @Override
    public DictionaryEntry getDefaultSolidCasing() {
        return casingSolid;
    }

    @Override
    public DictionaryEntry getDefaultGlassCasing() {
        return casingGlass;
    }

    @Override
    public void updateAdditionalInfo() {
        super.updateAdditionalInfo();
        if (this.totalSolidCasing + this.totalEdges != 0) {
            this.required.put(casingSolid, this.totalSolidCasing + this.totalEdges);
        }
        if (this.totalGlassCasing != 0) {
            this.required.put(casingGlass, this.totalGlassCasing);
        }
        this.totalRecipes = 0;
        this.fuels = new ArrayList<DictionaryEntry>();
        this.recipes = new ArrayList<DictionaryEntry>();
        for (Map.Entry<DictionaryEntry, List<Integer>> map : this.recipeToIndexMap.entrySet()) {
            if (map.getKey().entryType == DictionaryEntryType.OVERHAUL_FUEL || map.getKey().entryType == DictionaryEntryType.OVERHAUL_LIQUID_FUEL) {
                this.fuels.add(map.getKey());
            }
            if (map.getKey().entryType == DictionaryEntryType.IRRADIATOR_RECIPE) {
                this.recipes.add(map.getKey());
            }
            this.totalRecipes += map.getValue().size();
        }
        this.fuelNameList = DictionaryEntry.toStringList(this.fuels);
        this.recipeNameList = DictionaryEntry.toStringList(this.recipes);
    }

    @Override
    public void getStats(Map<String, String> statsMap) {
        statsMap.put(Translate.TEMPLATE_FILE_NAME.t(), this.fileName);
        statsMap.put(Translate.TEMPLATE_REACTOR_TYPE.t(), this.getTemplateType().fileType);
        statsMap.put(Translate.TEMPLATE_DIMENSIONS.t(), this.xSize + " x " + this.ySize + " x " + this.zSize);
        statsMap.put(Translate.TEMPLATE_FUEL_TYPES.t(), this.fuelNameList);
        statsMap.put(Translate.TEMPLATE_IRRADIATOR_FILTERS.t(), this.recipeNameList);
        statsMap.put(Translate.TEMPLATE_COMPONENTS.t(), String.valueOf(this.totalSolidComponents));
        statsMap.put(Translate.CASING_CONFIG.t(), String.valueOf(this.totalSolidCasing + this.totalGlassCasing + this.totalEdges));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound, boolean array) {
        super.readFromNBT(compound, array);
        if (!array) {
            return;
        }
        this.recipeToIndexMap.clear();
        NBTTagList fuelMapList = compound.func_150295_c("recipeMap", 10);
        for (int i = 0; i < fuelMapList.func_74745_c(); ++i) {
            NBTTagCompound fuelCompound = fuelMapList.func_150305_b(i);
            DictionaryEntry fuelInfo = DictionaryEntry.readFromNBTSafely(fuelCompound);
            int[] indexes = fuelCompound.func_74759_k("indexes");
            List indexList = Arrays.stream(indexes).boxed().collect(Collectors.toList());
            this.recipeToIndexMap.putIfAbsent(fuelInfo, indexList);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound, boolean array) {
        super.writeToNBT(compound, array);
        if (!array) {
            return;
        }
        NBTTagList fuelMapList = new NBTTagList();
        for (Map.Entry<DictionaryEntry, List<Integer>> entry : this.recipeToIndexMap.entrySet()) {
            NBTTagCompound fuelCompound = new NBTTagCompound();
            DictionaryEntry.writeToNBTSafely(fuelCompound, entry.getKey());
            int[] indexes = entry.getValue().stream().mapToInt(i -> i).toArray();
            fuelCompound.func_74783_a("indexes", indexes);
            fuelMapList.func_74742_a((NBTBase)fuelCompound);
        }
        compound.func_74782_a("recipeMap", (NBTBase)fuelMapList);
    }

    @Override
    public void readHeaderFromBuf(ByteBuf buf) {
        super.readHeaderFromBuf(buf);
        this.recipeToIndexMap.clear();
        int mapSize = buf.readInt();
        for (int f = 0; f < mapSize; ++f) {
            DictionaryEntry fuel = GlobalDictionary.getComponentInfoFromID(buf.readShort());
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int indexSize = buf.readInt();
            for (int i = 0; i < indexSize; ++i) {
                indexes.add(buf.readInt());
            }
            this.recipeToIndexMap.putIfAbsent(fuel, indexes);
        }
    }

    @Override
    public void writeHeaderToBuf(ByteBuf buf) {
        super.writeHeaderToBuf(buf);
        buf.writeInt(this.recipeToIndexMap.size());
        for (Map.Entry<DictionaryEntry, List<Integer>> entry : this.recipeToIndexMap.entrySet()) {
            buf.writeShort(entry.getKey().globalID);
            buf.writeInt(entry.getValue().size());
            for (Integer i : entry.getValue()) {
                buf.writeInt(i.intValue());
            }
        }
    }

    public static class MSR
    extends OverhaulFissionTemplate {
        public MSR() {
        }

        public MSR(String fileName, int xSize, int ySize, int zSize) {
            super(fileName, xSize, ySize, zSize);
        }

        @Override
        public TemplateType getTemplateType() {
            return TemplateType.OVERHAUL_MSR;
        }
    }

    public static class SFR
    extends OverhaulFissionTemplate {
        public SFR() {
        }

        public SFR(String fileName, int xSize, int ySize, int zSize) {
            super(fileName, xSize, ySize, zSize);
        }

        @Override
        public TemplateType getTemplateType() {
            return TemplateType.OVERHAUL_SFR;
        }
    }
}

