/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.reactors.templates;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import sonar.reactorbuilder.common.ReactorBuilderTileEntity;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.DictionaryEntryType;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.common.reactors.TemplateType;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.util.Translate;

public class OverhaulTurbine
extends AbstractTemplate {
    public static DictionaryEntry casingSolid = GlobalDictionary.getComponentInfo("turbine_casing");
    public static DictionaryEntry casingGlass = GlobalDictionary.getComponentInfo("turbine_glass");
    public int bearingDiameter;
    public int totalCoils;
    public int totalShafts;
    public int totalBlades;

    public OverhaulTurbine() {
    }

    public OverhaulTurbine(String fileName, int diameter, int length, int bearingDiameter) {
        super(fileName, diameter, diameter, length + 2);
        this.bearingDiameter = bearingDiameter;
    }

    @Override
    public TemplateType getTemplateType() {
        return TemplateType.OVERHAUL_TURBINE;
    }

    @Override
    @Nullable
    public DictionaryEntry getComponent(int x, int y, int z) {
        if (this.isComponent(x, y, z)) {
            return this.blocks[x][y][z];
        }
        if (this.isCasing(x, y, z)) {
            return this.isCasingGlass(x, y, z) ? casingGlass : casingSolid;
        }
        return null;
    }

    public void setCoilExact(DictionaryEntry entry, int x, int y, int z) {
        if (z == 1) {
            z = this.zSize - 1;
        }
        this.setComponentInfo(entry, x, y, z);
    }

    public void setBladeExact(DictionaryEntry entry, int z) {
        int minD = this.xSize / 2 - this.bearingDiameter / 2;
        int maxD = this.xSize - minD - 1;
        for (int X = 0; X < this.xSize; ++X) {
            for (int Y = 0; Y < this.ySize; ++Y) {
                if (X >= minD && Y >= minD && X <= maxD && Y <= maxD || X < minD && Y < minD || X < minD && Y > maxD || X > maxD && Y < minD || X > maxD && Y > maxD) continue;
                this.setComponentInfo(entry, X, Y, z);
            }
        }
    }

    @Override
    public boolean isCasing(int x, int y, int z) {
        return !this.isCoil(x, y, z) && (-1 >= x || x >= this.xSize || -1 >= y || y >= this.ySize || -1 >= z || z >= this.zSize) && -1 < z && z < this.zSize;
    }

    public boolean isBlade(int x, int y, int z) {
        if (!this.isComponent(x, y, z)) {
            return false;
        }
        return z != 0 && z != this.zSize - 1 && !this.isShaft(x, y, z);
    }

    public boolean isShaft(int x, int y, int z) {
        if (!this.isComponent(x, y, z)) {
            return false;
        }
        DictionaryEntry component = this.blocks[x][y][z];
        return component != null && component.globalName.equals("rotor_shaft");
    }

    public boolean isCoil(int x, int y, int z) {
        if (!this.isComponent(x, y, z)) {
            return false;
        }
        return (z == 0 || z == this.zSize - 1) && x < this.xSize && y < this.ySize;
    }

    @Override
    public int getBuildPasses() {
        return 4;
    }

    @Override
    public String[] getBuildPassNames() {
        return new String[]{Translate.PASS_PLACING_COILS.t(), Translate.PASS_PLACING_SHAFTS.t(), Translate.PASS_PLACING_BLADES.t(), Translate.PASS_PLACING_CASINGS.t()};
    }

    @Override
    public int getBuildPassTotal(int buildPass) {
        switch (buildPass) {
            case 0: {
                return this.totalCoils;
            }
            case 1: {
                return this.totalShafts;
            }
            case 2: {
                return this.totalBlades;
            }
            case 3: {
                return this.totalGlassCasing + this.totalSolidCasing;
            }
        }
        return 1;
    }

    @Override
    public boolean canPlaceThisPass(int buildPass, int x, int y, int z, DictionaryEntry info) {
        switch (buildPass) {
            case 0: {
                return this.isCoil(x, y, z);
            }
            case 1: {
                return this.isShaft(x, y, z);
            }
            case 2: {
                return this.isBlade(x, y, z);
            }
            case 3: {
                return this.isCasing(x, y, z);
            }
        }
        return info.entryType == DictionaryEntryType.OVERHAUL_COMPONENT;
    }

    @Override
    public BlockPos getExtStart() {
        if (this.casingStart != null) {
            return this.casingStart;
        }
        this.casingStart = new BlockPos(-1, -1, 0);
        return this.casingStart;
    }

    @Override
    public BlockPos getExtEnd() {
        if (this.casingEnd != null) {
            return this.casingEnd;
        }
        this.casingEnd = new BlockPos(this.xSize, this.ySize, this.zSize - 1);
        return this.casingEnd;
    }

    @Override
    public BlockPos getStartPos(ReactorBuilderTileEntity tileEntity) {
        EnumFacing front = EnumFacing.func_82600_a((int)tileEntity.func_145832_p());
        return super.getStartPos(tileEntity).func_177967_a(front.func_176746_e().func_176734_d(), -1);
    }

    @Override
    public DictionaryEntry getDefaultSolidCasing() {
        return casingSolid;
    }

    @Override
    public DictionaryEntry getDefaultGlassCasing() {
        return casingGlass;
    }

    @Override
    public void updateAdditionalInfo() {
        super.updateAdditionalInfo();
        this.totalCoils = 0;
        this.totalShafts = 0;
        this.totalBlades = 0;
        this.totalGlassCasing = 0;
        this.totalSolidCasing = 0;
        for (int x = -1; x <= this.xSize; ++x) {
            for (int y = -1; y <= this.ySize; ++y) {
                for (int z = -1; z <= this.zSize; ++z) {
                    if (this.isComponent(x, y, z)) {
                        DictionaryEntry componentInfo = this.blocks[x][y][z];
                        if (componentInfo == null) continue;
                        if (this.isCoil(x, y, z)) {
                            ++this.totalCoils;
                            continue;
                        }
                        if (this.isShaft(x, y, z)) {
                            ++this.totalShafts;
                            continue;
                        }
                        if (!this.isBlade(x, y, z)) continue;
                        ++this.totalBlades;
                        continue;
                    }
                    if (!this.isCasing(x, y, z)) continue;
                    if (this.isCasingGlass(x, y, z)) {
                        ++this.totalGlassCasing;
                        continue;
                    }
                    ++this.totalSolidCasing;
                }
            }
        }
        if (this.totalSolidCasing != 0) {
            this.required.put(casingSolid, this.totalSolidCasing);
        }
        if (this.totalGlassCasing != 0) {
            this.required.put(casingGlass, this.totalGlassCasing);
        }
    }

    @Override
    public void getStats(Map<String, String> statsMap) {
        statsMap.put(Translate.TEMPLATE_FILE_NAME.t(), this.fileName);
        statsMap.put(Translate.TEMPLATE_REACTOR_TYPE.t(), this.getTemplateType().fileType);
        statsMap.put(Translate.TEMPLATE_DIMENSIONS.t(), this.xSize + " x " + this.ySize + " x " + this.zSize);
        statsMap.put(Translate.TEMPLATE_COMPONENTS.t(), String.valueOf(this.totalSolidComponents));
        statsMap.put(Translate.TEMPLATE_CASING.t(), String.valueOf(this.totalSolidCasing + this.totalGlassCasing));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound, boolean array) {
        super.readFromNBT(compound, array);
        this.bearingDiameter = compound.func_74762_e("diameter");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound, boolean array) {
        super.writeToNBT(compound, array);
        compound.func_74768_a("diameter", this.bearingDiameter);
    }

    @Override
    public void readHeaderFromBuf(ByteBuf buf) {
        super.readHeaderFromBuf(buf);
        this.bearingDiameter = buf.readInt();
    }

    @Override
    public void writeHeaderToBuf(ByteBuf buf) {
        super.writeHeaderToBuf(buf);
        buf.writeInt(this.bearingDiameter);
    }
}

