/*
 * Decompiled with CFR 0.152.
 */
package sonar.reactorbuilder.common.reactors.templates;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.reactorbuilder.common.dictionary.DictionaryEntry;
import sonar.reactorbuilder.common.dictionary.DictionaryEntryType;
import sonar.reactorbuilder.common.dictionary.GlobalDictionary;
import sonar.reactorbuilder.common.reactors.TemplateType;
import sonar.reactorbuilder.common.reactors.templates.AbstractTemplate;
import sonar.reactorbuilder.util.Translate;

public class UnderhaulSFRTemplate
extends AbstractTemplate {
    public static DictionaryEntry casingSolid = GlobalDictionary.getComponentInfo("sfr_casing");
    public static DictionaryEntry casingGlass = GlobalDictionary.getComponentInfo("sfr_glass");
    @Nullable
    public DictionaryEntry fuel;
    public ItemStack edgeItem = ItemStack.field_190927_a;
    private DictionaryEntry edges = null;

    public UnderhaulSFRTemplate() {
    }

    public UnderhaulSFRTemplate(String fileName, int xSize, int ySize, int zSize, @Nullable DictionaryEntry fuel) {
        super(fileName, xSize, ySize, zSize);
        this.fuel = fuel;
    }

    @Override
    public TemplateType getTemplateType() {
        return TemplateType.UNDERHAUL_SFR;
    }

    @Override
    @Nullable
    public DictionaryEntry getComponent(int x, int y, int z) {
        if (this.isComponent(x, y, z)) {
            return this.blocks[x][y][z];
        }
        if (this.isCasing(x, y, z)) {
            return this.isCasingGlass(x, y, z) ? casingGlass : casingSolid;
        }
        if (this.isEdge(x, y, z)) {
            return this.edges;
        }
        return null;
    }

    @Override
    public int getBuildPasses() {
        return 3;
    }

    @Override
    public String[] getBuildPassNames() {
        return new String[]{Translate.PASS_PLACING_COMPONENTS.t(), Translate.PASS_PLACING_CASINGS.t(), Translate.PASS_PLACING_EDGES.t()};
    }

    @Override
    public int getBuildPassTotal(int buildPass) {
        switch (buildPass) {
            case 0: {
                return this.totalSolidComponents;
            }
            case 1: {
                return this.totalSolidCasing + this.totalGlassCasing;
            }
            case 2: {
                return this.edges == null ? 0 : this.totalEdges;
            }
        }
        return 0;
    }

    @Override
    public boolean canPlaceThisPass(int buildPass, int x, int y, int z, DictionaryEntry info) {
        switch (buildPass) {
            case 0: {
                return info.entryType == DictionaryEntryType.UNDERHAUL_COMPONENT;
            }
            case 1: {
                return info.entryType == DictionaryEntryType.UNDERHAUL_CASING_SOLID || info.entryType == DictionaryEntryType.UNDERHAUL_CASING_GLASS;
            }
            case 2: {
                return info.entryType == DictionaryEntryType.UNDERHAUL_EDGES;
            }
        }
        return false;
    }

    @Override
    public DictionaryEntry getDefaultSolidCasing() {
        return casingSolid;
    }

    @Override
    public DictionaryEntry getDefaultGlassCasing() {
        return casingGlass;
    }

    @Override
    public void updateAdditionalInfo() {
        super.updateAdditionalInfo();
        if (this.totalSolidCasing != 0) {
            this.required.put(casingSolid, this.totalSolidCasing);
        }
        if (this.totalGlassCasing != 0) {
            this.required.put(casingGlass, this.totalGlassCasing);
        }
        DictionaryEntry dictionaryEntry = this.edges = this.edgeItem.func_190926_b() ? null : DictionaryEntry.makeEdgeComponent(this.edgeItem);
        if (this.edges != null) {
            this.required.put(this.edges, this.totalEdges);
        }
    }

    @Override
    public void getStats(Map<String, String> statsMap) {
        statsMap.put(Translate.TEMPLATE_FILE_NAME.t(), this.fileName);
        statsMap.put(Translate.TEMPLATE_REACTOR_TYPE.t(), this.getTemplateType().fileType);
        statsMap.put(Translate.TEMPLATE_DIMENSIONS.t(), this.xSize + " x " + this.ySize + " x " + this.zSize);
        if (this.fuel != null) {
            statsMap.put(Translate.TEMPLATE_FUEL_TYPE.t(), this.fuel.getItemStack().func_82833_r());
        }
        statsMap.put(Translate.TEMPLATE_COMPONENTS.t(), String.valueOf(this.totalSolidComponents));
        statsMap.put(Translate.TEMPLATE_CASING.t(), String.valueOf(this.totalSolidCasing + this.totalGlassCasing));
        statsMap.put(Translate.TEMPLATE_EDGES.t(), String.valueOf(this.totalEdges));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound, boolean array) {
        super.readFromNBT(compound, array);
        this.fuel = DictionaryEntry.readFromNBTSafely(compound.func_74775_l("fuel"));
        this.edgeItem = new ItemStack(compound.func_74775_l("edgeItem"));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound, boolean array) {
        super.writeToNBT(compound, array);
        compound.func_74782_a("fuel", (NBTBase)DictionaryEntry.writeToNBTSafely(new NBTTagCompound(), this.fuel));
        compound.func_74782_a("edgeItem", (NBTBase)this.edgeItem.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public void readHeaderFromBuf(ByteBuf buf) {
        super.readHeaderFromBuf(buf);
        if (buf.readBoolean()) {
            this.fuel = GlobalDictionary.getComponentInfoFromID(buf.readInt());
        }
        this.edgeItem = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    @Override
    public void writeHeaderToBuf(ByteBuf buf) {
        super.writeHeaderToBuf(buf);
        buf.writeBoolean(this.fuel != null);
        if (this.fuel != null) {
            buf.writeInt(this.fuel.globalID);
        }
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.edgeItem);
    }
}

